/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.network.messages;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.handlers.LaunchingDimensionHandler;
import earth.terrarium.adastra.common.network.CodecPacketType;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public record ServerboundLandPacket(class_5321<class_1937> dimension, boolean tryPreviousLocation) implements Packet<ServerboundLandPacket>
{
    public static final ServerboundPacketType<ServerboundLandPacket> TYPE = new Type();

    public PacketType<ServerboundLandPacket> type() {
        return TYPE;
    }

    private static class Type
    extends CodecPacketType<ServerboundLandPacket>
    implements ServerboundPacketType<ServerboundLandPacket> {
        public Type() {
            super(ServerboundLandPacket.class, new class_2960("ad_astra", "land"), ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.DIMENSION.fieldOf(ServerboundLandPacket::dimension), (ObjectEntryByteCodec)ByteCodec.BOOLEAN.fieldOf(ServerboundLandPacket::tryPreviousLocation), ServerboundLandPacket::new));
        }

        public Consumer<class_1657> handle(ServerboundLandPacket packet) {
            return player -> {
                class_3218 targetLevel;
                class_1937 patt2429$temp = player.method_37908();
                if (!(patt2429$temp instanceof class_3218)) {
                    return;
                }
                class_3218 serverLevel = (class_3218)patt2429$temp;
                Planet planet = PlanetApi.API.getPlanet(packet.dimension);
                if (planet == null) {
                    return;
                }
                if (planet.isSpace()) {
                    return;
                }
                if (!ModUtils.canTeleportToPlanet(player, planet)) {
                    return;
                }
                boolean landingNormally = packet.tryPreviousLocation() && player.method_5854() instanceof Rocket;
                class_4208 newPos = landingNormally ? (class_4208)LaunchingDimensionHandler.getSpawningLocation(player, serverLevel, planet).orElse(null) : null;
                MinecraftServer server = serverLevel.method_8503();
                class_3218 class_32182 = targetLevel = newPos == null ? server.method_3847(planet.dimension()) : server.method_3847(newPos.method_19442());
                if (targetLevel == null) {
                    throw new IllegalStateException(String.format("Dimension %s does not exist! Try restarting your %s!", planet.dimension(), server.method_3816() ? "server" : "singleplayer world"));
                }
                LaunchingDimensionHandler.addSpawnLocation(player, serverLevel);
                class_2338 targetPos = newPos != null ? newPos.method_19446() : player.method_24515();
                ModUtils.land((class_3222)player, targetLevel, new class_243((double)targetPos.method_10263(), (double)AdAstraConfig.atmosphereLeave, (double)targetPos.method_10260()));
            };
        }
    }
}

