/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import dev.djefrey.colorwheel.engine.ClrwlVertex;
import dev.djefrey.colorwheel.engine.ClrwlVertexView;
import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.api.vertex.MutableVertexList;
import dev.engine_room.flywheel.backend.engine.IndexPool;
import dev.engine_room.flywheel.backend.gl.GlPrimitive;
import dev.engine_room.flywheel.backend.gl.array.GlVertexArray;
import dev.engine_room.flywheel.backend.gl.buffer.GlBuffer;
import dev.engine_room.flywheel.backend.gl.buffer.GlBufferUsage;
import dev.engine_room.flywheel.backend.util.ReferenceCounted;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.QuadMesh;
import dev.engine_room.flywheel.lib.model.RetexturedMesh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.irisshaders.iris.vertices.NormalHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL32;

public class ClrwlMeshPool {
    private final ClrwlVertexView vertexView;
    private final Map<Mesh, PooledMesh> meshes = new HashMap<Mesh, PooledMesh>();
    private final List<PooledMesh> meshList = new ArrayList<PooledMesh>();
    private final List<PooledMesh> recentlyAllocated = new ArrayList<PooledMesh>();
    private final GlBuffer vbo;
    private final IndexPool indexPool;
    private boolean dirty;
    private boolean anyToRemove;

    public ClrwlMeshPool() {
        this.vertexView = ClrwlVertex.createVertexView();
        this.vbo = new GlBuffer(GlBufferUsage.DYNAMIC_DRAW);
        this.indexPool = new IndexPool();
    }

    public PooledMesh alloc(Mesh mesh) {
        return this.meshes.computeIfAbsent(mesh, this::_alloc);
    }

    private PooledMesh _alloc(Mesh m) {
        PooledMesh bufferedModel = new PooledMesh(m);
        this.meshList.add(bufferedModel);
        this.recentlyAllocated.add(bufferedModel);
        this.dirty = true;
        return bufferedModel;
    }

    @Nullable
    public PooledMesh get(Mesh mesh) {
        return this.meshes.get(mesh);
    }

    public void flush() {
        if (!this.dirty) {
            return;
        }
        if (this.anyToRemove) {
            this.anyToRemove = false;
            this.processDeletions();
        }
        if (!this.recentlyAllocated.isEmpty()) {
            for (PooledMesh mesh : this.recentlyAllocated) {
                this.indexPool.updateCount(mesh.mesh.indexSequence(), mesh.indexCount());
            }
            this.indexPool.flush();
            this.recentlyAllocated.clear();
        }
        this.uploadAll();
        this.dirty = false;
    }

    private void processDeletions() {
        this.meshList.removeIf(pooledMesh -> {
            boolean deleted = pooledMesh.isDeleted();
            if (deleted) {
                this.meshes.remove(pooledMesh.mesh);
            }
            return deleted;
        });
    }

    private void uploadAll() {
        long neededSize = 0L;
        for (PooledMesh mesh : this.meshList) {
            neededSize += (long)mesh.byteSize();
        }
        MemoryBlock vertexBlock = MemoryBlock.malloc((long)neededSize);
        long vertexPtr = vertexBlock.ptr();
        int byteIndex = 0;
        int baseVertex = 0;
        for (PooledMesh mesh : this.meshList) {
            mesh.baseVertex = baseVertex;
            this.vertexView.ptr(vertexPtr + (long)byteIndex);
            this.vertexView.vertexCount(mesh.vertexCount());
            mesh.mesh.write((MutableVertexList)this.vertexView);
            mesh.meshCenter = this.computeMeshCenter(this.vertexView);
            if (!this.vertexView.consumeExtendedWriteFlag()) {
                Mesh baseMesh = mesh.mesh;
                while (baseMesh instanceof RetexturedMesh) {
                    RetexturedMesh retextured = (RetexturedMesh)baseMesh;
                    baseMesh = retextured.mesh();
                }
                if (baseMesh instanceof QuadMesh) {
                    QuadMesh quad = (QuadMesh)baseMesh;
                    this.computeExtendedQuadData(quad, this.vertexView);
                } else {
                    this.computeExtendedData(baseMesh, this.vertexView);
                }
            } else {
                this.patchMidUVCoords(mesh.mesh, this.vertexView);
            }
            byteIndex += mesh.byteSize();
            baseVertex += mesh.vertexCount();
        }
        this.vbo.upload(vertexBlock);
        vertexBlock.free();
    }

    private Vector3f computeMeshCenter(ClrwlVertexView vertexView) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        for (int i = 0; i < vertexView.vertexCount(); ++i) {
            float x = vertexView.x(i);
            float y = vertexView.y(i);
            float z = vertexView.z(i);
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (!(z > maxZ)) continue;
            maxZ = z;
        }
        return new Vector3f((minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f);
    }

    private void computeExtendedQuadData(QuadMesh mesh, ClrwlVertexView vertexView) {
        int quadCnt = mesh.vertexCount() / 4;
        float[] uArr = new float[4];
        float[] vArr = new float[4];
        int uvCnt = 0;
        for (int q = 0; q < quadCnt; ++q) {
            int base = q * 4;
            float normalX = 0.0f;
            float normalY = 0.0f;
            float normalZ = 0.0f;
            uvCnt = 0;
            block1: for (int vId = 0; vId < 4; ++vId) {
                int idx = base + vId;
                normalX += vertexView.normalX(idx);
                normalY += vertexView.normalY(idx);
                normalZ += vertexView.normalZ(idx);
                float u = vertexView.u(idx);
                float v = vertexView.v(idx);
                for (int i = 0; i < uvCnt; ++i) {
                    if (uArr[i] == u && vArr[i] == v) continue block1;
                }
                uArr[uvCnt] = u;
                vArr[uvCnt] = v;
                ++uvCnt;
            }
            normalX /= 4.0f;
            normalY /= 4.0f;
            normalZ /= 4.0f;
            float midU = 0.0f;
            float midV = 0.0f;
            for (int i = 0; i < uvCnt; ++i) {
                midU += uArr[i];
                midV += vArr[i];
            }
            midU /= (float)uvCnt;
            midV /= (float)uvCnt;
            int tangent = NormalHelper.computeTangent((float)normalX, (float)normalY, (float)normalZ, (float)vertexView.x(base + 0), (float)vertexView.y(base + 0), (float)vertexView.z(base + 0), (float)vertexView.u(base + 0), (float)vertexView.v(base + 0), (float)vertexView.x(base + 1), (float)vertexView.y(base + 1), (float)vertexView.z(base + 1), (float)vertexView.u(base + 1), (float)vertexView.v(base + 1), (float)vertexView.x(base + 2), (float)vertexView.y(base + 2), (float)vertexView.z(base + 2), (float)vertexView.u(base + 2), (float)vertexView.v(base + 2));
            for (int vId = 0; vId < 4; ++vId) {
                vertexView.packedEntity(base + vId, -1);
                vertexView.midU(base + vId, midU);
                vertexView.midV(base + vId, midV);
                vertexView.packedTangent(base + vId, tangent);
                vertexView.packedMidBlock(base + vId, -16777216);
            }
        }
    }

    private void computeExtendedData(Mesh mesh, ClrwlVertexView vertexView) {
        for (int i = 0; i < mesh.vertexCount(); ++i) {
            vertexView.packedEntity(i, -1);
            vertexView.midU(i, 0.0f);
            vertexView.midV(i, 0.0f);
            vertexView.packedTangent(i, 0);
            vertexView.packedMidBlock(i, -16777216);
        }
    }

    private void patchMidUVCoords(Mesh mesh, ClrwlVertexView vertexView) {
        int quadCnt = mesh.vertexCount() / 4;
        float[] uArr = new float[4];
        float[] vArr = new float[4];
        int uvCnt = 0;
        for (int q = 0; q < quadCnt; ++q) {
            int base = q * 4;
            uvCnt = 0;
            block1: for (int vId = 0; vId < 4; ++vId) {
                int idx = base + vId;
                float u = vertexView.u(idx);
                float v = vertexView.v(idx);
                for (int i = 0; i < uvCnt; ++i) {
                    if (uArr[i] == u && vArr[i] == v) continue block1;
                }
                uArr[uvCnt] = u;
                vArr[uvCnt] = v;
                ++uvCnt;
            }
            float midU = 0.0f;
            float midV = 0.0f;
            for (int i = 0; i < uvCnt; ++i) {
                midU += uArr[i];
                midV += vArr[i];
            }
            midU /= (float)uvCnt;
            midV /= (float)uvCnt;
            for (int vId = 0; vId < 4; ++vId) {
                vertexView.midU(base + vId, midU);
                vertexView.midV(base + vId, midV);
            }
        }
    }

    public void bind(GlVertexArray vertexArray) {
        this.indexPool.bind(vertexArray);
        vertexArray.bindVertexBuffer(0, this.vbo.handle(), 0L, ClrwlVertex.STRIDE);
        vertexArray.bindAttributes(0, 0, ClrwlVertex.ATTRIBUTES);
    }

    public void delete() {
        this.vbo.delete();
        this.indexPool.delete();
        this.meshes.clear();
        this.meshList.clear();
    }

    public class PooledMesh
    extends ReferenceCounted {
        public static final int INVALID_BASE_VERTEX = -1;
        private final Mesh mesh;
        private Vector3f meshCenter;
        private int baseVertex = -1;

        private PooledMesh(Mesh mesh) {
            this.mesh = mesh;
            this.meshCenter = new Vector3f(0.0f, 0.0f, 0.0f);
        }

        public int vertexCount() {
            return this.mesh.vertexCount();
        }

        public int byteSize() {
            return this.mesh.vertexCount() * ClrwlVertex.STRIDE;
        }

        public int indexCount() {
            return this.mesh.indexCount();
        }

        public int baseVertex() {
            return this.baseVertex;
        }

        public int firstIndex() {
            return ClrwlMeshPool.this.indexPool.firstIndex(this.mesh.indexSequence());
        }

        public long firstIndexByteOffset() {
            return (long)this.firstIndex() * 4L;
        }

        public boolean isInvalid() {
            return this.mesh.vertexCount() == 0 || this.baseVertex == -1 || this.isDeleted();
        }

        public Vector4fc boundingSphere() {
            return this.mesh.boundingSphere();
        }

        public Vector3fc meshCenter() {
            return this.meshCenter;
        }

        public void draw(int instanceCount) {
            if (instanceCount > 1) {
                GL32.glDrawElementsInstancedBaseVertex((int)GlPrimitive.TRIANGLES.glEnum, (int)this.mesh.indexCount(), (int)5125, (long)this.firstIndexByteOffset(), (int)instanceCount, (int)this.baseVertex);
            } else {
                GL32.glDrawElementsBaseVertex((int)GlPrimitive.TRIANGLES.glEnum, (int)this.mesh.indexCount(), (int)5125, (long)this.firstIndexByteOffset(), (int)this.baseVertex);
            }
        }

        protected void _delete() {
            ClrwlMeshPool.this.dirty = true;
            ClrwlMeshPool.this.anyToRemove = true;
        }
    }
}

