/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.djefrey.colorwheel.ClrwlSamplers;
import dev.djefrey.colorwheel.accessors.IrisRenderingPipelineAccessor;
import dev.djefrey.colorwheel.compile.oit.ClrwlOitPrograms;
import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.djefrey.colorwheel.engine.ClrwlOitAccumulateOverride;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramGroup;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import dev.djefrey.colorwheel.util.Utils;
import dev.engine_room.flywheel.backend.NoiseTextures;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.backend.gl.GlTextureUnit;
import dev.engine_room.flywheel.lib.math.MoreMath;
import java.util.List;
import java.util.Optional;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.BlendMode;
import net.irisshaders.iris.gl.blending.BlendModeFunction;
import net.irisshaders.iris.gl.blending.BufferBlendInformation;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.texture.InternalTextureFormat;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.shaderpack.properties.ProgramDirectives;
import net.irisshaders.iris.targets.RenderTargets;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL46;

public class ClrwlOitFramebuffers {
    public static final float[] CLEAR_TO_ZERO = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public static final int[] DEPTH_RANGE_DRAW_BUFFERS = new int[]{36064};
    public static final int[] DEPTH_ONLY_DRAW_BUFFERS = new int[0];
    private final int[] programDrawBuffers;
    private int[] renderTransmittanceDrawBuffers;
    private int[] accumulateDrawBuffers;
    private final ClrwlProgramGroup programGroup;
    private final ClrwlOitPrograms programs;
    private final IrisRenderingPipeline irisPipeline;
    private final ClrwlShaderProperties properties;
    private final int vao;
    public int mainFbo = -1;
    public int coeffsFbo = -1;
    public int depthBounds = -1;
    public int[] coefficients;
    public int[] accumulate;
    private int lastWidth = -1;
    private int lastHeight = -1;

    public ClrwlOitFramebuffers(ClrwlProgramGroup programGroup, ClrwlOitPrograms programs, IrisRenderingPipeline irisPipeline, ClrwlShaderProperties properties, ProgramDirectives directives) {
        this.programGroup = programGroup;
        this.programs = programs;
        this.irisPipeline = irisPipeline;
        this.properties = properties;
        this.programDrawBuffers = directives.getDrawBuffers();
        this.vao = GlCompat.SUPPORTS_DSA ? GL46.glCreateVertexArrays() : GL32.glGenVertexArrays();
    }

    public void delete() {
        this.deleteTextures();
        GL32.glDeleteVertexArrays((int)this.vao);
    }

    private void deleteTextures() {
        if (this.depthBounds != -1) {
            GL32.glDeleteTextures((int)this.depthBounds);
            this.depthBounds = -1;
        }
        if (this.coefficients != null) {
            for (int i = 0; i < this.coefficients.length; ++i) {
                ClrwlSamplers.getCoefficient(i).makeActive();
                RenderSystem.bindTexture((int)0);
            }
            GL32.glDeleteTextures((int[])this.coefficients);
            this.coefficients = null;
        }
        if (this.accumulate != null) {
            GL32.glDeleteTextures((int[])this.accumulate);
            this.accumulate = null;
        }
        if (this.mainFbo != -1) {
            GL32.glDeleteFramebuffers((int)this.mainFbo);
            this.mainFbo = -1;
        }
        if (this.coeffsFbo != -1) {
            GL32.glDeleteFramebuffers((int)this.coeffsFbo);
            this.coeffsFbo = -1;
        }
        ClrwlSamplers.DEPTH_RANGE.makeActive();
        RenderSystem.bindTexture((int)0);
    }

    public void prepare() {
        int width;
        int depthTexture;
        this.maybeResizeFBOS(width, switch (this.programGroup) {
            case ClrwlProgramGroup.GBUFFERS -> {
                RenderTargets targets = ((IrisRenderingPipelineAccessor)this.irisPipeline).colorwheel$getGbuffersRenderTargets();
                depthTexture = targets.getDepthTexture();
                width = targets.getCurrentWidth();
                yield targets.getCurrentHeight();
            }
            case ClrwlProgramGroup.SHADOW -> {
                RenderTargets targets = ((IrisRenderingPipelineAccessor)this.irisPipeline).colorwheel$getShadowRenderTargets();
                depthTexture = targets.getDepthTexture().getTextureId();
                width = targets.getResolution();
                yield targets.getResolution();
            }
            default -> throw new RuntimeException("Unknown program group: " + String.valueOf((Object)this.programGroup));
        });
        if (this.coeffsFbo != -1) {
            for (int i = 0; i < this.coefficients.length; ++i) {
                int buffer = this.coefficients[i];
                ClrwlSamplers.getCoefficient(i).makeActive();
                RenderSystem.bindTexture((int)0);
                GL32.glBindTexture((int)35866, (int)buffer);
            }
        }
        ClrwlSamplers.DEPTH_RANGE.makeActive();
        RenderSystem.bindTexture((int)this.depthBounds);
        ClrwlSamplers.NOISE.makeActive();
        NoiseTextures.BLUE_NOISE.method_23207();
        if (this.coeffsFbo != -1) {
            GlStateManager._glBindFramebuffer((int)36160, (int)this.coeffsFbo);
            GL32.glFramebufferTexture((int)36160, (int)36096, (int)depthTexture, (int)0);
        }
        GlStateManager._glBindFramebuffer((int)36160, (int)this.mainFbo);
        GL32.glFramebufferTexture((int)36160, (int)36096, (int)depthTexture, (int)0);
    }

    public void prepareDepthRange() {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation((int)32776);
        float far = class_310.method_1551().field_1773.method_32796();
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.mainFbo, (int[])DEPTH_RANGE_DRAW_BUFFERS);
            GL46.glClearNamedFramebufferfv((int)this.mainFbo, (int)6144, (int)0, (float[])new float[]{-far, -far, 0.0f, 0.0f});
        } else {
            GL32.glDrawBuffers((int[])DEPTH_RANGE_DRAW_BUFFERS);
            RenderSystem.clearColor((float)(-far), (float)(-far), (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)false);
        }
    }

    public boolean prepareRenderTransmittance() {
        if (this.coeffsFbo == -1) {
            return false;
        }
        GlStateManager._glBindFramebuffer((int)36160, (int)this.coeffsFbo);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation((int)32774);
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.coeffsFbo, (int[])this.renderTransmittanceDrawBuffers);
            for (int i = 0; i < this.renderTransmittanceDrawBuffers.length; ++i) {
                GL46.glClearNamedFramebufferfv((int)this.coeffsFbo, (int)6144, (int)i, (float[])CLEAR_TO_ZERO);
            }
        } else {
            GL32.glDrawBuffers((int[])this.renderTransmittanceDrawBuffers);
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)false);
        }
        return true;
    }

    public void prepareAccumulate() {
        GlStateManager._glBindFramebuffer((int)36160, (int)this.mainFbo);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation((int)32774);
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.mainFbo, (int[])this.accumulateDrawBuffers);
            for (int i = 0; i < this.accumulateDrawBuffers.length; ++i) {
                GL46.glClearNamedFramebufferfv((int)this.mainFbo, (int)6144, (int)i, (float[])CLEAR_TO_ZERO);
            }
        } else {
            GL32.glDrawBuffers((int[])this.accumulateDrawBuffers);
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)false);
        }
    }

    public void composite(GlFramebuffer target, @Nullable ClrwlBlendModeOverride blendModeOverride, List<BufferBlendInformation> bufferBlendOverrides) {
        target.bind();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        BlendMode blendMode = blendModeOverride == null ? new BlendMode(BlendModeFunction.SRC_ALPHA.getGlId(), BlendModeFunction.ONE_MINUS_SRC_ALPHA.getGlId(), BlendModeFunction.ONE.getGlId(), BlendModeFunction.ONE_MINUS_SRC_ALPHA.getGlId()) : blendModeOverride.blendMode();
        if (blendMode == null) {
            RenderSystem.disableBlend();
        } else {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)blendMode.srcRgb(), (int)blendMode.dstRgb(), (int)blendMode.srcAlpha(), (int)blendMode.dstAlpha());
            RenderSystem.blendEquation((int)32774);
        }
        for (BufferBlendInformation entry : bufferBlendOverrides) {
            if (entry.blendMode() == null) {
                IrisRenderSystem.disableBufferBlend((int)entry.index());
                continue;
            }
            IrisRenderSystem.enableBufferBlend((int)entry.index());
            IrisRenderSystem.blendFuncSeparatei((int)entry.index(), (int)entry.blendMode().srcRgb(), (int)entry.blendMode().dstRgb(), (int)entry.blendMode().srcAlpha(), (int)entry.blendMode().dstAlpha());
        }
        RenderSystem.depthFunc((int)519);
        for (int i = 0; i < this.accumulate.length; ++i) {
            ClrwlSamplers.getAccumulate(i).makeActive();
            RenderSystem.bindTexture((int)this.accumulate[i]);
        }
        int[] ranks = this.properties.getOitCoeffRanks(this.programGroup);
        List<ClrwlOitAccumulateOverride> overrides = this.properties.getOitAccumulateOverrides(this.programGroup);
        this.programs.getOitCompositeProgram(this.programDrawBuffers, ranks, overrides).bind();
        this.drawFullscreenQuad();
    }

    private void drawFullscreenQuad() {
        GlStateManager._glBindVertexArray((int)this.vao);
        GL32.glDrawArrays((int)4, (int)0, (int)3);
    }

    private void maybeResizeFBOS(int width, int height) {
        if (this.lastWidth == width && this.lastHeight == height) {
            return;
        }
        this.lastWidth = width;
        this.lastHeight = height;
        this.deleteTextures();
        this.resizeMainFBO(width, height);
        this.resizeCoeffsFBO(width, height);
    }

    private void resizeMainFBO(int width, int height) {
        List<ClrwlOitAccumulateOverride> overrides = this.properties.getOitAccumulateOverrides(this.programGroup);
        int accumulateCnt = this.programDrawBuffers.length;
        this.mainFbo = GL46.glCreateFramebuffers();
        this.accumulate = new int[accumulateCnt];
        this.accumulateDrawBuffers = new int[accumulateCnt];
        if (GlCompat.SUPPORTS_DSA) {
            int i;
            this.depthBounds = GL46.glCreateTextures((int)3553);
            GL46.glTextureStorage2D((int)this.depthBounds, (int)1, (int)33328, (int)width, (int)height);
            for (i = 0; i < accumulateCnt; ++i) {
                int drawBuffer = this.programDrawBuffers[i];
                InternalTextureFormat format = InternalTextureFormat.RGBA16F;
                Optional<ClrwlOitAccumulateOverride> maybeOverride = Utils.findFirst(overrides, e -> e.drawBuffer() == drawBuffer);
                if (maybeOverride.isPresent()) {
                    format = maybeOverride.get().format();
                }
                int buffer = GL46.glCreateTextures((int)3553);
                GL46.glTextureStorage2D((int)buffer, (int)1, (int)format.getGlFormat(), (int)width, (int)height);
                this.accumulate[i] = buffer;
            }
            GL46.glNamedFramebufferTexture((int)this.mainFbo, (int)36064, (int)this.depthBounds, (int)0);
            for (i = 0; i < accumulateCnt; ++i) {
                GL46.glNamedFramebufferTexture((int)this.mainFbo, (int)(36065 + i), (int)this.accumulate[i], (int)0);
                this.accumulateDrawBuffers[i] = 36065 + i;
            }
        } else {
            int i;
            this.depthBounds = GL32.glGenTextures();
            GlTextureUnit.T0.makeActive();
            RenderSystem.bindTexture((int)0);
            GL32.glBindTexture((int)3553, (int)this.depthBounds);
            GL32.glTexImage2D((int)3553, (int)0, (int)33328, (int)width, (int)height, (int)0, (int)6408, (int)5120, (long)0L);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL32.glTexParameteri((int)3553, (int)10243, (int)33071);
            for (i = 0; i < accumulateCnt; ++i) {
                int drawBuffer = this.programDrawBuffers[i];
                InternalTextureFormat format = InternalTextureFormat.RGBA16F;
                Optional<ClrwlOitAccumulateOverride> maybeOverride = Utils.findFirst(overrides, e -> e.drawBuffer() == drawBuffer);
                if (maybeOverride.isPresent()) {
                    format = maybeOverride.get().format();
                }
                int buffer = GL32.glGenTextures();
                GL32.glBindTexture((int)3553, (int)buffer);
                GL32.glTexImage2D((int)3553, (int)0, (int)format.getGlFormat(), (int)width, (int)height, (int)0, (int)format.getPixelFormat().getGlFormat(), (int)1029, (long)0L);
                GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
                GL32.glTexParameteri((int)3553, (int)10243, (int)33071);
                this.accumulate[i] = buffer;
            }
            GlStateManager._glBindFramebuffer((int)36160, (int)this.mainFbo);
            GL46.glFramebufferTexture((int)36160, (int)36064, (int)this.depthBounds, (int)0);
            for (i = 0; i < accumulateCnt; ++i) {
                GL46.glFramebufferTexture((int)36160, (int)(36065 + i), (int)this.accumulate[i], (int)0);
                this.accumulateDrawBuffers[i] = 36065 + i;
            }
        }
    }

    private void resizeCoeffsFBO(int width, int height) {
        int[] coeffRanks = this.properties.getOitCoeffRanks(this.programGroup);
        int coeffCnt = coeffRanks.length;
        if (coeffCnt == 0) {
            return;
        }
        if (GlCompat.SUPPORTS_DSA) {
            int depth;
            this.coeffsFbo = GL46.glCreateFramebuffers();
            this.coefficients = new int[coeffCnt];
            int coeffsSum = 0;
            for (int i = 0; i < coeffCnt; ++i) {
                int rank = coeffRanks[i];
                int buffer = GL46.glCreateTextures((int)35866);
                depth = MoreMath.ceilingDiv((int)(1 << rank + 1), (int)4);
                GL46.glTextureStorage3D((int)buffer, (int)1, (int)34842, (int)width, (int)height, (int)depth);
                this.coefficients[i] = buffer;
                coeffsSum += depth;
            }
            this.renderTransmittanceDrawBuffers = new int[coeffsSum];
            int transmittanceIdx = 0;
            for (int i = 0; i < coeffCnt; ++i) {
                int rank = coeffRanks[i];
                depth = MoreMath.ceilingDiv((int)(1 << rank + 1), (int)4);
                for (int j = 0; j < depth; ++j) {
                    GL46.glNamedFramebufferTextureLayer((int)this.coeffsFbo, (int)(36064 + transmittanceIdx), (int)this.coefficients[i], (int)0, (int)j);
                    this.renderTransmittanceDrawBuffers[transmittanceIdx] = 36064 + transmittanceIdx;
                    ++transmittanceIdx;
                }
            }
        } else {
            int depth;
            this.coeffsFbo = GL46.glGenFramebuffers();
            this.coefficients = new int[coeffCnt];
            int coeffsSum = 0;
            for (int i = 0; i < coeffCnt; ++i) {
                int rank = coeffRanks[i];
                int buffer = GL32.glGenTextures();
                depth = MoreMath.ceilingDiv((int)(1 << rank + 1), (int)4);
                GL32.glBindTexture((int)35866, (int)buffer);
                GL32.glTexImage3D((int)35866, (int)0, (int)34842, (int)width, (int)height, (int)depth, (int)0, (int)6408, (int)5120, (long)0L);
                GL32.glTexParameteri((int)35866, (int)10241, (int)9728);
                GL32.glTexParameteri((int)35866, (int)10240, (int)9728);
                GL32.glTexParameteri((int)35866, (int)10242, (int)33071);
                GL32.glTexParameteri((int)35866, (int)10243, (int)33071);
                this.coefficients[i] = buffer;
                coeffsSum += depth;
            }
            GlStateManager._glBindFramebuffer((int)36160, (int)this.coeffsFbo);
            this.renderTransmittanceDrawBuffers = new int[coeffsSum];
            int transmittanceIdx = 0;
            for (int i = 0; i < coeffCnt; ++i) {
                int rank = coeffRanks[i];
                depth = MoreMath.ceilingDiv((int)(1 << rank + 1), (int)4);
                for (int j = 0; j < depth; ++j) {
                    GL46.glFramebufferTextureLayer((int)36160, (int)(36064 + transmittanceIdx), (int)this.coefficients[i], (int)0, (int)j);
                    this.renderTransmittanceDrawBuffers[transmittanceIdx] = 36064 + transmittanceIdx;
                    ++transmittanceIdx;
                }
            }
        }
    }
}

