/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.FarmersDelightCompat;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2527;
import net.minecraft.class_2555;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class BlockScanner {
    private static BlockScanner INSTANCE = null;
    private final Set<class_2248> lanterns;
    private final Set<class_2248> torches;
    private final Set<class_2248> candleHolders;
    private final Set<class_2248> fdSigns;

    public static BlockScanner getInstance() {
        if (INSTANCE == null) {
            Amendments.LOGGER.debug("Scanning blocks for Amendments");
            INSTANCE = new BlockScanner();
        }
        return INSTANCE;
    }

    private BlockScanner() {
        ImmutableSet.Builder lanternBuilder = ImmutableSet.builder();
        ImmutableSet.Builder torchesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder candleBuilder = ImmutableSet.builder();
        ImmutableSet.Builder fdSignsBuilder = ImmutableSet.builder();
        for (class_2248 block : class_7923.field_41175) {
            if (WallLanternBlock.isValidBlock(block)) {
                lanternBuilder.add((Object)block);
                continue;
            }
            if (block instanceof class_2527 && !(block instanceof class_2555) || CompatHandler.SUPPLEMENTARIES && SuppCompat.isSconce(block)) {
                torchesBuilder.add((Object)block);
                continue;
            }
            if (CompatHandler.SUPPLEMENTARIES && SuppCompat.isCandleHolder(block)) {
                candleBuilder.add((Object)block);
                continue;
            }
            if (!CompatHandler.FARMERS_DELIGHT || !FarmersDelightCompat.isStandingSign(block)) continue;
            fdSignsBuilder.add((Object)block);
        }
        torchesBuilder.add((Object)class_2246.field_10523);
        this.lanterns = lanternBuilder.build();
        this.torches = torchesBuilder.build();
        this.candleHolders = candleBuilder.build();
        this.fdSigns = fdSignsBuilder.build();
    }

    @NotNull
    public Set<class_2248> getLanterns() {
        return this.lanterns;
    }

    @NotNull
    public Set<class_2248> getTorches() {
        return this.torches;
    }

    @NotNull
    public Set<class_2248> getCandleHolders() {
        return this.candleHolders;
    }

    public Set<class_2248> getFdSigns() {
        return this.fdSigns;
    }
}

