/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipe;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class CauldronCraftingContainer
implements class_8566 {
    private final List<class_1799> originalItems;
    private final class_2371<class_1799> items;
    private final SoftFluidStack fluid;
    private final int fluidContainerSize;
    private final Multimap<FluidContainerList.Category, class_1799> equivalentFluidContainers;
    private final int dimension;
    private final int fluidPosition;
    private final boolean isBoiling;
    private static final FluidContainerList.Category DUMMY_WATER_BOWL_CATEGORY = (FluidContainerList.Category)class_156.method_656(() -> {
        JsonElement j = JsonParser.parseString((String)("{\n    \"capacity\":" + SoftFluid.BOWL_COUNT + ",        \"empty\": \"minecraft:bowl\",\n        \"filled\": [\n        \"minecraft:mushroom_stew\"\n        ]\n    }\n"));
        return (FluidContainerList.Category)((Pair)FluidContainerList.Category.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)j).getOrThrow(false, s -> {})).getFirst();
    });

    private CauldronCraftingContainer(int fluidContainerSize, SoftFluidStack fluidStack, Collection<class_1799> items, int fluidPosition, boolean isBoiling) {
        this.dimension = class_3532.method_15384((double)Math.sqrt(items.size() + 1));
        this.originalItems = List.copyOf(items);
        this.items = class_2371.method_10213((int)(this.dimension * this.dimension), (Object)class_1799.field_8037);
        this.fluid = fluidStack;
        this.equivalentFluidContainers = fluidStack.toAllPossibleFilledItems();
        if (fluidStack.is((class_6880)BuiltInSoftFluids.WATER)) {
            this.equivalentFluidContainers.put((Object)DUMMY_WATER_BOWL_CATEGORY, (Object)class_1802.field_8428.method_7854());
        }
        this.fluidPosition = fluidPosition;
        Preconditions.checkArgument((fluidPosition <= items.size() ? 1 : 0) != 0);
        this.fluidContainerSize = fluidContainerSize;
        this.isBoiling = isBoiling;
    }

    private Collection<class_1799> splitItems(Collection<class_1799> items) {
        return null;
    }

    public static CauldronCraftingContainer surround8(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, class_1799 item) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, List.of(item, item, item, item, item, item, item, item), 4, boiling);
    }

    public static CauldronCraftingContainer of(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, Collection<class_1799> items) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, items, items.size(), boiling);
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        return this.items.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        if (slot >= this.method_5439()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.items.get(slot);
    }

    public int method_17398() {
        return this.dimension;
    }

    public int method_17397() {
        return this.dimension;
    }

    public List<class_1799> method_51305() {
        return this.items;
    }

    public SoftFluidStack getFluid() {
        return this.fluid;
    }

    public int getMaxAllowedFluidCount() {
        return this.fluidContainerSize;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
    }

    public void method_7683(class_1662 helper) {
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCauldronRecipes(class_1937 level) {
        for (int j = 0; j < this.originalItems.size(); ++j) {
            this.items.set(j, (Object)this.originalItems.get(j));
        }
        List recipes = level.method_8433().method_17877(ModRegistry.CAULDRON_RECIPE_TYPE.get(), (class_1263)this, level);
        for (CauldronRecipe r : recipes) {
            if (!r.matches(this, level)) continue;
            FluidAndItemCraftResult resultFluid = r.assembleFluid(this, level.method_30349());
            class_2371 remainingItems = r.method_8111((class_1263)this);
            if (!remainingItems.stream().allMatch(class_1799::method_7960)) continue;
            return resultFluid;
        }
        return null;
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCraftingRecipes(class_1937 level) {
        for (Map.Entry cont : this.equivalentFluidContainers.entries()) {
            FluidContainerList.Category category = (FluidContainerList.Category)cont.getKey();
            class_1799 fluidInBottle = (class_1799)cont.getValue();
            this.setupFluidItem(fluidInBottle);
            List recipes = level.method_8433().method_17877(class_3956.field_17545, (class_1263)this, level);
            for (class_3955 r : recipes) {
                class_1799 craftedItem;
                int newFluidCount;
                if (!r.method_8115((class_1263)this, level) || (newFluidCount = this.fluid.getCount() - category.getCapacity()) < 0 || newFluidCount > this.fluidContainerSize || (craftedItem = r.method_8116((class_1263)this, level.method_30349())).method_7960()) continue;
                class_2371 remainingItems = r.method_8111((class_1263)this);
                class_1792 emptyContainer = category.getEmptyContainer();
                if (remainingItems.stream().allMatch(class_1799::method_7960)) {
                    FluidContainerList.Category catt;
                    if (fluidInBottle.method_31574(class_1802.field_8150)) {
                        return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
                    }
                    Pair equivalentFluid = SoftFluidStack.fromItem((class_1799)craftedItem);
                    if (equivalentFluid == null || (catt = (FluidContainerList.Category)equivalentFluid.getSecond()).getEmptyContainer() != emptyContainer) continue;
                    SoftFluidStack f = (SoftFluidStack)equivalentFluid.getFirst();
                    return FluidAndItemCraftResult.of(class_1799.field_8037, f.copyWithCount(this.fluid.getCount()));
                }
                if (!remainingItems.stream().allMatch(i -> i.method_7960() || i.method_7909() == emptyContainer)) continue;
                return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
            }
        }
        return null;
    }

    private void setupFluidItem(class_1799 filledFluidBottle) {
        this.items.clear();
        int j = 0;
        for (class_1799 item : this.originalItems) {
            if (j == this.fluidPosition) {
                ++j;
            }
            this.items.set(j, (Object)item);
            ++j;
        }
        this.items.set(this.fluidPosition, (Object)filledFluidBottle);
    }

    public boolean isBoiling() {
        return this.isBoiling;
    }
}

