/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.amendments.common.recipe.CauldronCraftingContainer;
import net.mehvahdjukaar.amendments.common.recipe.CompactItemSet;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemsCraftResult;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CauldronRecipeUtils {
    @Nullable
    public static FluidAndItemsCraftResult craftMultiple(class_1937 level, boolean boiling, int tankCapacity, SoftFluidStack currentFluid, List<class_1799> inputItems) {
        FluidAndItemCraftResult currentResult;
        boolean success = false;
        CompactItemSet craftedItems = new CompactItemSet();
        do {
            if ((currentResult = CauldronRecipeUtils.craft(level, boiling, tankCapacity, currentFluid, inputItems)) == null) continue;
            success = true;
            currentFluid = currentResult.resultFluid();
            craftedItems.add(currentResult.craftedItem());
        } while (currentResult != null);
        if (!success) {
            return null;
        }
        return FluidAndItemsCraftResult.of(craftedItems.toList(), currentFluid);
    }

    @Nullable
    public static FluidAndItemCraftResult craft(class_1937 level, boolean boiling, int tankCapacity, SoftFluidStack fluidStack, List<class_1799> items) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        FluidAndItemCraftResult crafted = CauldronRecipeUtils.craftFluidSpecial(level, boiling, tankCapacity, fluidStack, items);
        if (crafted != null) {
            return crafted;
        }
        if (boiling || !fluidStack.is((class_6880)BuiltInSoftFluids.WATER)) {
            crafted = CauldronRecipeUtils.craftItemSingle(level, boiling, tankCapacity, fluidStack, items);
            if (crafted != null) {
                return crafted;
            }
            crafted = CauldronRecipeUtils.craftItemSplit(level, boiling, tankCapacity, fluidStack, items);
            if (crafted != null) {
                return crafted;
            }
            if (items.size() == 1) {
                crafted = CauldronRecipeUtils.craftItemSurround(level, boiling, tankCapacity, fluidStack, items.get(0));
                return crafted;
            }
        }
        return null;
    }

    private static List<class_1799> expandItems(List<class_1799> items) {
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        for (class_1799 stack : items) {
            int count = stack.method_7947();
            for (int i = 0; i < count; ++i) {
                itemList.add(stack.method_46651(1));
            }
        }
        return itemList;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSingle(class_1937 level, boolean boiling, int tankCapacity, SoftFluidStack fluid, Collection<class_1799> item) {
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, fluid, item);
        FluidAndItemCraftResult result = container.craftWithCraftingRecipes(level);
        if (result != null) {
            for (class_1799 i : item) {
                if (i.method_7960()) continue;
                i.method_7934(1);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSplit(class_1937 level, boolean boiling, int tankCapacity, SoftFluidStack fluid, Collection<class_1799> item) {
        List<class_1799> expandedItems = CauldronRecipeUtils.expandItems(new ArrayList<class_1799>(item));
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, fluid, expandedItems);
        FluidAndItemCraftResult result = container.craftWithCraftingRecipes(level);
        if (result != null) {
            block0: for (class_1799 i : expandedItems) {
                if (i.method_7960()) continue;
                for (class_1799 orig : item) {
                    if (!class_1799.method_31577((class_1799)i, (class_1799)orig)) continue;
                    orig.method_7934(1);
                    continue block0;
                }
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSurround(class_1937 level, boolean boiling, int tankCapacity, SoftFluidStack fluid, class_1799 item) {
        if (item.method_7947() < 8) {
            return null;
        }
        CauldronCraftingContainer container = CauldronCraftingContainer.surround8(boiling, tankCapacity, fluid, item);
        FluidAndItemCraftResult result8x = container.craftWithCraftingRecipes(level);
        if (result8x != null) {
            item.method_7934(8);
            return result8x;
        }
        return null;
    }

    @Nullable
    public static FluidAndItemCraftResult craftFluidSpecial(class_1937 level, boolean boiling, int tankCapacity, SoftFluidStack softFluidStack, Collection<class_1799> items) {
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, softFluidStack, items);
        FluidAndItemCraftResult crafted = container.craftWithCauldronRecipes(level);
        if (crafted != null) {
            for (class_1799 i : items) {
                if (i.method_7960()) continue;
                i.method_7934(1);
            }
            return crafted;
        }
        return null;
    }
}

