/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.columnViews;

import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.IColumnDataView;
import it.unimi.dsi.fastutil.longs.LongArrayList;

public class ColumnQuadView
implements IColumnDataView {
    private final LongArrayList data;
    private final int perColumnOffset;
    private final int xSize;
    private final int zSize;
    private final int offset;
    private final int vertSize;

    public ColumnQuadView(LongArrayList data, int dataZWidth, int dataVertSize, int viewXOffset, int viewZOffset, int xSize, int zSize) {
        if (viewXOffset + xSize > data.size() / (dataZWidth * dataVertSize) || viewZOffset + zSize > dataZWidth) {
            throw new IllegalArgumentException("View is out of bounds");
        }
        this.data = data;
        this.xSize = xSize;
        this.zSize = zSize;
        this.vertSize = dataVertSize;
        this.perColumnOffset = dataZWidth * dataVertSize;
        this.offset = viewXOffset * this.perColumnOffset + viewZOffset * dataVertSize;
    }

    private ColumnQuadView(LongArrayList data, int perColumnOffset, int offset, int vertSize, int xSize, int zSize) {
        this.data = data;
        this.perColumnOffset = perColumnOffset;
        this.offset = offset;
        this.vertSize = vertSize;
        this.xSize = xSize;
        this.zSize = zSize;
    }

    @Override
    public long get(int index) {
        int x = index / this.perColumnOffset;
        int z = index % this.perColumnOffset / this.vertSize;
        int v = index % this.vertSize;
        return this.get(x, z, v);
    }

    public long get(int x, int z, int v) {
        return this.data.getLong(this.offset + x * this.perColumnOffset + z * this.vertSize + v);
    }

    public long set(int x, int z, int v, long value) {
        return this.data.set(this.offset + x * this.perColumnOffset + z * this.vertSize + v, value);
    }

    public ColumnArrayView get(int x, int z) {
        return new ColumnArrayView(this.data, this.vertSize, this.offset + x * this.perColumnOffset + z * this.vertSize, this.vertSize);
    }

    public ColumnArrayView getRow(int x) {
        return new ColumnArrayView(this.data, this.zSize * this.vertSize, this.offset + x * this.perColumnOffset, this.vertSize);
    }

    public void set(int x, int z, IColumnDataView singleColumn) {
        if (singleColumn.verticalSize() != this.vertSize) {
            throw new IllegalArgumentException("Vertical size of singleColumn must be equal to vertSize");
        }
        if (singleColumn.dataCount() != 1) {
            throw new IllegalArgumentException("SingleColumn must contain exactly one data point");
        }
        singleColumn.copyTo(this.data.elements(), this.offset + x * this.perColumnOffset + z * this.vertSize, singleColumn.size());
    }

    @Override
    public int size() {
        return this.xSize * this.zSize * this.vertSize;
    }

    @Override
    public int verticalSize() {
        return this.vertSize;
    }

    @Override
    public int dataCount() {
        return this.xSize * this.zSize;
    }

    @Override
    public IColumnDataView subView(int dataIndexStart, int dataCount) {
        if (dataCount != 1) {
            throw new UnsupportedOperationException("Fixme: subView for QUadView only support one data point!");
        }
        int x = dataIndexStart / this.xSize;
        int z = dataIndexStart % this.xSize;
        return new ColumnArrayView(this.data, this.vertSize * dataCount, this.offset + x * this.perColumnOffset + z * this.vertSize, this.vertSize);
    }

    public ColumnQuadView subView(int xOffset, int zOffset, int xSize, int zSize) {
        if (xOffset + xSize > this.xSize || zOffset + zSize > this.zSize) {
            throw new IllegalArgumentException("SubView is out of bounds");
        }
        return new ColumnQuadView(this.data, this.perColumnOffset, this.offset + xOffset * this.perColumnOffset + zOffset * this.vertSize, this.vertSize, xSize, zSize);
    }

    @Override
    public void copyTo(long[] target, int offset, int size) {
        if (size != this.size() && size > this.zSize * this.vertSize) {
            throw new UnsupportedOperationException("Not supported yet");
        }
        if (size <= this.xSize * this.vertSize) {
            System.arraycopy(this.data, this.offset, target, offset, size);
        } else {
            for (int x = 0; x < this.xSize; ++x) {
                System.arraycopy(this.data, this.offset + x * this.perColumnOffset, target, offset + x * this.xSize * this.vertSize, this.xSize * this.vertSize);
            }
        }
    }
}

