/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.api.internal.ServerApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.forge.ForgePluginPacketSender;
import loaderCommon.forge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.forge.com.seibel.distanthorizons.common.util.ProxyUtil;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeServerProxy
implements AbstractModInitializer.IEventProxy {
    private static final ForgePluginPacketSender PACKET_SENDER = (ForgePluginPacketSender)SingletonInjector.INSTANCE.get(IPluginPacketSender.class);
    private final ServerApi serverApi = ServerApi.INSTANCE;
    private final boolean isDedicated;

    private static LevelAccessor GetEventLevel(LevelEvent e) {
        return e.getLevel();
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.isDedicated) {
            PACKET_SENDER.setPacketHandler(ServerApi.INSTANCE::pluginMessageReceived);
        }
    }

    public ForgeServerProxy(boolean isDedicated) {
        this.isDedicated = isDedicated;
    }

    @SubscribeEvent
    public void dedicatedWorldLoadEvent(ServerAboutToStartEvent event) {
        this.serverApi.serverLoadEvent(this.isDedicated);
    }

    @SubscribeEvent
    public void serverWorldUnloadEvent(ServerStoppingEvent event) {
        this.serverApi.serverUnloadEvent();
    }

    @SubscribeEvent
    public void serverLevelLoadEvent(LevelEvent.Load event) {
        if (ForgeServerProxy.GetEventLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelLoadEvent(ForgeServerProxy.getServerLevelWrapper((ServerLevel)ForgeServerProxy.GetEventLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverLevelUnloadEvent(LevelEvent.Unload event) {
        if (ForgeServerProxy.GetEventLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelUnloadEvent(ForgeServerProxy.getServerLevelWrapper((ServerLevel)ForgeServerProxy.GetEventLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverChunkLoadEvent(ChunkEvent.Load event) {
        ILevelWrapper levelWrapper = ProxyUtil.getLevelWrapper(ForgeServerProxy.GetEventLevel((LevelEvent)event));
        ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), levelWrapper);
        this.serverApi.serverChunkLoadEvent(chunk, levelWrapper);
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        this.serverApi.serverPlayerJoinEvent(ForgeServerProxy.getServerPlayerWrapper((PlayerEvent)event));
    }

    @SubscribeEvent
    public void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        this.serverApi.serverPlayerDisconnectEvent(ForgeServerProxy.getServerPlayerWrapper((PlayerEvent)event));
    }

    @SubscribeEvent
    public void playerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.serverApi.serverPlayerLevelChangeEvent(ForgeServerProxy.getServerPlayerWrapper((PlayerEvent)event), ForgeServerProxy.getServerLevelWrapper((ResourceKey<Level>)event.getFrom(), (PlayerEvent)event), ForgeServerProxy.getServerLevelWrapper((ResourceKey<Level>)event.getTo(), (PlayerEvent)event));
    }

    private static ServerLevelWrapper getServerLevelWrapper(ServerLevel level) {
        return ServerLevelWrapper.getWrapper(level);
    }

    private static ServerLevelWrapper getServerLevelWrapper(ResourceKey<Level> resourceKey, PlayerEvent event) {
        return ForgeServerProxy.getServerLevelWrapper(event.getEntity().m_20194_().m_129880_(resourceKey));
    }

    private static ServerPlayerWrapper getServerPlayerWrapper(PlayerEvent event) {
        return ServerPlayerWrapper.getWrapper((ServerPlayer)event.getEntity());
    }
}

