/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.seibel.distanthorizons.core.generation.PregenManager;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import loaderCommon.forge.com.seibel.distanthorizons.common.commands.AbstractCommand;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;

public class PregenCommand
extends AbstractCommand {
    private final PregenManager pregenManager = new PregenManager();

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> buildCommand() {
        LiteralArgumentBuilder statusCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"status").executes(this::pregenStatus);
        LiteralArgumentBuilder startCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"origin", (ArgumentType)ColumnPosArgument.m_118989_()).then(Commands.m_82129_((String)"chunkRadius", (ArgumentType)IntegerArgumentType.integer((int)32)).executes(this::pregenStart))));
        LiteralArgumentBuilder stopCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"stop").executes(this::pregenStop);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pregen").then((ArgumentBuilder)statusCommand)).then((ArgumentBuilder)startCommand)).then((ArgumentBuilder)stopCommand);
    }

    private int pregenStatus(CommandContext<CommandSourceStack> c) {
        String statusString = this.pregenManager.getStatusString();
        if (statusString != null) {
            return this.sendSuccessResponse(c, statusString, false);
        }
        return this.sendSuccessResponse(c, "Pregen is not running", false);
    }

    private int pregenStart(CommandContext<CommandSourceStack> c) throws CommandSyntaxException {
        this.sendSuccessResponse(c, "Starting pregen. Progress will be in the server console.", true);
        ServerLevel level = DimensionArgument.m_88808_(c, (String)"dimension");
        ColumnPos origin = ColumnPosArgument.m_118992_(c, (String)"origin");
        int chunkRadius = IntegerArgumentType.getInteger(c, (String)"chunkRadius");
        CompletableFuture<Void> future = this.pregenManager.startPregen(ServerLevelWrapper.getWrapper(level), new DhBlockPos2D(origin.f_140723_(), origin.f_140724_()), chunkRadius);
        future.whenComplete((result, throwable) -> {
            if (throwable instanceof CancellationException) {
                this.sendSuccessResponse(c, "Pregen is cancelled", true);
                return;
            }
            if (throwable != null) {
                this.sendFailureResponse(c, "Pregen failed: " + throwable.getMessage() + "\n Check the logs for more details.");
                return;
            }
            this.sendSuccessResponse(c, "Pregen is complete", true);
        });
        return 1;
    }

    private int pregenStop(CommandContext<CommandSourceStack> c) {
        CompletableFuture<Void> runningPregen = this.pregenManager.getRunningPregen();
        if (runningPregen == null) {
            return this.sendFailureResponse(c, "Pregen is not running");
        }
        runningPregen.cancel(true);
        return 1;
    }
}

