/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2574;
import net.minecraft.class_2575;
import net.minecraft.class_2576;
import net.minecraft.class_2578;
import net.minecraft.class_2579;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3902;
import net.minecraft.class_4616;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7419;
import team.creative.creativecore.common.util.text.AdvancedStringSplitter;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedContentConsumer;
import team.creative.creativecore.common.util.text.content.ContentItemStack;
import team.creative.creativecore.common.util.text.content.FormattedSingleSink;

public class AdvancedComponentHelper {
    public static final AdvancedStringSplitter SPLITTER = new AdvancedStringSplitter(class_310.method_1551().field_1772);
    private static final Optional<Object> STOP_ITERATION = Optional.of(class_3902.field_17274);

    public static class_2561 copy(class_2561 component) {
        class_5250 copy = class_5250.method_43477((class_7417)component.method_10851());
        for (class_2561 sibling : component.method_10855()) {
            copy.method_10855().add(AdvancedComponentHelper.copy(sibling));
        }
        copy.method_10862(component.method_10866());
        return copy;
    }

    public static boolean iterateFormatted(class_2561 text, class_2583 style, final FormattedSingleSink sink) {
        return AdvancedComponentHelper.visit(text, new AdvancedContentConsumer(){

            public Optional accept(class_2583 style, AdvancedContent content) {
                return sink.accept(style, content) ? Optional.empty() : STOP_ITERATION;
            }

            public Optional accept(class_2583 style, String content) {
                return class_5223.method_27473((String)content, (int)0, (class_2583)style, (class_2583)style, (class_5224)sink) ? Optional.empty() : STOP_ITERATION;
            }
        }, style).isEmpty();
    }

    public static <T> Optional<T> visit(class_2561 text, AdvancedContentConsumer<T> consumer, class_2583 defaultStyle) {
        class_2583 style = text.method_10866().method_27702(defaultStyle);
        Optional<T> optional = AdvancedComponentHelper.visit(text.method_10851(), consumer, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (class_2561 component : text.method_10855()) {
            Optional<T> optional1 = AdvancedComponentHelper.visit(component, consumer, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    public static <T> Optional<T> visit(class_7417 content, AdvancedContentConsumer<T> consumer, class_2583 style) {
        if (content instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)content;
            return adv.visit(consumer, style);
        }
        return content.method_27660(consumer, style);
    }

    public static class Serializer
    extends class_2561.class_2562 {
        public JsonElement method_10874(class_2561 component, Type type, JsonSerializationContext context) {
            class_7417 componentcontents;
            JsonObject jsonobject = new JsonObject();
            if (!component.method_10866().method_10967()) {
                this.serializeStyle(component.method_10866(), jsonobject, context);
            }
            if (!component.method_10855().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (class_2561 comp : component.method_10855()) {
                    jsonarray.add(this.method_10874(comp, (Type)((Object)class_2561.class), context));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if ((componentcontents = component.method_10851()) == class_7417.field_39004) {
                jsonobject.addProperty("text", "");
            } else if (componentcontents instanceof ContentItemStack) {
                ContentItemStack stack = (ContentItemStack)componentcontents;
                jsonobject.addProperty("itemstack", stack.stack().method_7953(new class_2487()).toString());
            } else if (componentcontents instanceof class_2585) {
                class_2585 literalcontents = (class_2585)componentcontents;
                jsonobject.addProperty("text", literalcontents.comp_737());
            } else if (componentcontents instanceof class_2588) {
                class_2588 translatablecontents = (class_2588)componentcontents;
                jsonobject.addProperty("translate", translatablecontents.method_11022());
                if (translatablecontents.method_11023().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    for (Object object : translatablecontents.method_11023()) {
                        if (object instanceof class_2561) {
                            jsonarray1.add(this.method_10874((class_2561)object, object.getClass(), context));
                            continue;
                        }
                        jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (componentcontents instanceof class_2578) {
                class_2578 scorecontents = (class_2578)componentcontents;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scorecontents.method_10930());
                jsonobject1.addProperty("objective", scorecontents.method_10928());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (componentcontents instanceof class_2579) {
                class_2579 selectorcontents = (class_2579)componentcontents;
                jsonobject.addProperty("selector", selectorcontents.method_10932());
                this.serializeSeparator(context, jsonobject, selectorcontents.method_36339());
            } else if (componentcontents instanceof class_2572) {
                class_2572 keybindcontents = (class_2572)componentcontents;
                jsonobject.addProperty("keybind", keybindcontents.method_10901());
            } else {
                if (!(componentcontents instanceof class_2574)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                }
                class_2574 nbtcontents = (class_2574)componentcontents;
                jsonobject.addProperty("nbt", nbtcontents.method_10920());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbtcontents.method_10921()));
                this.serializeSeparator(context, jsonobject, nbtcontents.method_43484());
                class_7419 datasource = nbtcontents.method_43485();
                if (datasource instanceof class_2575) {
                    class_2575 blockdatasource = (class_2575)datasource;
                    jsonobject.addProperty("block", blockdatasource.comp_733());
                } else if (datasource instanceof class_2576) {
                    class_2576 entitydatasource = (class_2576)datasource;
                    jsonobject.addProperty("entity", entitydatasource.comp_735());
                } else {
                    if (!(datasource instanceof class_4616)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                    }
                    class_4616 storagedatasource = (class_4616)datasource;
                    jsonobject.addProperty("storage", storagedatasource.comp_738().toString());
                }
            }
            return jsonobject;
        }

        private static Object unwrapTextArgument(Object object) {
            class_7417 componentcontents;
            class_2561 component;
            if (object instanceof class_2561 && (component = (class_2561)object).method_10866().method_10967() && component.method_10855().isEmpty() && (componentcontents = component.method_10851()) instanceof class_2585) {
                class_2585 literalcontents = (class_2585)componentcontents;
                return literalcontents.comp_737();
            }
            return object;
        }

        private Optional<class_2561> parseSeparator(Type type, JsonDeserializationContext context, JsonObject object) {
            return object.has("separator") ? Optional.of(this.method_10871(object.get("separator"), type, context)) : Optional.empty();
        }

        private void serializeSeparator(JsonSerializationContext context, JsonObject object, Optional<class_2561> optional) {
            optional.ifPresent(comp -> object.add("separator", this.method_10874((class_2561)comp, comp.getClass(), context)));
        }

        private void serializeStyle(class_2583 style, JsonObject object, JsonSerializationContext context) {
            JsonElement jsonelement = context.serialize((Object)style);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject.entrySet()) {
                    object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public class_5250 method_10871(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            class_5250 mutablecomponent;
            if (element.isJsonPrimitive()) {
                return class_2561.method_43470((String)element.getAsString());
            }
            if (!element.isJsonObject()) {
                if (element.isJsonArray()) {
                    JsonArray jsonarray1 = element.getAsJsonArray();
                    class_5250 mutablecomponent1 = null;
                    for (JsonElement jsonelement : jsonarray1) {
                        class_5250 mutablecomponent2 = this.method_10871(jsonelement, jsonelement.getClass(), context);
                        if (mutablecomponent1 == null) {
                            mutablecomponent1 = mutablecomponent2;
                            continue;
                        }
                        mutablecomponent1.method_10852((class_2561)mutablecomponent2);
                    }
                    return mutablecomponent1;
                }
                throw new JsonParseException("Don't know how to turn " + element + " into a Component");
            }
            JsonObject jsonobject = element.getAsJsonObject();
            if (jsonobject.has("text")) {
                String s = class_3518.method_15265((JsonObject)jsonobject, (String)"text");
                mutablecomponent = s.isEmpty() ? class_2561.method_43473() : class_2561.method_43470((String)s);
            } else if (jsonobject.has("itemstack")) {
                try {
                    mutablecomponent = class_5250.method_43477((class_7417)new ContentItemStack(class_1799.method_7915((class_2487)class_2522.method_10718((String)jsonobject.get("itemstack").getAsString()))));
                }
                catch (CommandSyntaxException e) {
                    throw new JsonParseException((Throwable)e);
                }
            } else if (jsonobject.has("translate")) {
                String s1 = class_3518.method_15265((JsonObject)jsonobject, (String)"translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray = class_3518.method_15261((JsonObject)jsonobject, (String)"with");
                    Object[] aobject = new Object[jsonarray.size()];
                    for (int i = 0; i < aobject.length; ++i) {
                        aobject[i] = Serializer.unwrapTextArgument(this.method_10871(jsonarray.get(i), type, context));
                    }
                    mutablecomponent = class_2561.method_43469((String)s1, (Object[])aobject);
                } else {
                    mutablecomponent = class_2561.method_43471((String)s1);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = class_3518.method_15296((JsonObject)jsonobject, (String)"score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                mutablecomponent = class_2561.method_43466((String)class_3518.method_15265((JsonObject)jsonobject1, (String)"name"), (String)class_3518.method_15265((JsonObject)jsonobject1, (String)"objective"));
            } else if (jsonobject.has("selector")) {
                Optional<class_2561> optional = this.parseSeparator(type, context, jsonobject);
                mutablecomponent = class_2561.method_43467((String)class_3518.method_15265((JsonObject)jsonobject, (String)"selector"), optional);
            } else if (jsonobject.has("keybind")) {
                mutablecomponent = class_2561.method_43472((String)class_3518.method_15265((JsonObject)jsonobject, (String)"keybind"));
            } else {
                class_2575 datasource;
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + element + " into a Component");
                }
                String s2 = class_3518.method_15265((JsonObject)jsonobject, (String)"nbt");
                Optional<class_2561> optional1 = this.parseSeparator(type, context, jsonobject);
                boolean flag = class_3518.method_15258((JsonObject)jsonobject, (String)"interpret", (boolean)false);
                if (jsonobject.has("block")) {
                    datasource = new class_2575(class_3518.method_15265((JsonObject)jsonobject, (String)"block"));
                } else if (jsonobject.has("entity")) {
                    datasource = new class_2576(class_3518.method_15265((JsonObject)jsonobject, (String)"entity"));
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + element + " into a Component");
                    }
                    datasource = new class_4616(new class_2960(class_3518.method_15265((JsonObject)jsonobject, (String)"storage")));
                }
                mutablecomponent = class_2561.method_43468((String)s2, (boolean)flag, optional1, (class_7419)datasource);
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = class_3518.method_15261((JsonObject)jsonobject, (String)"extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j = 0; j < jsonarray2.size(); ++j) {
                    mutablecomponent.method_10852((class_2561)this.method_10871(jsonarray2.get(j), type, context));
                }
            }
            mutablecomponent.method_10862((class_2583)context.deserialize(element, class_2583.class));
            return mutablecomponent;
        }
    }
}

