/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1463;
import net.minecraft.class_1528;
import net.minecraft.class_1547;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4836;
import net.minecraft.class_5498;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MobHeadShadersManager
extends class_4309 {
    public static final MobHeadShadersManager INSTANCE = new MobHeadShadersManager();
    private final Map<class_1792, String> effects = new HashMap<class_1792, String>();
    private final Map<class_1299<?>, String> entityEffects = new HashMap();
    private final Set<String> myShaders = new HashSet<String>();
    private String lastAppliedShader = null;

    public MobHeadShadersManager() {
        super(new Gson(), "mob_head_effects");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.effects.clear();
        this.entityEffects.clear();
        this.myShaders.clear();
        for (Map.Entry<class_2960, JsonElement> entry : object.entrySet()) {
            MobHeadEffect effect = (MobHeadEffect)MobHeadEffect.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow(false, s -> Supplementaries.LOGGER.error("Failed to parse mob head effect: {}", s));
            String shaderPath = effect.getShaderPath();
            for (class_1792 class_17922 : effect.items) {
                if (class_17922 == class_1802.field_8162) {
                    throw new IllegalArgumentException("Mob head effect cannot have AIR item: " + effect.shader);
                }
                this.effects.put(class_17922, shaderPath);
            }
            for (class_1299 class_12992 : effect.entityTypes) {
                this.entityEffects.put(class_12992, shaderPath);
            }
            this.myShaders.add(shaderPath);
        }
        this.myShaders.add(ClientRegistry.BARBARIC_RAGE_SHADER);
    }

    @Nullable
    public String getShaderForItem(class_1792 item) {
        return this.effects.get(item);
    }

    @Nullable
    public String getShaderForEntity(class_1299<?> entityType) {
        return this.entityEffects.get(entityType);
    }

    public void applyMobHeadShaders(class_1657 p, class_310 mc) {
        if (ClientConfigs.Tweaks.MOB_HEAD_EFFECTS.get().booleanValue()) {
            String rendererShader;
            class_757 renderer = class_310.method_1551().field_1773;
            String string = rendererShader = renderer.field_4024 == null ? null : renderer.field_4024.method_1260();
            if (rendererShader != null && !this.myShaders.contains(rendererShader)) {
                return;
            }
            if (p.method_7325()) {
                if (rendererShader != null && this.lastAppliedShader != null) {
                    renderer.method_3207();
                    this.lastAppliedShader = null;
                }
                return;
            }
            if (rendererShader == null && this.lastAppliedShader != null) {
                this.lastAppliedShader = null;
            }
            class_1799 stack = p.method_6118(class_1304.field_6169);
            if (CompatHandler.QUARK && QuarkCompat.shouldHideOverlay(stack)) {
                return;
            }
            class_1792 item = stack.method_7909();
            String newShader = mc.field_1690.method_31044() == class_5498.field_26664 ? this.getShaderForItem(item) : null;
            if (newShader == null && this.shouldHaveGoatedEffect(p, item)) {
                newShader = ClientRegistry.BARBARIC_RAGE_SHADER;
            }
            if (!(newShader == null || newShader.equals(rendererShader) && renderer.field_4013)) {
                renderer.method_3168(class_2960.method_12829((String)newShader));
                this.lastAppliedShader = newShader;
            } else if (rendererShader != null && newShader == null) {
                renderer.method_3207();
                this.lastAppliedShader = null;
            }
        }
    }

    private boolean shouldHaveGoatedEffect(class_1657 p, class_1792 item) {
        return CompatHandler.GOATED && item == CompatObjects.BARBARIC_HELMET.get() && p.method_6032() < 5.0f;
    }

    @Nullable
    public class_2960 getSpectatorShaders(class_1297 entity) {
        class_1463 e;
        if (entity == null) {
            return null;
        }
        String s = this.getShaderForEntity(entity.method_5864());
        if (s != null) {
            return class_2960.method_12829((String)s);
        }
        if (entity instanceof class_1547) {
            return ClientRegistry.BLACK_AND_WHITE_SHADER;
        }
        if (entity instanceof class_1642) {
            return ClientRegistry.VANILLA_DESATURATE_SHADER;
        }
        if (entity instanceof class_1463 && (e = (class_1463)entity).method_47855() == class_1463.class_7990.field_41567) {
            return ClientRegistry.RAGE_SHADER;
        }
        if (entity instanceof class_4836) {
            return ClientRegistry.GLITTER_SHADER;
        }
        if (entity instanceof class_1528) {
            return ClientRegistry.BLACK_AND_WHITE_SHADER;
        }
        return null;
    }

    private record MobHeadEffect(List<class_1792> items, List<class_1299<?>> entityTypes, class_2960 shader) {
        public static final Codec<MobHeadEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().listOf().optionalFieldOf("items", List.of()).forGetter(MobHeadEffect::items), (App)class_7923.field_41177.method_39673().listOf().optionalFieldOf("entity_types", List.of()).forGetter(MobHeadEffect::entityTypes), (App)class_2960.field_25139.fieldOf("shader").forGetter(MobHeadEffect::shader)).apply((Applicative)instance, MobHeadEffect::new));

        public String getShaderPath() {
            return this.shader.method_45134(p -> "shaders/post/" + p + ".json").toString();
        }
    }
}

