/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IOnePlayerInteractable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.CannonBallItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundControlCannonPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSyncCannonPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CannonBlockTile
extends OpeneableContainerBlockEntity
implements IOnePlayerInteractable {
    @Nullable
    private Set<class_2248> breakWhitelist = null;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private int cooldownTimer = 0;
    private int fuseTimer = 0;
    private byte powerLevel = 1;
    private IBallisticBehavior.Data trajectoryData = IBallisticBehavior.LINE;
    private class_1792 trajectoryFor = class_1802.field_8162;
    @Nullable
    private UUID playerWhoIgnitedUUID = null;
    @Nullable
    private UUID controllingPlayer = null;

    public CannonBlockTile(class_2338 pos, class_2680 blockState) {
        super(ModRegistry.CANNON_TILE.get(), pos, blockState, 2);
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("yaw", this.yaw);
        tag.method_10548("pitch", this.pitch);
        tag.method_10569("cooldown", this.cooldownTimer);
        tag.method_10569("fuse_timer", this.fuseTimer);
        tag.method_10567("fire_power", this.powerLevel);
        if (this.playerWhoIgnitedUUID != null) {
            tag.method_25927("player_ignited", this.playerWhoIgnitedUUID);
        }
        if (this.breakWhitelist != null) {
            CannonBlockTile.saveBreakWhitelist(this.breakWhitelist, tag);
        }
        tag.method_10566("trajectory", (class_2520)IBallisticBehavior.Data.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.trajectoryData).getOrThrow(false, arg_0 -> ((Logger)Supplementaries.LOGGER).error(arg_0)));
    }

    public static void saveBreakWhitelist(Set<class_2248> breakWhitelist, class_2487 tag) {
        class_2499 list = new class_2499();
        for (class_2248 b : breakWhitelist) {
            list.add((Object)class_2519.method_23256((String)class_7923.field_41175.method_10221((Object)b).toString()));
        }
        tag.method_10566("break_whitelist", (class_2520)list);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.yaw = tag.method_10583("yaw");
        this.pitch = tag.method_10583("pitch");
        this.cooldownTimer = tag.method_10550("cooldown");
        this.fuseTimer = tag.method_10550("fuse_timer");
        this.powerLevel = tag.method_10571("fire_power");
        if (tag.method_10545("player_ignited")) {
            this.playerWhoIgnitedUUID = tag.method_25926("player_ignited");
        }
        this.breakWhitelist = CannonBlockTile.readBreakWhitelist(tag);
        if (tag.method_10545("trajectory")) {
            this.trajectoryData = (IBallisticBehavior.Data)IBallisticBehavior.Data.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("trajectory")).getOrThrow(false, arg_0 -> ((Logger)Supplementaries.LOGGER).error(arg_0));
        }
    }

    @Nullable
    public static Set<class_2248> readBreakWhitelist(class_2487 tag) {
        if (tag.method_10545("break_whitelist")) {
            class_2499 list = tag.method_10554("break_whitelist", 8);
            HashSet<class_2248> breakWhitelist = new HashSet<class_2248>();
            for (int i = 0; i < list.size(); ++i) {
                class_2248 b = (class_2248)class_7923.field_41175.method_10223(new class_2960(list.method_10608(i)));
                breakWhitelist.add(b);
            }
            return breakWhitelist;
        }
        return null;
    }

    public void method_5431() {
        super.method_5431();
        this.recomputeTrajectoryData();
    }

    private void computeTrajectoryData() {
        class_1799 proj = this.getProjectile();
        IFireItemBehavior behavior = CannonBlock.getCannonBehavior((class_1935)this.getProjectile().method_7909());
        if (behavior instanceof IBallisticBehavior) {
            IBallisticBehavior b = (IBallisticBehavior)behavior;
            this.trajectoryData = b.calculateData(proj, this.field_11863);
        } else {
            this.trajectoryData = IBallisticBehavior.LINE;
        }
        if (this.trajectoryData == null) {
            Supplementaries.error();
        }
        this.trajectoryFor = proj.method_7909();
    }

    public boolean readyToFire() {
        return this.cooldownTimer == 0 && this.fuseTimer == 0 && this.hasFuelAndProjectiles();
    }

    public boolean hasFuelAndProjectiles() {
        return !this.getProjectile().method_7960() && !this.getFuel().method_7960() && this.getFuel().method_7947() >= this.powerLevel;
    }

    public boolean isFiring() {
        return this.fuseTimer > 0;
    }

    public float getFiringAnimation(float partialTicks) {
        if (this.fuseTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.fuseTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_FUSE_TIME.get().intValue();
    }

    public float getCooldownAnimation(float partialTicks) {
        if (this.cooldownTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.cooldownTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_COOLDOWN.get().intValue();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_1799 getProjectile() {
        return this.method_5438(1);
    }

    public void setProjectile(class_1799 stack) {
        this.method_5447(1, stack);
    }

    public class_1799 getFuel() {
        return this.method_5438(0);
    }

    public void setFuel(class_1799 stack) {
        this.method_5447(0, stack);
    }

    public IBallisticBehavior.Data getTrajectoryData() {
        return this.trajectoryData;
    }

    private void recomputeTrajectoryData() {
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.trajectoryFor != this.getProjectile().method_7909()) {
            this.computeTrajectoryData();
        }
    }

    public byte getPowerLevel() {
        return this.powerLevel;
    }

    public float getFirePower() {
        return (float)Math.pow(this.powerLevel, CommonConfigs.Functional.CANNON_FIRE_POWER.get());
    }

    public float getYaw(float partialTicks) {
        return class_3532.method_17821((float)partialTicks, (float)this.prevYaw, (float)this.yaw);
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch(float partialTicks) {
        return class_3532.method_17821((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setAttributes(float yaw, float pitch, byte firePower, boolean fire, class_1657 controllingPlayer) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.powerLevel = firePower;
        if (fire) {
            this.ignite((class_1297)controllingPlayer);
        }
    }

    public void setRestrainedPitch(float pitch) {
        Restraint r = this.getPitchAndYawRestrains();
        this.pitch = class_3532.method_15363((float)class_3532.method_15393((float)pitch), (float)r.minPitch, (float)r.maxPitch);
    }

    public void setRestrainedYaw(float yaw) {
        Restraint r = this.getPitchAndYawRestrains();
        this.yaw = class_3532.method_15363((float)class_3532.method_15393((float)yaw), (float)r.minYaw, (float)r.maxYaw);
    }

    public void setRenderYaw(float yaw) {
        this.setRestrainedYaw(yaw);
        this.prevYaw = this.yaw;
    }

    public void setRenderPitch(float pitch) {
        this.setRestrainedPitch(pitch);
        this.prevPitch = this.pitch;
    }

    public Restraint getPitchAndYawRestrains() {
        class_2680 state = this.method_11010();
        return switch (((class_2350)state.method_11654((class_2769)CannonBlock.field_10927)).method_10153()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> new Restraint(70.0f, 290.0f, -360.0f, 360.0f);
            case class_2350.field_11035 -> new Restraint(-110.0f, 110.0f, -360.0f, 360.0f);
            case class_2350.field_11034 -> new Restraint(-200.0f, 20.0f, -360.0f, 360.0f);
            case class_2350.field_11039 -> new Restraint(-20.0f, 200.0f, -360.0f, 360.0f);
            case class_2350.field_11036 -> new Restraint(-360.0f, 360.0f, -200.0f, 20.0f);
            case class_2350.field_11033 -> new Restraint(-360.0f, 360.0f, -20.0f, 200.0f);
        };
    }

    public void changeFirePower(int scrollDelta) {
        this.powerLevel = (byte)(1 + Math.floorMod(this.powerLevel - 1 + scrollDelta, 4));
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"gui.supplementaries.cannon");
    }

    @Override
    protected void updateBlockState(class_2680 state, boolean b) {
    }

    @Override
    protected void playOpenSound(class_2680 state) {
    }

    @Override
    protected void playCloseSound(class_2680 state) {
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0) {
            return stack.method_31574(class_1802.field_8054);
        }
        return !stack.method_31573(ModTags.CANNON_BLACKLIST);
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(direction == null || direction.method_10166().method_10179() ? 1 : 0, itemStack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[]{side.method_10166().method_10179() ? 1 : 0};
    }

    @Override
    public boolean tryOpeningEditGui(class_3222 player, class_2338 pos, class_1799 stack) {
        if (player.method_21823()) {
            if (Utils.mayPerformBlockAction((class_1657)player, (class_2338)pos, (class_1799)stack) && !this.isOtherPlayerEditing((class_1657)player)) {
                this.setPlayerWhoMayEdit(player.method_5667());
                ModNetwork.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundControlCannonPacket(this.field_11867));
            }
            return true;
        }
        return IOnePlayerInteractable.super.tryOpeningEditGui(player, pos, stack);
    }

    public void ignite(@Nullable class_1297 entityWhoIgnited) {
        if (this.fuseTimer > 0) {
            return;
        }
        if (this.getProjectile().method_7960()) {
            return;
        }
        this.fuseTimer = CommonConfigs.Functional.CANNON_FUSE_TIME.get();
        this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 0, 0);
        this.playerWhoIgnitedUUID = entityWhoIgnited != null ? entityWhoIgnited.method_5667() : null;
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, CannonBlockTile t) {
        t.prevYaw = t.yaw;
        t.prevPitch = t.pitch;
        if (t.cooldownTimer > 0) {
            --t.cooldownTimer;
        }
        if (t.fuseTimer > 0) {
            --t.fuseTimer;
            if (t.fuseTimer <= 0) {
                t.fire();
            }
        }
    }

    private void fire() {
        if (!this.hasFuelAndProjectiles()) {
            return;
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_1657 p;
            class_3218 sl = (class_3218)class_19372;
            if (this.shootProjectile(sl) && ((p = this.getPlayerWhoFired()) == null || !p.method_7337())) {
                class_1799 fuel = this.getFuel();
                fuel.method_7934((int)this.powerLevel);
                this.setFuel(fuel);
                class_1799 projectile = this.getProjectile();
                projectile.method_7934(1);
                this.setProjectile(projectile);
                this.method_5431();
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                this.field_11863.method_33596((class_1297)p, class_5712.field_28178, this.field_11867);
            }
        } else {
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, 0);
        }
        this.cooldownTimer = CommonConfigs.Functional.CANNON_COOLDOWN.get();
    }

    private boolean shootProjectile(class_3218 serverLevel) {
        class_243 facing = class_243.method_1030((float)this.pitch, (float)this.yaw).method_1021(-1.0);
        class_1799 projectile = this.getProjectile().method_7972();
        if (projectile.method_7909() instanceof CannonBallItem && this.breakWhitelist != null) {
            CannonBlockTile.saveBreakWhitelist(this.breakWhitelist, projectile.method_7948());
        }
        IFireItemBehavior behavior = CannonBlock.getCannonBehavior((class_1935)this.getProjectile().method_7909());
        return behavior.fire(projectile.method_7972(), serverLevel, this.field_11867, 0.5f, facing, this.getFirePower(), 0, this.getPlayerWhoFired());
    }

    @Nullable
    private class_1657 getPlayerWhoFired() {
        UUID uuid = this.controllingPlayer;
        if (uuid == null && this.playerWhoIgnitedUUID != null) {
            uuid = this.playerWhoIgnitedUUID;
        }
        if (uuid == null) {
            return null;
        }
        return this.field_11863.method_18470(uuid);
    }

    @Override
    public void setPlayerWhoMayEdit(@Nullable UUID uuid) {
        this.controllingPlayer = uuid;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.controllingPlayer;
    }

    public class_1703 method_5465(int id, class_1661 player) {
        return new CannonContainerMenu(id, player, this);
    }

    public static void syncToServer(CannonBlockTile cannon, boolean fire, boolean removeOwner) {
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSyncCannonPacket(cannon.getYaw(), cannon.getPitch(), cannon.getPowerLevel(), fire, cannon.method_11016(), removeOwner));
    }

    public record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

