/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobCollector;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobTyped;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.lists.VisibleChunkCollector;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.GraphDirection;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import me.jellysquid.mods.sodium.client.render.util.RenderAsserts;
import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.iterator.ByteIterator;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSectionManager {
    private final ChunkBuilder builder;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final ConcurrentLinkedDeque<ChunkJobResult<ChunkBuildOutput>> buildResults = new ConcurrentLinkedDeque();
    private final ChunkRenderer chunkRenderer;
    private final class_638 world;
    private final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private final OcclusionCuller occlusionCuller;
    private final int renderDistance;
    @NotNull
    private SortedRenderLists renderLists;
    @NotNull
    private Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists;
    private int lastUpdatedFrame;
    private boolean needsUpdate;
    @Nullable
    private class_2338 lastCameraPosition;
    private static final float NEARBY_REBUILD_DISTANCE = class_3532.method_27285((float)16.0f);

    public RenderSectionManager(class_638 world, int renderDistance, CommandList commandList) {
        this.chunkRenderer = new DefaultChunkRenderer(RenderDevice.INSTANCE, ChunkMeshFormats.COMPACT);
        this.world = world;
        this.builder = new ChunkBuilder(world, ChunkMeshFormats.COMPACT);
        this.needsUpdate = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((class_1937)this.world);
        this.renderLists = SortedRenderLists.empty();
        this.occlusionCuller = new OcclusionCuller((Long2ReferenceMap<RenderSection>)Long2ReferenceMaps.unmodifiable(this.sectionByPosition), (class_1937)this.world);
        this.rebuildLists = new EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>>(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.rebuildLists.put(type, new ArrayDeque());
        }
    }

    public void update(class_4184 camera, Viewport viewport, int frame, boolean spectator) {
        this.lastCameraPosition = camera.method_19328();
        this.createTerrainRenderList(camera, viewport, frame, spectator);
        this.needsUpdate = false;
        this.lastUpdatedFrame = frame;
    }

    private void createTerrainRenderList(class_4184 camera, Viewport viewport, int frame, boolean spectator) {
        this.resetRenderLists();
        float searchDistance = this.getSearchDistance();
        boolean useOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        VisibleChunkCollector visitor = new VisibleChunkCollector(frame);
        this.occlusionCuller.findVisible(visitor, viewport, searchDistance, useOcclusionCulling, frame);
        this.renderLists = visitor.createRenderLists();
        this.rebuildLists = visitor.getRebuildLists();
    }

    private float getSearchDistance() {
        float distance = SodiumClientMod.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    private boolean shouldUseOcclusionCulling(class_4184 camera, boolean spectator) {
        class_2338 origin = camera.method_19328();
        boolean useOcclusionCulling = spectator && this.world.method_8320(origin).method_26216((class_1922)this.world, origin) ? false : class_310.method_1551().field_1730;
        return useOcclusionCulling;
    }

    private void resetRenderLists() {
        this.renderLists = SortedRenderLists.empty();
        for (ArrayDeque<RenderSection> list : this.rebuildLists.values()) {
            list.clear();
        }
    }

    public void onSectionAdded(int x, int y, int z) {
        long key = class_4076.method_18685((int)x, (int)y, (int)z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        class_2818 chunk = this.world.method_8497(x, z);
        class_2826 section = chunk.method_12006()[this.world.method_31603(y)];
        if (section.method_38292()) {
            this.updateSectionInfo(renderSection, BuiltSectionInfo.EMPTY);
        } else {
            renderSection.setPendingUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(renderSection);
        this.needsUpdate = true;
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderSection section = (RenderSection)this.sectionByPosition.remove(class_4076.method_18685((int)x, (int)y, (int)z));
        if (section == null) {
            return;
        }
        RenderRegion region = section.getRegion();
        if (region != null) {
            region.removeSection(section);
        }
        this.disconnectNeighborNodes(section);
        this.updateSectionInfo(section, null);
        section.delete();
        this.needsUpdate = true;
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.renderLists, pass, new CameraTransform(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                class_1058[] sprites;
                RenderSection section = region.getSection(iterator.nextByteAsInt());
                if (section == null || (sprites = section.getAnimatedSprites()) == null) continue;
                for (class_1058 sprite : sprites) {
                    SpriteUtil.INSTANCE.markSpriteActive(sprite);
                }
            }
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.lastUpdatedFrame;
    }

    public void updateChunks(boolean updateImmediately) {
        this.sectionCache.cleanup();
        this.regions.update();
        ChunkJobCollector blockingRebuilds = new ChunkJobCollector(Integer.MAX_VALUE, this.buildResults::add);
        ChunkJobCollector deferredRebuilds = new ChunkJobCollector(this.builder.getSchedulingBudget(), this.buildResults::add);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_REBUILD);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.REBUILD);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.INITIAL_BUILD);
        blockingRebuilds.awaitCompletion(this.builder);
    }

    public void uploadChunks() {
        ArrayList<ChunkBuildOutput> results = this.collectChunkBuildResults();
        if (results.isEmpty()) {
            return;
        }
        this.processChunkBuildResults(results);
        for (ChunkBuildOutput result : results) {
            result.delete();
        }
        this.needsUpdate = true;
    }

    private void processChunkBuildResults(ArrayList<ChunkBuildOutput> results) {
        List<ChunkBuildOutput> filtered = RenderSectionManager.filterChunkBuildResults(results);
        this.regions.uploadMeshes(RenderDevice.INSTANCE.createCommandList(), filtered);
        for (ChunkBuildOutput result : filtered) {
            this.updateSectionInfo(result.render, result.info);
            CancellationToken job = result.render.getBuildCancellationToken();
            if (job != null && result.buildTime >= result.render.getLastSubmittedFrame()) {
                result.render.setBuildCancellationToken(null);
            }
            result.render.setLastBuiltFrame(result.buildTime);
        }
    }

    private void updateSectionInfo(RenderSection render, BuiltSectionInfo info) {
        render.setInfo(info);
        if (info == null || ArrayUtils.isEmpty((Object[])info.globalBlockEntities)) {
            this.sectionsWithGlobalEntities.remove((Object)render);
        } else {
            this.sectionsWithGlobalEntities.add((Object)render);
        }
    }

    private static List<ChunkBuildOutput> filterChunkBuildResults(ArrayList<ChunkBuildOutput> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (ChunkBuildOutput output : outputs) {
            RenderSection render;
            ChunkBuildOutput previous;
            if (output.render.isDisposed() || output.render.getLastBuiltFrame() > output.buildTime || (previous = (ChunkBuildOutput)map.get((Object)(render = output.render))) != null && previous.buildTime >= output.buildTime) continue;
            map.put((Object)render, (Object)output);
        }
        return new ArrayList<ChunkBuildOutput>((Collection<ChunkBuildOutput>)map.values());
    }

    private ArrayList<ChunkBuildOutput> collectChunkBuildResults() {
        ChunkJobResult<ChunkBuildOutput> result;
        ArrayList<ChunkBuildOutput> results = new ArrayList<ChunkBuildOutput>();
        while ((result = this.buildResults.poll()) != null) {
            results.add(result.unwrap());
        }
        return results;
    }

    private void submitRebuildTasks(ChunkJobCollector collector, ChunkUpdateType type) {
        ArrayDeque<RenderSection> queue = this.rebuildLists.get((Object)type);
        while (!queue.isEmpty() && collector.canOffer()) {
            RenderSection section = queue.remove();
            if (section.isDisposed()) continue;
            int frame = this.lastUpdatedFrame;
            ChunkBuilderMeshingTask task = this.createRebuildTask(section, frame);
            if (task != null) {
                ChunkJobTyped job = this.builder.scheduleTask(task, type.isImportant(), collector::onJobFinished);
                collector.addSubmittedJob(job);
                section.setBuildCancellationToken(job);
            } else {
                ChunkJobResult<ChunkBuildOutput> result = ChunkJobResult.successfully(new ChunkBuildOutput(section, BuiltSectionInfo.EMPTY, Collections.emptyMap(), frame));
                this.buildResults.add(result);
                section.setBuildCancellationToken(null);
            }
            section.setLastSubmittedFrame(frame);
            section.setPendingUpdate(null);
        }
    }

    @Nullable
    public ChunkBuilderMeshingTask createRebuildTask(RenderSection render, int frame) {
        ChunkRenderContext context = WorldSlice.prepare((class_1937)this.world, render.getPosition(), this.sectionCache);
        if (context == null) {
            return null;
        }
        return new ChunkBuilderMeshingTask(render, context, frame);
    }

    public void markGraphDirty() {
        this.needsUpdate = true;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.builder.shutdown();
        for (ChunkBuildOutput result : this.collectChunkBuildResults()) {
            result.delete();
        }
        this.sectionsWithGlobalEntities.clear();
        this.resetRenderLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.renderLists.iterator();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        RenderAsserts.validateCurrentThread();
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sectionByPosition.get(class_4076.method_18685((int)x, (int)y, (int)z));
        if (section != null && section.isBuilt()) {
            ChunkUpdateType pendingUpdate = RenderSectionManager.allowImportantRebuilds() && (important || this.shouldPrioritizeRebuild(section)) ? ChunkUpdateType.IMPORTANT_REBUILD : ChunkUpdateType.REBUILD;
            if (ChunkUpdateType.canPromote(section.getPendingUpdate(), pendingUpdate)) {
                section.setPendingUpdate(pendingUpdate);
                this.needsUpdate = true;
            }
        }
    }

    private boolean shouldPrioritizeRebuild(RenderSection section) {
        return this.lastCameraPosition != null && section.getSquaredDistance(this.lastCameraPosition) < NEARBY_REBUILD_DISTANCE;
    }

    private static boolean allowImportantRebuilds() {
        return !SodiumClientMod.options().performance.alwaysDeferChunkUpdates;
    }

    private float getEffectiveRenderDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        float renderDistance = this.getRenderDistance();
        if (!class_3532.method_15347((float)color[3], (float)1.0f)) {
            return renderDistance;
        }
        return Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return (float)this.renderDistance * 16.0f;
    }

    private void connectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        long deviceUsed = 0L;
        long deviceAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            RenderRegion.DeviceResources resources = region.getResources();
            if (resources == null) continue;
            GlBufferArena buffer = resources.getGeometryArena();
            deviceUsed += buffer.getDeviceUsedMemory();
            deviceAllocated += buffer.getDeviceAllocatedMemory();
            ++count;
        }
        list.add(String.format("Geometry Pool: %d/%d MiB (%d buffers)", MathUtil.toMib(deviceUsed), MathUtil.toMib(deviceAllocated), count));
        list.add(String.format("Transfer Queue: %s", this.regions.getStagingBuffer().toString()));
        list.add(String.format("Chunk Builder: Permits=%02d | Busy=%02d | Total=%02d", this.builder.getScheduledJobCount(), this.builder.getBusyThreadCount(), this.builder.getTotalThreadCount()));
        list.add(String.format("Chunk Queues: U=%02d (P0=%03d | P1=%03d | P2=%03d)", this.buildResults.size(), this.rebuildLists.get((Object)ChunkUpdateType.IMPORTANT_REBUILD).size(), this.rebuildLists.get((Object)ChunkUpdateType.REBUILD).size(), this.rebuildLists.get((Object)ChunkUpdateType.INITIAL_BUILD).size()));
        return list;
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }
}

