/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.blockentities.renderer;

import de.ambertation.wunderreich.blockentities.WunderKisteBlockEntity;
import de.ambertation.wunderreich.blocks.WunderKisteBlock;
import de.ambertation.wunderreich.client.WunderreichClient;
import de.ambertation.wunderreich.registries.WunderreichBlocks;
import de.ambertation.wunderreich.registries.WunderreichRules;
import de.ambertation.wunderreich.utils.WunderKisteDomain;
import de.ambertation.wunderreich.utils.WunderKisteServerExtension;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_5253;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_826;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class WunderkisteRenderer
extends class_826<WunderKisteBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private static final Vertex[] TOP_PLANE = new Vertex[]{new Vertex(0.125f, 0.6250625f, 0.125f, 0.8125f, 0.8125f), new Vertex(0.125f, 0.6250625f, 0.875f, 0.0625f, 0.8125f), new Vertex(0.875f, 0.6250625f, 0.875f, 0.0625f, 0.0625f), new Vertex(0.875f, 0.6250625f, 0.125f, 0.8125f, 0.0625f)};
    private final class_630 lid;
    private final class_630 bottom;
    private final class_630 lock;

    public WunderkisteRenderer(class_5614.class_5615 context) {
        super(context);
        class_630 modelPart = context.method_32140(class_5602.field_27689);
        this.bottom = modelPart.method_32086(BOTTOM);
        this.lid = modelPart.method_32086(LID);
        this.lock = modelPart.method_32086(LOCK);
    }

    private static class_4730 getTopMaterial(WunderKisteDomain d) {
        return d.useMonochromeFallback ? WunderreichClient.WUNDER_KISTE_MONOCHROME_TOP_LOCATION : WunderreichClient.WUNDER_KISTE_TOP_LOCATION;
    }

    public void render(WunderKisteBlockEntity blockEntity, float f, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int i, int overlayCoords) {
        class_2248 class_22482;
        class_1937 level = blockEntity.method_10997();
        boolean renderInWorld = level != null;
        class_2680 blockState = blockEntity.method_11010();
        if (blockState == null) {
            blockState = WunderreichBlocks.WUNDER_KISTE.method_9564();
        }
        if (!renderInWorld) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        }
        if ((class_22482 = blockState.method_26204()) instanceof class_4739) {
            class_4739 abstractChestBlock = (class_4739)class_22482;
            WunderKisteDomain d = WunderreichRules.Wunderkiste.showColors() ? WunderKisteServerExtension.getDomain(blockState) : WunderKisteBlock.DEFAULT_DOMAIN;
            poseStack.method_22903();
            float g = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-g));
            poseStack.method_22904(-0.5, -0.5, -0.5);
            class_4732.class_4734 neighborCombineResult = renderInWorld ? abstractChestBlock.method_24167(blockState, level, blockEntity.method_11016(), true) : class_4732.class_3923::method_24174;
            float openness = ((Float2FloatFunction)neighborCombineResult.apply(class_2281.method_24166((class_2618)blockEntity))).get(f);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int uv2 = ((Int2IntFunction)neighborCombineResult.apply((class_4732.class_3923)new class_4737())).applyAsInt(i);
            class_4730 material = d.getMaterial();
            class_4588 vertexConsumer = material.method_24145(multiBufferSource, class_1921::method_23576);
            this.render(poseStack, vertexConsumer, this.lid, this.lock, this.bottom, openness, uv2, overlayCoords, (float)class_5253.class_5254.method_27765((int)d.overlayColor) / 255.0f, (float)class_5253.class_5254.method_27766((int)d.overlayColor) / 255.0f, (float)class_5253.class_5254.method_27767((int)d.overlayColor) / 255.0f);
            if (openness > 0.0f) {
                material = WunderkisteRenderer.getTopMaterial(d);
                vertexConsumer = material.method_24145(multiBufferSource, class_1921::method_23572);
                this.renderAnimTop(poseStack, vertexConsumer, this.bottom, uv2, overlayCoords, (float)class_5253.class_5254.method_27765((int)d.color) / 255.0f, (float)class_5253.class_5254.method_27766((int)d.color) / 255.0f, (float)class_5253.class_5254.method_27767((int)d.color) / 255.0f);
            }
            poseStack.method_22909();
        }
    }

    private void render(class_4587 poseStack, class_4588 vertexConsumer, class_630 lidPart, class_630 lockPart, class_630 bottomPart, float f, int uv2, int overlayCoord, float r, float g, float b) {
        lockPart.field_3654 = lidPart.field_3654 = -(f * 1.5707964f);
        lidPart.method_22699(poseStack, vertexConsumer, uv2, overlayCoord, r, g, b, 1.0f);
        lockPart.method_22699(poseStack, vertexConsumer, uv2, overlayCoord, r, g, b, 1.0f);
        bottomPart.method_22699(poseStack, vertexConsumer, uv2, overlayCoord, r, g, b, 1.0f);
    }

    private void renderAnimTop(class_4587 poseStack, class_4588 vertexConsumer, class_630 bottomPart, int uv2, int overlayCords, float r, float g, float b) {
        poseStack.method_22903();
        bottomPart.method_22703(poseStack);
        class_4587.class_4665 last = poseStack.method_23760();
        Matrix4f pose = last.method_23761();
        Matrix3f npose = last.method_23762();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        normal.mul((Matrix3fc)npose);
        for (Vertex v : TOP_PLANE) {
            Vector4f vector4f = new Vector4f(v.pos.x(), v.pos.y(), v.pos.z(), 1.0f);
            vector4f.mul((Matrix4fc)pose);
            vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), r, g, b, 1.0f, v.u, v.v, overlayCords, uv2, normal.x(), normal.y(), normal.z());
        }
        poseStack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;

        public Vertex(float f, float g, float h, float i, float j) {
            this(new Vector3f(f, g, h), i, j);
        }

        public Vertex(Vector3f vector3f, float f, float g) {
            this.pos = vector3f;
            this.u = f;
            this.v = g;
        }
    }
}

