/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.whisperer;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderreich.gui.whisperer.WhisperRule;
import de.ambertation.wunderreich.gui.whisperer.WhispererMenu;
import de.ambertation.wunderreich.network.SelectWhisperMessage;
import de.ambertation.wunderreich.recipes.ImprinterRecipe;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WhispererScreen
extends class_465<WhispererMenu> {
    private static final class_2960 VILLAGER_LOCATION = new class_2960("textures/gui/container/villager2.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MERCHANT_MENU_PART_X = 99;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 5;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 89;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 94;
    private static final int TOP_MARGIN = 16;
    private static final int BORDER_WIDTH = 2;
    private static final class_2561 ENCHANTS_LABEL = class_2561.method_43471((String)"title.whisperer.enchant");
    private final WhispersButton[] enchantButtons = new WhispersButton[7];
    int scrollOff;
    private int shopItem;
    private boolean isDragging;

    public WhispererScreen(WhispererMenu merchantMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)merchantMenu, inventory, component);
        this.field_2792 = 276;
        this.field_25269 = 107;
    }

    private void postButtonClick() {
        ((WhispererMenu)this.field_2797).setSelectionHint(this.shopItem);
        ((WhispererMenu)this.field_2797).tryMoveItems(this.shopItem);
        SelectWhisperMessage.INSTANCE.send(this.shopItem);
    }

    protected void method_25426() {
        super.method_25426();
        int paddingX = (this.field_22789 - this.field_2792) / 2;
        int paddingY = (this.field_22790 - this.field_2779) / 2;
        int top = paddingY + 16 + 2;
        for (int idx = 0; idx < 7; ++idx) {
            this.enchantButtons[idx] = (WhispersButton)this.method_37063((class_364)new WhispersButton(paddingX + 5, top, idx, button -> {
                if (button instanceof WhispersButton) {
                    this.shopItem = ((WhispersButton)button).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            top += 20;
        }
    }

    protected void method_2388(@NotNull class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, 49 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 6, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
        int component = this.field_22793.method_27525((class_5348)ENCHANTS_LABEL);
        guiGraphics.method_51439(this.field_22793, ENCHANTS_LABEL, 5 - component / 2 + 48, 6, 0x404040, false);
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int paddingX = (this.field_22789 - this.field_2792) / 2;
        int paddingY = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25291(VILLAGER_LOCATION, paddingX, paddingY, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
    }

    private void renderScroller(class_332 guiGraphics, int x, int y, List<ImprinterRecipe> enchants) {
        int pageCount = enchants.size() - 7;
        if (pageCount > 0) {
            int SCROLLER_MAX_Y = 113;
            float STEP_PER_PAGE = 113.0f / (float)pageCount;
            int scrollerOffset = Math.min(113, (int)((float)this.scrollOff * STEP_PER_PAGE));
            if (this.scrollOff == pageCount) {
                scrollerOffset = 113;
            }
            guiGraphics.method_25291(VILLAGER_LOCATION, x + 94, y + 18 + scrollerOffset, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            guiGraphics.method_25291(VILLAGER_LOCATION, x + 94, y + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int i, int j, float f) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, i, j, f);
        List<ImprinterRecipe> enchants = ((WhispererMenu)this.field_2797).getEnchants();
        if (!enchants.isEmpty()) {
            int paddingX = (this.field_22789 - this.field_2792) / 2;
            int paddingY = (this.field_22790 - this.field_2779) / 2;
            int top = paddingY + 16 + 1;
            int left = paddingX + 5 + 5;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
            this.renderScroller(guiGraphics, paddingX, paddingY, enchants);
            int o = 0;
            for (WhisperRule whisperRule : enchants) {
                if (this.canScroll(enchants.size()) && (o < this.scrollOff || o >= 7 + this.scrollOff)) {
                    ++o;
                    continue;
                }
                class_1799 costA = whisperRule.getInputA();
                class_1799 costB = whisperRule.getInputB();
                class_1799 result = whisperRule.output;
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                int decorateY = top + 2;
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
                guiGraphics.method_51445(whisperRule.type, 2 * (left - 2), 2 * (decorateY + 7));
                guiGraphics.method_51448().method_22909();
                this.renderAndDecorateCostA(guiGraphics, costA, left + 12, decorateY);
                if (!costB.method_7960()) {
                    guiGraphics.method_51445(costB, paddingX + 5 + 35, decorateY);
                    guiGraphics.method_51431(this.field_22793, costB, paddingX + 5 + 35, decorateY);
                }
                this.renderButtonArrows(guiGraphics, whisperRule, paddingX, decorateY);
                guiGraphics.method_51445(result, paddingX + 5 + 68, decorateY);
                guiGraphics.method_51431(this.field_22793, result, paddingX + 5 + 68, decorateY);
                guiGraphics.method_51448().method_22909();
                top += 20;
                ++o;
            }
            for (WhispersButton tradeOfferButton : this.enchantButtons) {
                if (tradeOfferButton.method_25367()) {
                    tradeOfferButton.renderToolTip(guiGraphics, i, j);
                }
                tradeOfferButton.field_22764 = tradeOfferButton.index < ((WhispererMenu)this.field_2797).getEnchants().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.method_2380(guiGraphics, i, j);
    }

    private void renderButtonArrows(class_332 guiGraphics, WhisperRule rule, int x, int y) {
        RenderSystem.enableBlend();
        guiGraphics.method_25291(VILLAGER_LOCATION, x + 5 + 35 + 20, y + 3, 0, 15.0f, 171.0f, 10, 9, 512, 256);
    }

    private void renderAndDecorateCostA(class_332 guiGraphics, class_1799 costA, int x, int y) {
        guiGraphics.method_51445(costA, x, y);
        guiGraphics.method_51431(this.field_22793, costA, x, y);
    }

    private boolean canScroll(int i) {
        return i > 7;
    }

    public boolean method_25401(double d, double e, double f) {
        int i = ((WhispererMenu)this.field_2797).getEnchants().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = (int)((double)this.scrollOff - f);
            this.scrollOff = class_3532.method_15340((int)this.scrollOff, (int)0, (int)j);
        }
        return true;
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        int j = ((WhispererMenu)this.field_2797).getEnchants().size();
        if (this.isDragging) {
            int k = this.field_2800 + 18;
            int l = k + 139;
            int m = j - 7;
            float h = ((float)e - (float)k - 13.5f) / ((float)(l - k) - 27.0f);
            h = h * (float)m + 0.5f;
            this.scrollOff = class_3532.method_15340((int)((int)h), (int)0, (int)m);
            return true;
        }
        return super.method_25403(d, e, i, f, g);
    }

    public boolean method_25402(double mx, double my, int i) {
        this.isDragging = false;
        int paddingX = (this.field_22789 - this.field_2792) / 2;
        int paddingY = (this.field_22790 - this.field_2779) / 2;
        if (this.canScroll(((WhispererMenu)this.field_2797).getEnchants().size()) && mx > (double)(paddingX + 94) && mx < (double)(paddingX + 94 + 6) && my > (double)(paddingY + 18) && my <= (double)(paddingY + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.method_25402(mx, my, i);
    }

    @Environment(value=EnvType.CLIENT)
    class WhispersButton
    extends class_4185 {
        final int index;

        public WhispersButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 89, 20, (class_2561)class_2561.method_43473(), onPress, class_4185.field_40754);
            this.index = index;
            this.field_22764 = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(@NotNull class_332 guiGraphics, int i, int j) {
            if (this.field_22762 && ((WhispererMenu)WhispererScreen.this.field_2797).getEnchants().size() > this.index + WhispererScreen.this.scrollOff) {
                if (i < this.method_46426() + 20) {
                    class_5250 typeName = class_2561.method_43471((String)("enchantment.type." + ((WhispererMenu)WhispererScreen.this.field_2797).getEnchants().get(this.index + WhispererScreen.this.scrollOff).getCategory()));
                    guiGraphics.method_51438(WhispererScreen.this.field_22793, (class_2561)typeName, i, j);
                } else if (i < this.method_46426() + 50 && i > this.method_46426() + 30) {
                    class_1799 itemStack = ((WhispererMenu)WhispererScreen.this.field_2797).getEnchants().get(this.index + WhispererScreen.this.scrollOff).getInputA();
                    if (!itemStack.method_7960()) {
                        guiGraphics.method_51446(WhispererScreen.this.field_22793, itemStack, i, j);
                    }
                } else if (i > this.method_46426() + 65) {
                    class_1799 itemStack = ((WhispererMenu)((WhispererScreen)WhispererScreen.this).field_2797).getEnchants().get((int)(this.index + WhispererScreen.this.scrollOff)).output;
                    guiGraphics.method_51446(WhispererScreen.this.field_22793, itemStack, i, j);
                }
            }
        }
    }
}

