/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.gui.whisperer.EnchantmentInfo;
import de.ambertation.wunderreich.gui.whisperer.WhisperContainer;
import de.ambertation.wunderreich.gui.whisperer.WhisperRule;
import de.ambertation.wunderreich.registries.WunderreichBlocks;
import de.ambertation.wunderreich.registries.WunderreichRecipes;
import de.ambertation.wunderreich.registries.WunderreichRules;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ImprinterRecipe
extends WhisperRule
implements class_1860<WhisperContainer> {
    public static final int COST_A_SLOT = 0;
    public static final int COST_B_SLOT = 1;
    private static final List<ImprinterRecipe> RECIPES = new LinkedList<ImprinterRecipe>();
    private final class_2960 id;

    private ImprinterRecipe(class_2960 id, class_1887 enchantment, class_1856 inputA, class_1856 inputB, int baseXP) {
        super(enchantment, inputA, inputB, baseXP);
        this.id = id;
    }

    private ImprinterRecipe(class_2960 id, class_1887 enchantment, class_1856 inputA, class_1856 inputB, class_1799 output, int baseXP, class_1799 type) {
        super(enchantment, inputA, inputB, output, baseXP, type);
        this.id = id;
    }

    private ImprinterRecipe(class_1887 e) {
        super(e);
        this.id = ImprinterRecipe.makeID(e);
    }

    @NotNull
    private static class_2960 makeID(class_1887 e) {
        return Wunderreich.ID(Type.ID.method_12832() + "/" + e.method_8184());
    }

    public static List<ImprinterRecipe> getRecipes() {
        return RECIPES;
    }

    public static List<ImprinterRecipe> getUISortedRecipes() {
        return RECIPES.stream().sorted(Comparator.comparing(a -> a.getCategory() + ":" + a.getName())).collect(Collectors.toList());
    }

    private static void resortRecipes() {
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Serializer.ID, (Object)Serializer.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)Type.ID, Type.INSTANCE);
        RECIPES.clear();
        if (WunderreichRules.Whispers.allowLibrarianSelection()) {
            LinkedList<class_1887> enchants = new LinkedList<class_1887>();
            class_7923.field_41176.method_10220().filter(e -> e.method_25949()).forEach(e -> {
                class_2960 ID2 = ImprinterRecipe.makeID(e);
                if (((Boolean)Configs.RECIPE_CONFIG.newBooleanFor(ID2.method_12832(), ID2).get()).booleanValue()) {
                    enchants.add((class_1887)e);
                }
            });
            enchants.sort(Comparator.comparing(a -> WhisperRule.getFullname(a).getString()));
            enchants.forEach(e -> {
                ImprinterRecipe r = new ImprinterRecipe((class_1887)e);
                RECIPES.add(r);
                WunderreichRecipes.RECIPES.put(r.id, Serializer.INSTANCE.toJson(r));
            });
        }
        ImprinterRecipe.resortRecipes();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)WunderreichBlocks.WHISPER_IMPRINTER);
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.inputA, this.inputB});
    }

    public boolean matches(WhisperContainer inv, class_1937 level) {
        if (inv.method_5439() < 2) {
            return false;
        }
        return this.inputA.method_8093(inv.method_5438(0)) && this.inputB.method_8093(inv.method_5438(1)) || this.inputA.method_8093(inv.method_5438(1)) && this.inputB.method_8093(inv.method_5438(0));
    }

    public class_1799 assemble(WhisperContainer container, class_5455 registryAccess) {
        return this.output.method_7972();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImprinterRecipe)) {
            return false;
        }
        ImprinterRecipe that = (ImprinterRecipe)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static class Type
    implements class_3956<ImprinterRecipe> {
        public static final class_2960 ID = Wunderreich.ID("imprinter");
        public static final class_3956<ImprinterRecipe> INSTANCE = new Type();

        Type() {
        }

        public String toString() {
            return ID.toString();
        }
    }

    private static class Serializer
    implements class_1865<ImprinterRecipe> {
        public static final class_2960 ID = Type.ID;
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public ImprinterRecipe fromNetwork(class_2960 id, class_2540 packetBuffer) {
            class_1856 costA = class_1856.method_8086((class_2540)packetBuffer);
            byte count = packetBuffer.readByte();
            if (costA.method_8105().length > 0 && count > 0) {
                class_1799 stack = new class_1799((class_1935)costA.method_8105()[0].method_7909(), (int)count);
                costA = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            }
            class_1856 costB = class_1856.method_8086((class_2540)packetBuffer);
            class_1799 output = packetBuffer.method_10819();
            packetBuffer.readByte();
            class_1799 type = packetBuffer.method_10819();
            int baseXP = packetBuffer.method_10816();
            class_2960 eID = packetBuffer.method_10810();
            Optional enchantment = class_7923.field_41176.method_17966(eID);
            return new ImprinterRecipe(id, (class_1887)enchantment.orElseThrow(() -> new RuntimeException("Unknown Enchantment " + eID)), costA, costB, output, baseXP, type);
        }

        public void toNetwork(class_2540 buf, ImprinterRecipe recipe) {
            recipe.inputA.method_8088(buf);
            buf.writeByte(recipe.inputA.method_8105().length == 0 ? 0 : recipe.inputA.method_8105()[0].method_7947());
            recipe.inputB.method_8088(buf);
            buf.method_10793(recipe.output);
            buf.writeByte(0);
            buf.method_10793(recipe.type);
            buf.method_10804(recipe.baseXP);
            buf.method_10812(class_1890.method_37423((class_1887)recipe.enchantment));
        }

        public JsonElement toJson(ImprinterRecipe r) {
            ImprinterRecipeJsonFormat recipeJson = new ImprinterRecipeJsonFormat();
            recipeJson.enchantment = class_7923.field_41176.method_10221((Object)r.enchantment).toString();
            recipeJson.xp = r.baseXP;
            recipeJson.inputA = r.inputA.method_8089();
            recipeJson.count = r.inputA.method_8105().length == 0 ? 0 : r.inputA.method_8105()[0].method_7947();
            recipeJson.inputB = r.inputB.method_8089();
            recipeJson.type = Type.ID.toString();
            JsonObject root = new JsonObject();
            root.add("type", (JsonElement)new JsonPrimitive(recipeJson.type));
            root.add("enchantment", (JsonElement)new JsonPrimitive(recipeJson.enchantment));
            root.add("xp", (JsonElement)new JsonPrimitive((Number)recipeJson.xp));
            root.add("inputA", recipeJson.inputA);
            root.add("count", (JsonElement)new JsonPrimitive((Number)recipeJson.count));
            root.add("inputB", recipeJson.inputB);
            return root;
        }

        public ImprinterRecipe fromJson(class_2960 id, JsonObject json) {
            ImprinterRecipeJsonFormat recipeJson = (ImprinterRecipeJsonFormat)new Gson().fromJson((JsonElement)json, ImprinterRecipeJsonFormat.class);
            if (recipeJson.inputA == null) {
                throw new JsonSyntaxException("The Attribute 'inputA' is missing.");
            }
            if (recipeJson.inputB == null) {
                throw new JsonSyntaxException("The Attribute 'inputB' is missing.");
            }
            if (recipeJson.enchantment == null) {
                throw new JsonSyntaxException("The Attribute 'output' is missing.");
            }
            class_2960 eID = new class_2960(recipeJson.enchantment);
            Optional enchantment = class_7923.field_41176.method_17966(eID);
            if (!enchantment.isPresent()) {
                throw new JsonParseException("Unknown Enchantment " + eID);
            }
            class_1856 inputA = class_1856.method_52177((JsonElement)recipeJson.inputA);
            if (inputA.method_8105().length > 0 && recipeJson.count > 0) {
                class_1799 stack = new class_1799((class_1935)inputA.method_8105()[0].method_7909(), recipeJson.count);
                inputA = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            }
            class_1856 inputB = class_1856.method_52177((JsonElement)recipeJson.inputB);
            if (recipeJson.xp <= 0) {
                EnchantmentInfo ei = new EnchantmentInfo((class_1887)enchantment.get());
                recipeJson.xp = ei.baseXP;
            }
            ImprinterRecipe r = new ImprinterRecipe(id, (class_1887)enchantment.get(), inputA, inputB, recipeJson.xp);
            RECIPES.remove(r);
            RECIPES.add(r);
            ImprinterRecipe.resortRecipes();
            return r;
        }

        static class ImprinterRecipeJsonFormat {
            String type;
            JsonElement inputA;
            int count;
            JsonElement inputB;
            int xp;
            String enchantment;

            ImprinterRecipeJsonFormat() {
            }
        }
    }
}

