/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.advancements.AdvancementsJsonBuilder;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.registries.WunderreichRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class RecipeJsonBuilder {
    private static final ThreadLocal<RecipeJsonBuilder> BUILDER = ThreadLocal.withInitial(RecipeJsonBuilder::new);
    final Map<Character, class_1856> materials = new HashMap<Character, class_1856>();
    class_2960 ID;
    boolean canBuild;
    class_1935 resultItem;
    String[] pattern;
    int count;

    private RecipeJsonBuilder() {
    }

    public static void invalidate() {
        BUILDER.remove();
    }

    private static boolean isEnabled(class_1935 item) {
        if (item instanceof class_2248) {
            class_2248 bl = (class_2248)item;
            return Configs.BLOCK_CONFIG.isEnabled(bl);
        }
        if (item instanceof class_1792) {
            class_1792 itm = (class_1792)item;
            return Configs.ITEM_CONFIG.isEnabled(itm);
        }
        return false;
    }

    private static class_2960 getKey(class_1935 item) {
        if (item instanceof class_2248) {
            class_2248 bl = (class_2248)item;
            return class_7923.field_41175.method_10221((Object)bl);
        }
        if (item instanceof class_1792) {
            class_1792 itm = (class_1792)item;
            return class_7923.field_41178.method_10221((Object)itm);
        }
        return null;
    }

    public static RecipeJsonBuilder create(String name) {
        class_2960 id = Wunderreich.ID(name);
        RecipeJsonBuilder b = BUILDER.get().reset(id);
        return b;
    }

    private RecipeJsonBuilder reset(class_2960 ID2) {
        this.ID = ID2;
        this.canBuild = (Boolean)Configs.RECIPE_CONFIG.newBooleanFor(ID2.method_12832(), ID2).get();
        this.resultItem = null;
        this.pattern = new String[0];
        this.materials.clear();
        this.count = 1;
        return this;
    }

    public RecipeJsonBuilder result(class_1935 item) {
        this.canBuild &= RecipeJsonBuilder.isEnabled(item);
        this.resultItem = item;
        return this;
    }

    public RecipeJsonBuilder pattern(String row1, String row2, String row3) {
        this.pattern = new String[]{row1, row2, row3};
        return this;
    }

    public RecipeJsonBuilder pattern(String row1, String row2) {
        this.pattern = new String[]{row1, row2};
        return this;
    }

    public RecipeJsonBuilder pattern(String row1) {
        this.pattern = new String[]{row1};
        return this;
    }

    public RecipeJsonBuilder material(Character c, class_1935 ... items) {
        return this.material(c, class_1856.method_8091((class_1935[])items));
    }

    public RecipeJsonBuilder material(Character c, class_1799 ... items) {
        return this.material(c, class_1856.method_8101((class_1799[])items));
    }

    public RecipeJsonBuilder material(Character c, class_1856 ing) {
        this.canBuild &= Arrays.stream(ing.method_8105()).map(class_1799::method_7909).map(RecipeJsonBuilder::isEnabled).noneMatch(v -> v == false);
        this.materials.put(c, ing);
        return this;
    }

    public RecipeJsonBuilder count(int count) {
        this.count = count;
        return this;
    }

    public boolean canBuild() {
        return this.canBuild;
    }

    public JsonElement registerAndCreateAdvancement(AdvancementsJsonBuilder.AdvancementType type) {
        ArrayList<class_1792> items = new ArrayList<class_1792>(this.materials.size());
        for (class_1856 mat : this.materials.values()) {
            for (class_1799 item : mat.method_8105()) {
                items.add(item.method_7909());
            }
        }
        return this.registerAndCreateAdvancement(type, items);
    }

    public JsonElement registerAndCreateAdvancement(AdvancementsJsonBuilder.AdvancementType type, List<class_1792> items) {
        JsonElement res = this.register();
        if (res == null) {
            return null;
        }
        if (items.size() == 0) {
            return res;
        }
        AdvancementsJsonBuilder b = null;
        class_1935 class_19352 = this.resultItem;
        if (class_19352 instanceof class_2248) {
            class_2248 bl = (class_2248)class_19352;
            b = AdvancementsJsonBuilder.createRecipe(bl.method_8389(), type);
        } else {
            class_19352 = this.resultItem;
            if (class_19352 instanceof class_1792) {
                class_1792 itm = (class_1792)class_19352;
                b = AdvancementsJsonBuilder.createRecipe(itm, type);
            }
        }
        if (b != null) {
            int ct = 0;
            for (class_1792 item : items) {
                String name = "has_" + ct++;
                b.inventoryChangedCriteria(name, item);
            }
            b.register();
        }
        return res;
    }

    public JsonElement register() {
        if (!this.canBuild) {
            Wunderreich.LOGGER.info("Discarding Recipe for " + this.ID);
            return null;
        }
        JsonElement res = this.build();
        WunderreichRecipes.RECIPES.put(this.ID, res);
        return res;
    }

    public JsonElement build() {
        if (!this.canBuild) {
            Wunderreich.LOGGER.info("Discarding Recipe for " + this.ID);
            return null;
        }
        if (this.resultItem == null) {
            throw new IllegalStateException("A Recipe needs a Result (" + this.ID + ")");
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray patternArray = new JsonArray();
        for (String s : this.pattern) {
            patternArray.add(s);
        }
        json.add("pattern", (JsonElement)patternArray);
        JsonObject keyList = new JsonObject();
        for (Map.Entry entry : this.materials.entrySet()) {
            class_1856 ing = (class_1856)entry.getValue();
            class_1799[] items = ing.method_8105();
            JsonArray individualContainer = new JsonArray();
            for (class_1799 stack : items) {
                JsonObject individualKey = new JsonObject();
                class_2960 il = RecipeJsonBuilder.getKey((class_1935)stack.method_7909());
                if (il == null) {
                    Wunderreich.LOGGER.info("Ignoring Recipe for " + this.ID + " due to missing item.");
                    return null;
                }
                individualKey.addProperty("item", il.toString());
                if (stack.method_7947() > 1) {
                    individualKey.addProperty("count", (Number)stack.method_7947());
                }
                individualContainer.add((JsonElement)individualKey);
            }
            keyList.add("" + entry.getKey(), (JsonElement)individualContainer);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        class_2960 class_29602 = RecipeJsonBuilder.getKey(this.resultItem);
        if (class_29602 == null) {
            Wunderreich.LOGGER.info("Ignoring Recipe for " + this.ID + " due to missing result item.");
            return null;
        }
        result.addProperty("item", class_29602.toString());
        result.addProperty("count", (Number)this.count);
        json.add("result", (JsonElement)result);
        return json;
    }
}

