/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils.nbt;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class CachedNBTValue<D, T extends class_2520> {
    private final class_2487 baseTag;
    private D cachedValue = null;
    private final D defaultValue;
    public final String tagName;
    private final Function<T, D> getter;
    private final Function<D, class_2520> setter;
    private final BiConsumer<D, D> changed;

    public CachedNBTValue(class_2487 baseTag, String tagName, Function<T, D> getter, Function<D, class_2520> setter) {
        this(baseTag, tagName, getter, setter, (D old, D fresh) -> {});
    }

    public CachedNBTValue(class_2487 baseTag, String tagName, D defaultValue, Function<T, D> getter, Function<D, class_2520> setter) {
        this(baseTag, tagName, defaultValue, getter, setter, (old, fresh) -> {});
    }

    public CachedNBTValue(class_2487 baseTag, String tagName, Function<T, D> getter, Function<D, class_2520> setter, BiConsumer<D, D> changed) {
        this(baseTag, tagName, null, getter, setter, changed);
        if (changed == null) {
            changed = (old, fresh) -> {};
        }
    }

    public CachedNBTValue(class_2487 baseTag, String tagName, D defaultValue, Function<T, D> getter, Function<D, class_2520> setter, BiConsumer<D, D> changed) {
        this.defaultValue = defaultValue;
        this.baseTag = baseTag;
        this.tagName = tagName;
        this.getter = getter;
        this.setter = setter;
        this.changed = changed;
    }

    public D get() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        if (!this.baseTag.method_10545(this.tagName)) {
            return this.defaultValue;
        }
        this.cachedValue = this.getter.apply(this.baseTag.method_10580(this.tagName));
        if (this.cachedValue == null) {
            this.cachedValue = this.defaultValue;
        }
        this.changed.accept(this.defaultValue, this.cachedValue);
        return this.cachedValue;
    }

    public void set(D newValue) {
        D oldValue = this.cachedValue;
        this.cachedValue = newValue;
        if (newValue == null) {
            if (this.baseTag.method_10545(this.tagName)) {
                this.baseTag.method_10551(this.tagName);
            }
        } else {
            this.baseTag.method_10566(this.tagName, this.setter.apply(newValue));
        }
        if (oldValue == null) {
            oldValue = this.defaultValue;
        }
        if (this.cachedValue == null) {
            this.cachedValue = this.defaultValue;
        }
        this.changed.accept(oldValue, this.cachedValue);
    }
}

