/*
 * Decompiled with CFR 0.152.
 */
package net.quackimpala7321.crafter.block;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3955;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5000;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8566;
import net.quackimpala7321.crafter.block.entity.CrafterBlockEntity;
import net.quackimpala7321.crafter.recipe.RecipeCache;
import net.quackimpala7321.crafter.registry.ModBlockEntities;
import net.quackimpala7321.crafter.registry.ModProperties;
import net.quackimpala7321.crafter.util.ItemScattererAccessor;
import org.jetbrains.annotations.Nullable;

public class CrafterBlock
extends class_2237 {
    public static final class_2746 CRAFTING;
    public static final class_2746 TRIGGERED;
    private static final class_2754<class_5000> ORIENTATION;
    private static final int field_46802 = 6;
    private static final RecipeCache recipeCache;
    private static final Codec<class_4970.class_2251> SETTINGS_CODEC;
    public static final MapCodec<CrafterBlock> CODEC;

    public CrafterBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(ORIENTATION, (Comparable)class_5000.field_23391)).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CRAFTING, (Comparable)Boolean.valueOf(false)));
    }

    protected static <B extends class_2248> RecordCodecBuilder<B, class_4970.class_2251> createSettingsCodec() {
        return SETTINGS_CODEC.fieldOf("properties").forGetter(b -> ((AbstractBlockAccessor)b).getSettings());
    }

    public static <B extends class_2248> MapCodec<B> createCodec(Function<class_4970.class_2251, B> blockFromSettings) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(CrafterBlock.createSettingsCodec()).apply((Applicative)instance, blockFromSettings));
    }

    protected MapCodec<CrafterBlock> getCodec() {
        return CODEC;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
            return crafterBlockEntity.getComparatorOutput();
        }
        return 0;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        boolean powered = world.method_49803(pos);
        boolean triggered = (Boolean)state.method_11654((class_2769)TRIGGERED);
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof CrafterBlockEntity)) {
            return;
        }
        CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)class_25862;
        if (powered && !triggered) {
            world.method_39279(pos, (class_2248)this, 1);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
            this.setTriggered((class_2586)crafterBlockEntity, true);
        } else if (!powered && triggered) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CRAFTING, (Comparable)Boolean.valueOf(false)), 2);
            this.setTriggered((class_2586)crafterBlockEntity, false);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.craft(state, world, pos);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : CrafterBlock.method_31618(type, ModBlockEntities.CRAFTER, CrafterBlockEntity::tickCrafting);
    }

    private void setTriggered(@Nullable class_2586 blockEntity, boolean triggered) {
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
            crafterBlockEntity.setTriggered(triggered);
        }
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        CrafterBlockEntity crafterBlockEntity = new CrafterBlockEntity(pos, state);
        crafterBlockEntity.setTriggered(state.method_28498((class_2769)TRIGGERED) && (Boolean)state.method_11654((class_2769)TRIGGERED) != false);
        return crafterBlockEntity;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_7715().method_10153();
        class_2350 direction2 = switch (direction) {
            case class_2350.field_11033 -> ctx.method_8042().method_10153();
            case class_2350.field_11036 -> ctx.method_8042();
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> class_2350.field_11036;
            default -> throw new IncompatibleClassChangeError();
        };
        return (class_2680)((class_2680)this.method_9564().method_11657(ORIENTATION, (Comparable)class_5000.method_26425((class_2350)direction, (class_2350)direction2))).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(ctx.method_8045().method_49803(ctx.method_8037())));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 var7;
        if (itemStack.method_7938() && (var7 = world.method_8321(pos)) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)var7;
            crafterBlockEntity.method_17488(itemStack.method_7964());
        }
        if (((Boolean)state.method_11654((class_2769)TRIGGERED)).booleanValue()) {
            world.method_39279(pos, (class_2248)this, 1);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        ItemScattererAccessor.onStateReplaced(state, newState, world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
            player.method_17355((class_3908)crafterBlockEntity);
        }
        return class_1269.field_21466;
    }

    protected void craft(class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof CrafterBlockEntity)) {
            return;
        }
        CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
        Optional<class_3955> optional = CrafterBlock.getCraftingRecipe((class_1937)world, crafterBlockEntity);
        if (optional.isEmpty()) {
            world.method_20290(1050, pos, 0);
        } else {
            crafterBlockEntity.setCraftingTicksRemaining(6);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)CRAFTING, (Comparable)Boolean.valueOf(true)), 2);
            class_3955 craftingRecipe = optional.get();
            class_1799 itemStack = craftingRecipe.method_8116((class_1263)crafterBlockEntity, world.method_30349());
            this.transferOrSpawnStack((class_1937)world, pos, crafterBlockEntity, itemStack, state);
            craftingRecipe.method_8111((class_1263)crafterBlockEntity).forEach(stack -> this.transferOrSpawnStack((class_1937)world, pos, crafterBlockEntity, (class_1799)stack, state));
            crafterBlockEntity.method_11282().stream().filter(invStack -> !invStack.method_7960()).forEach(invStack -> invStack.method_7934(1));
            crafterBlockEntity.method_5431();
        }
    }

    public static Optional<class_3955> getCraftingRecipe(class_1937 world, class_8566 inputInventory) {
        return recipeCache.getRecipe(world, inputInventory);
    }

    private void transferOrSpawnStack(class_1937 world, class_2338 pos, CrafterBlockEntity blockEntity, class_1799 stack, class_2680 state) {
        class_2350 direction = ((class_5000)state.method_11654(ORIENTATION)).method_26426();
        class_1263 inventory = class_2614.method_11250((class_1937)world, (class_2338)pos.method_10093(direction));
        class_1799 itemStack = stack.method_7972();
        if (inventory instanceof CrafterBlockEntity) {
            class_1799 itemStack2;
            class_1799 itemStack3;
            while (!itemStack.method_7960() && (itemStack3 = class_2614.method_11260((class_1263)blockEntity, (class_1263)inventory, (class_1799)(itemStack2 = itemStack.method_46651(1)), (class_2350)direction.method_10153())).method_7960()) {
                itemStack.method_7934(1);
            }
        } else if (inventory != null) {
            int i;
            while (!itemStack.method_7960() && (i = itemStack.method_7947()) != (itemStack = class_2614.method_11260((class_1263)blockEntity, (class_1263)inventory, (class_1799)itemStack, (class_2350)direction.method_10153())).method_7947()) {
            }
        }
        if (!itemStack.method_7960()) {
            class_243 vec3d = class_243.method_24953((class_2382)pos).method_43206(direction, 0.7);
            class_2347.method_10134((class_1937)world, (class_1799)itemStack, (int)6, (class_2350)direction, (class_2374)vec3d);
            world.method_20290(1049, pos, 0);
            world.method_20290(2010, pos, direction.method_10146());
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)rotation.method_26383().method_26389((class_5000)state.method_11654(ORIENTATION)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)mirror.method_26380().method_26389((class_5000)state.method_11654(ORIENTATION)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ORIENTATION, TRIGGERED, CRAFTING});
    }

    static {
        SETTINGS_CODEC = Codec.unit(class_4970.class_2251::new);
        CODEC = CrafterBlock.createCodec(CrafterBlock::new);
        CRAFTING = ModProperties.CRAFTING;
        TRIGGERED = class_2741.field_12522;
        ORIENTATION = class_2741.field_23333;
        recipeCache = new RecipeCache(10);
    }
}

