/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import net.createmod.catnip.data.Pair;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.antarcticgardens.cna.CNARenderTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.connector.Wire;
import org.antarcticgardens.cna.content.electricity.connector.WireSection;
import org.antarcticgardens.cna.content.electricity.wire.ElectricWireItem;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.antarcticgardens.cna.util.RaycastUtil;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElectricalConnectorRenderer
implements class_827<ElectricalConnectorBlockEntity> {
    public ElectricalConnectorRenderer(class_5614.class_5615 context) {
    }

    public void render(ElectricalConnectorBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        this.renderAllConnections(blockEntity, poseStack, buffer);
        this.renderHand(blockEntity, partialTick, poseStack, buffer);
    }

    public void renderAllConnections(ElectricalConnectorBlockEntity blockEntity, class_4587 poseStack, class_4597 buffer) {
        blockEntity.getConnectorPositions().entrySet().stream().forEach(e -> this.renderConnection(blockEntity.method_11016(), (class_2338)e.getKey(), (WireType)((Object)((Object)e.getValue())), poseStack, buffer, blockEntity.method_10997()));
    }

    public boolean shouldRenderConnection(class_2338 pos, class_2338 endPos) {
        if (pos.method_10263() < endPos.method_10263()) {
            return true;
        }
        if (pos.method_10263() == endPos.method_10263()) {
            if (pos.method_10264() < endPos.method_10264()) {
                return true;
            }
            if (pos.method_10264() == endPos.method_10264() && pos.method_10260() < endPos.method_10260()) {
                return true;
            }
        }
        return false;
    }

    public void renderConnection(class_2338 pos, class_2338 endPos, WireType wireType, class_4587 poseStack, class_4597 buffer, class_1937 level) {
        if (!this.shouldRenderConnection(pos, endPos)) {
            return;
        }
        class_2960 texture = wireType.getTextureLocation();
        double distance = pos.method_46558().method_1022(endPos.method_46558());
        int sections = (int)Math.ceil(distance * (double)((Integer)CNAConfig.getClient().wireSectionsPerMeter.get()).intValue());
        Vector3f direction = endPos.method_46558().method_1020(pos.method_46558()).method_1029().method_46409();
        Wire wire = new Wire(direction, (float)distance, sections);
        class_4588 consumer = buffer.getBuffer(CNARenderTypes.wire(texture));
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_34425(new Matrix4f().rotateTowards((Vector3fc)wire.getDirection(), (Vector3fc)wire.getUp()));
        for (int i = 0; i < wire.getSections().size(); ++i) {
            Pair<WireSection, Float> pair = wire.getSections().get(i);
            float sectionOffset = wire.getSectionLength() * (float)i;
            Vector3f lightPos = pos.method_46558().method_46409().add((Vector3fc)wire.getDirection().mul(sectionOffset)).add((Vector3fc)wire.getUp().mul(((Float)pair.getSecond()).floatValue()));
            class_2338 lightBlockPos = class_2338.method_49638((class_2374)new class_243(lightPos));
            int block = level.method_8314(class_1944.field_9282, lightBlockPos);
            int sky = level.method_8314(class_1944.field_9284, lightBlockPos);
            ((WireSection)pair.getFirst()).render(consumer, poseStack, class_765.method_23687((int)block, (int)sky), ((Float)pair.getSecond()).floatValue());
            poseStack.method_46416(0.0f, 0.0f, wire.getSectionLength());
        }
        poseStack.method_22909();
    }

    public void renderHand(ElectricalConnectorBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && class_310.method_1551().field_1690.method_31044().method_31034()) {
            ElectricWireItem wireItem;
            class_2338 bound;
            class_1792 class_17922;
            class_1799 itemInHand = player.method_6047();
            if (!(itemInHand.method_7909() instanceof ElectricWireItem)) {
                itemInHand = player.method_6079();
            }
            if ((class_17922 = itemInHand.method_7909()) instanceof ElectricWireItem && (bound = (wireItem = (ElectricWireItem)class_17922).getBoundConnector(itemInHand)) != null && bound.equals((Object)blockEntity.method_11016())) {
                int maxDistance;
                class_243 eyePos = class_310.method_1551().field_1773.method_19418().method_19326();
                class_243 endPos = eyePos.method_1019(player.method_5828(partialTick).method_1029().method_1021(2.0));
                class_239 hit = RaycastUtil.pickBlockFromPos(blockEntity.method_10997(), eyePos, player.method_5828(partialTick), class_310.method_1551().field_1761.method_2904(), (class_1297)class_310.method_1551().field_1724);
                if (hit instanceof class_3965) {
                    class_3965 blockHit = (class_3965)hit;
                    class_243 vec = eyePos.method_1019(blockHit.method_17784().method_1020(eyePos).method_1021((double)0.9f));
                    if (eyePos.method_1022(endPos) > eyePos.method_1022(vec)) {
                        endPos = vec;
                    }
                }
                class_2338 pos = blockEntity.method_11016();
                Vector3f to = new Vector3f((float)(endPos.field_1352 - (double)pos.method_10263() - 0.5), (float)(endPos.field_1351 - (double)pos.method_10264() - 0.5), (float)(endPos.field_1350 - (double)pos.method_10260() - 0.5));
                double distance = endPos.method_1022(bound.method_46558());
                if (distance > (double)((maxDistance = ((Integer)CNAConfig.getCommon().maxWireLength.get()).intValue()) * 2)) {
                    return;
                }
                if (class_310.method_1551().field_1761 != null && hit instanceof class_3965) {
                    class_3965 blockHit = (class_3965)hit;
                    class_2586 class_25862 = blockEntity.method_10997().method_8321(blockHit.method_17777());
                    if (class_25862 instanceof ElectricalConnectorBlockEntity) {
                        ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)class_25862;
                        if (connector.isConnected(blockEntity.method_11016())) {
                            return;
                        }
                        to = new Vector3f((float)(blockHit.method_17777().method_10263() - pos.method_10263()), (float)(blockHit.method_17777().method_10264() - pos.method_10264()), (float)(blockHit.method_17777().method_10260() - pos.method_10260()));
                        distance = connector.method_11016().method_46558().method_1022(blockEntity.method_11016().method_46558());
                    }
                }
                class_2960 texture = wireItem.getWireType().getTextureLocation();
                if (distance >= (double)maxDistance) {
                    texture = new class_2960("create_new_age", "textures/wire/red.png");
                }
                int sections = (int)Math.ceil(distance * (double)((Integer)CNAConfig.getClient().wireSectionsPerMeter.get()).intValue());
                Vector3f direction = new Vector3f((Vector3fc)to).normalize();
                Wire wire = new Wire(direction, (float)distance, sections);
                class_4588 consumer = buffer.getBuffer(CNARenderTypes.wire(texture));
                poseStack.method_22903();
                poseStack.method_46416(0.5f, 0.5f, 0.5f);
                poseStack.method_34425(new Matrix4f().rotateTowards((Vector3fc)wire.getDirection(), (Vector3fc)wire.getUp()));
                for (int i = 0; i < wire.getSections().size(); ++i) {
                    Pair<WireSection, Float> pair = wire.getSections().get(i);
                    float sectionOffset = wire.getSectionLength() * (float)i;
                    Vector3f lightPos = blockEntity.method_11016().method_46558().method_46409().add((Vector3fc)wire.getDirection().mul(sectionOffset)).add((Vector3fc)wire.getUp().mul(((Float)pair.getSecond()).floatValue()));
                    class_2338 lightBlockPos = class_2338.method_49638((class_2374)new class_243(lightPos));
                    int block = blockEntity.method_10997().method_8314(class_1944.field_9282, lightBlockPos);
                    int sky = blockEntity.method_10997().method_8314(class_1944.field_9284, lightBlockPos);
                    ((WireSection)pair.getFirst()).render(consumer, poseStack, class_765.method_23687((int)block, (int)sky), ((Float)pair.getSecond()).floatValue());
                    poseStack.method_46416(0.0f, 0.0f, wire.getSectionLength());
                }
                poseStack.method_22909();
            }
        }
    }

    public boolean shouldRenderOffScreen(ElectricalConnectorBlockEntity blockEntity) {
        return true;
    }
}

