/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.alternator;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.EnumMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class AlternatorBlockEntity
extends KineticBlockEntity
implements EnergyTransferable {
    protected final InternalEnergyStorage energy;
    private final EnumMap<class_2350, BlockApiCache<EnergyStorage, class_2350>> escacheMap = new EnumMap(class_2350.class);

    public AlternatorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.energy = new InternalEnergyStorage((Long)Config.ALTERNATOR_CAPACITY.get(), 0L, (Long)Config.ALTERNATOR_MAX_OUTPUT.get());
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        String spacing = " ";
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.production").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43470((String)(" " + Util.format(AlternatorBlockEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "fe/t ")).method_27692(class_124.field_1075)).method_10852((class_2561)CreateLang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).method_27692(class_124.field_1063)));
        return true;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)Config.MAX_STRESS.get()).intValue() / 256.0f;
        return impact;
    }

    @Override
    public EnergyStorage getEnergyStorage(class_2350 side) {
        return this.energy;
    }

    public boolean isEnergyInput(class_2350 side) {
        return false;
    }

    public boolean isEnergyOutput(class_2350 side) {
        return true;
    }

    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(AlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        for (class_2350 d : class_2350.values()) {
            EnergyStorage ies;
            if (!this.isEnergyOutput(d) || (ies = this.getCachedEnergy(d)) == null) continue;
            try (Transaction t = Transaction.openOuter();){
                EnergyStorageUtil.move((EnergyStorage)this.energy, (EnergyStorage)ies, (long)((Long)Config.ALTERNATOR_MAX_OUTPUT.get()), (TransactionContext)t);
                t.commit();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f || !this.isSpeedRequirementFulfilled()) {
            return;
        }
        float pitch = class_3532.method_15363((float)(componentSpeed / 256.0f + 0.5f), (float)0.5f, (float)1.5f);
        if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.DYNAMO, this.field_11867, pitch);
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0) * (Double)Config.ALTERNATOR_EFFICIENCY.get());
    }

    protected class_2248 getStressConfigKey() {
        return (class_2248)CABlocks.ALTERNATOR.get();
    }

    @Nullable
    public EnergyStorage getCachedEnergy(class_2350 side) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        BlockApiCache cache = this.escacheMap.computeIfAbsent(side, side1 -> BlockApiCache.create((BlockApiLookup)EnergyStorage.SIDED, (class_3218)serverLevel, (class_2338)this.method_11016().method_10093(side)));
        return (EnergyStorage)cache.find((Object)side.method_10153());
    }
}

