/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy.network;

import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.network.EnergyNetworkManager;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class EnergyNetwork {
    private int id;
    private long inBuff = 0L;
    private long inDemand = 0L;
    private long outBuff = 0L;
    private long outBuffRetained = 0L;
    private long outDemand = 0L;
    private boolean valid = true;
    private long pulled = 0L;
    private long pushed = 0L;
    private int nodeCount = 0;
    private static final long MAX_BUFF = 80000L;

    public EnergyNetwork(class_1937 world) {
        EnergyNetworkManager.instances.get(world).add(this);
    }

    public long getMaxBuff() {
        return Math.min((long)this.nodeCount * (this.outDemand + this.inDemand * 2L + 10L), 80000L);
    }

    public void tick(int index) {
        this.id = index;
        long t = this.outBuff;
        this.outBuffRetained = this.outBuff = this.inBuff;
        this.inBuff = t;
        this.outDemand = this.inDemand;
        this.inDemand = 0L;
        this.pulled = 0L;
        this.pushed = 0L;
    }

    public long getBuff() {
        return this.outBuffRetained;
    }

    public long push(long energy, boolean simulate) {
        energy = Math.min(this.getMaxBuff() - this.inBuff, energy);
        energy = Math.max(energy, 0L);
        if (!simulate) {
            this.inBuff += energy;
            this.pushed += energy;
        }
        return energy;
    }

    public long push(long energy) {
        return this.push(energy, false);
    }

    public long demand(long demand) {
        this.inDemand += demand;
        return demand;
    }

    public long getDemand() {
        return this.outDemand;
    }

    public long getPulled() {
        return this.pulled;
    }

    public long getPushed() {
        return this.pushed;
    }

    public long pull(long energy, boolean simulate) {
        long r = Math.max(Math.min(energy, this.outBuff), 0L);
        if (!simulate) {
            this.outBuff -= r;
            this.pulled += r;
        }
        return r;
    }

    public long pull(long max) {
        return this.pull(max, false);
    }

    public static EnergyNetwork nextNode(class_1937 level, EnergyNetwork en, Map<String, IWireNode> visited, IWireNode current, int index) {
        if (visited.containsKey(EnergyNetwork.posKey(current.getPos(), index))) {
            return null;
        }
        current.setNetwork(index, en);
        visited.put(EnergyNetwork.posKey(current.getPos(), index), current);
        ++en.nodeCount;
        for (int i = 0; i < current.getNodeCount(); ++i) {
            IWireNode next = current.getWireNode(i);
            if (next == null || !current.isNodeIndeciesConnected(index, i)) continue;
            EnergyNetwork.nextNode(level, en, visited, next, current.getOtherNodeIndex(i));
        }
        return en;
    }

    private static String posKey(class_2338 pos, int index) {
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + ":" + index;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void removed() {
    }

    public int getId() {
        return this.id;
    }
}

