/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class XpPumpUpgradeContainer
extends UpgradeContainerBase<XpPumpUpgradeWrapper, XpPumpUpgradeContainer> {
    private static final String DATA_LEVEL = "level";
    private static final String DATA_DIRECTION = "direction";
    private static final String DATA_ACTION = "action";
    private static final String ACTION_TAKE_LEVELS = "take";
    private static final String ACTION_STORE_LEVELS_FROM_PLAYER = "store";
    private static final String ACTION_STORE_ALL_PLAYERS_EXPERIENCE = "storeAll";
    private static final String ACTION_TAKE_ALL_LEVELS = "takeAll";
    private static final String DATA_LEVELS_TO_STORE = "levelsToStore";
    private static final String DATA_LEVELS_TO_TAKE = "levelsToTake";
    private static final String DATA_MEND_ITEMS = "mendItems";

    public XpPumpUpgradeContainer(class_1657 player, int upgradeContainerId, XpPumpUpgradeWrapper upgradeWrapper, UpgradeContainerType<XpPumpUpgradeWrapper, XpPumpUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
    }

    public void setDirection(AutomationDirection direction) {
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setDirection(direction);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new class_2487(), DATA_DIRECTION, direction));
    }

    public AutomationDirection getDirection() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getDirection();
    }

    public int getLevel() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getLevel();
    }

    public void setLevel(int level) {
        if (level < 0) {
            return;
        }
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setLevel(level);
        this.sendDataToServer(() -> NBTHelper.putInt(new class_2487(), DATA_LEVEL, level));
    }

    public void setLevelsToStore(int levelsToStore) {
        if (levelsToStore < 1) {
            return;
        }
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setLevelsToStore(levelsToStore);
        this.sendDataToServer(() -> NBTHelper.putInt(new class_2487(), DATA_LEVELS_TO_STORE, levelsToStore));
    }

    public void setLevelsToTake(int levelsToTake) {
        if (levelsToTake < 1) {
            return;
        }
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setLevelsToTake(levelsToTake);
        this.sendDataToServer(() -> NBTHelper.putInt(new class_2487(), DATA_LEVELS_TO_TAKE, levelsToTake));
    }

    public void takeLevels() {
        this.triggerAction(ACTION_TAKE_LEVELS);
    }

    public void storeLevels() {
        this.triggerAction(ACTION_STORE_LEVELS_FROM_PLAYER);
    }

    public void storeAllExperience() {
        this.triggerAction(ACTION_STORE_ALL_PLAYERS_EXPERIENCE);
    }

    public void takeAllExperience() {
        this.triggerAction(ACTION_TAKE_ALL_LEVELS);
    }

    private void triggerAction(String actionName) {
        this.sendDataToServer(() -> NBTHelper.putString(new class_2487(), DATA_ACTION, actionName));
    }

    public int getLevelsToStore() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getLevelsToStore();
    }

    public int getLevelsToTake() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getLevelsToTake();
    }

    public void setMendItems(boolean mendItems) {
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setMendItems(mendItems);
        this.sendBooleanToServer(DATA_MEND_ITEMS, mendItems);
    }

    public boolean shouldMendItems() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).shouldMendItems();
    }

    @Override
    public void handleMessage(class_2487 data) {
        if (data.method_10545(DATA_DIRECTION)) {
            this.setDirection(AutomationDirection.fromName(data.method_10558(DATA_DIRECTION)));
        } else if (data.method_10545(DATA_LEVEL)) {
            this.setLevel(data.method_10550(DATA_LEVEL));
        } else if (data.method_10545(DATA_LEVELS_TO_STORE)) {
            this.setLevelsToStore(data.method_10550(DATA_LEVELS_TO_STORE));
        } else if (data.method_10545(DATA_LEVELS_TO_TAKE)) {
            this.setLevelsToTake(data.method_10550(DATA_LEVELS_TO_TAKE));
        } else if (data.method_10545(DATA_MEND_ITEMS)) {
            this.setMendItems(data.method_10577(DATA_MEND_ITEMS));
        } else if (data.method_10545(DATA_ACTION)) {
            switch (data.method_10558(DATA_ACTION)) {
                case "take": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).giveLevelsToPlayer(this.player);
                    break;
                }
                case "store": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).takeLevelsFromPlayer(this.player);
                    break;
                }
                case "takeAll": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).giveAllExperienceToPlayer(this.player);
                    break;
                }
                case "storeAll": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).takeAllExperienceFromPlayer(this.player);
                    break;
                }
            }
        }
    }
}

