/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.data.Lenses;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class LensesDataLoader
extends class_4309 {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "lenses";

    public LensesDataLoader() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<class_2960, JsonElement> content, class_3300 resourceManager, class_3695 profiler) {
        ConcurrentHashMap<class_1856, FocalRange> lenses = new ConcurrentHashMap<class_1856, FocalRange>();
        Exposure.LOGGER.info("Loading exposure lenses:");
        for (Map.Entry<class_2960, JsonElement> entry : content.entrySet()) {
            if (!entry.getKey().method_12836().equals("exposure")) continue;
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                JsonElement item = jsonObject.get("item");
                class_1856 ingredient = class_1856.method_52177((JsonElement)item);
                if (ingredient.method_8103()) {
                    throw new IllegalArgumentException("'item' cannot be empty.");
                }
                JsonElement value = jsonObject.get("focal_range");
                FocalRange focalRange = FocalRange.fromJson(value);
                lenses.put(ingredient, focalRange);
                Exposure.LOGGER.info("Lens [" + String.valueOf(entry.getKey()) + ", " + String.valueOf(focalRange) + "] added.");
            }
            catch (Exception e) {
                Exposure.LOGGER.error(e.toString());
            }
        }
        if (lenses.isEmpty()) {
            Exposure.LOGGER.info("No lenses have been loaded.");
        }
        Lenses.reload(lenses);
    }
}

