/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.transfer;

import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.network.packet.ExposureDataPartPacket;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;

public class ExposureSender
implements IExposureSender {
    public static final int TO_SERVER_PACKET_SPLIT_THRESHOLD = 28000;
    public static final int TO_CLIENT_PACKET_SPLIT_THRESHOLD = 500000;
    private final BiConsumer<ExposureDataPartPacket, @Nullable class_1657> packetSender;
    private final int splitThreshold;

    public ExposureSender(BiConsumer<ExposureDataPartPacket, @Nullable class_1657> packetSender, int splitThreshold) {
        this.packetSender = packetSender;
        this.splitThreshold = splitThreshold;
    }

    @Override
    public void send(String id, ExposureSavedData exposureData) {
        this.sendTo(null, id, exposureData);
    }

    @Override
    public synchronized void sendTo(@Nullable class_1657 player, String id, ExposureSavedData exposureData) {
        byte[][] parts = this.splitToParts(exposureData.getPixels(), this.splitThreshold);
        int offset = 0;
        for (byte[] part : parts) {
            ExposureDataPartPacket packet = new ExposureDataPartPacket(id, exposureData.getWidth(), exposureData.getHeight(), exposureData.getProperties(), offset, part);
            this.packetSender.accept(packet, player);
            offset += this.splitThreshold;
        }
    }

    private byte[][] splitToParts(byte[] input, int partSize) {
        int parts = (int)Math.ceil((double)input.length / (double)partSize);
        byte[][] output = new byte[parts][];
        for (int part = 0; part < parts; ++part) {
            int start = part * partSize;
            int length = Math.min(input.length - start, partSize);
            byte[] bytes = new byte[length];
            System.arraycopy(input, start, bytes, 0, length);
            output[part] = bytes;
        }
        return output;
    }
}

