/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_768;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.compat.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.SettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.StorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

@JeiPlugin
public class StoragePlugin
implements IModPlugin {
    private static Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar = registration -> {};

    public static void setAdditionalCatalystRegistrar(Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar) {
        StoragePlugin.additionalCatalystRegistrar = additionalCatalystRegistrar;
    }

    public class_2960 getPluginUid() {
        return new class_2960("sophisticatedstorage", "default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        IIngredientSubtypeInterpreter chestNbtInterpreter = (itemStack, context) -> {
            StringJoiner result = new StringJoiner(",");
            WoodStorageBlockItem.getWoodType(itemStack).ifPresent(woodName -> result.add("woodName:" + String.valueOf(woodName)));
            StorageBlockItem.getMainColorFromStack(itemStack).ifPresent(mainColor -> result.add("mainColor:" + mainColor));
            StorageBlockItem.getAccentColorFromStack(itemStack).ifPresent(accentColor -> result.add("accentColor:" + accentColor));
            result.add("doubleChest:" + ChestBlockItem.isDoubleChest(itemStack));
            return "{" + String.valueOf(result) + "}";
        };
        IIngredientSubtypeInterpreter barrelNbtInterpreter = (itemStack, context) -> {
            StringJoiner result = new StringJoiner(",");
            WoodStorageBlockItem.getWoodType(itemStack).ifPresent(woodName -> result.add("woodName:" + String.valueOf(woodName)));
            StorageBlockItem.getMainColorFromStack(itemStack).ifPresent(mainColor -> result.add("mainColor:" + mainColor));
            StorageBlockItem.getAccentColorFromStack(itemStack).ifPresent(accentColor -> result.add("accentColor:" + accentColor));
            result.add("flatTop:" + BarrelBlockItem.isFlatTop(itemStack));
            return "{" + String.valueOf(result) + "}";
        };
        for (class_1747 item : ModBlocks.ALL_BARREL_ITEMS) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, barrelNbtInterpreter);
        }
        for (class_1747 item : ModBlocks.CHEST_ITEMS) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, chestNbtInterpreter);
        }
        IIngredientSubtypeInterpreter shulkerBoxNbtInterpreter = (itemStack, context) -> {
            StringJoiner result = new StringJoiner(",");
            StorageBlockItem.getMainColorFromStack(itemStack).ifPresent(mainColor -> result.add("mainColor:" + mainColor));
            StorageBlockItem.getAccentColorFromStack(itemStack).ifPresent(accentColor -> result.add("accentColor:" + accentColor));
            return "{" + String.valueOf(result) + "}";
        };
        for (class_1747 item : ModBlocks.SHULKER_BOX_ITEMS) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, shulkerBoxNbtInterpreter);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(StorageScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageScreen>(){

            public List<class_768> getGuiExtraAreas(StorageScreen gui) {
                ArrayList<class_768> ret = new ArrayList<class_768>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                return ret;
            }
        });
        registration.addGuiContainerHandler(StorageSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageSettingsScreen>(){

            public List<class_768> getGuiExtraAreas(StorageSettingsScreen gui) {
                return new ArrayList<class_768>(gui.getSettingsTabControl().getTabRectangles());
            }
        });
        registration.addGhostIngredientHandler(StorageScreen.class, (IGhostIngredientHandler)new StorageGhostIngredientHandler());
        registration.addGhostIngredientHandler(SettingsScreen.class, (IGhostIngredientHandler)new SettingsGhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, DyeRecipesMaker.getRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, TierUpgradeRecipesMaker.getShapedCraftingRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, TierUpgradeRecipesMaker.getShapelessCraftingRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, ClientRecipeHelper.getAndTransformAvailableRecipes(ShulkerBoxFromVanillaShapelessRecipe.REGISTERED_RECIPES, ShulkerBoxFromVanillaShapelessRecipe.class, ClientRecipeHelper::copyShapelessRecipe));
        registration.addRecipes(RecipeTypes.CRAFTING, ShulkerBoxFromChestRecipesMaker.getRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, FlatBarrelRecipesMaker.getRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new class_1799((class_1935)ModItems.CRAFTING_UPGRADE), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new class_1799((class_1935)ModItems.STONECUTTER_UPGRADE), new RecipeType[]{RecipeTypes.STONECUTTING});
        additionalCatalystRegistrar.accept(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingContainerRecipeTransferHandlerBase<StorageContainerMenu, class_3955>(handlerHelper, stackHelper){

            public Class<StorageContainerMenu> getContainerClass() {
                return StorageContainerMenu.class;
            }

            public RecipeType<class_3955> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }
        }, RecipeTypes.CRAFTING);
    }
}

