/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Commands;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.CustomSound;
import de.maxhenkel.audioplayer.FileNameManager;
import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7430;
import org.jetbrains.annotations.Nullable;

@Command(value={"audioplayer"})
public class ApplyCommands {
    @RequiresPermission(value="audioplayer.apply")
    @Command(value={"apply"})
    public void apply(CommandContext<class_2168> context, @Name(value="file_name") String fileName, @OptionalArgument @Name(value="range") @Min(value="1") Float range, @OptionalArgument @Name(value="custom_name") String customName) throws CommandSyntaxException {
        UUID id = ApplyCommands.getId(context, fileName);
        if (id == null) {
            return;
        }
        ApplyCommands.apply(context, new CustomSound(id, range, false), customName);
    }

    @RequiresPermission(value="audioplayer.apply")
    @Command(value={"apply"})
    public void apply(CommandContext<class_2168> context, @Name(value="file_name") String fileName, @OptionalArgument @Name(value="custom_name") String customName) throws CommandSyntaxException {
        UUID id = ApplyCommands.getId(context, fileName);
        if (id == null) {
            return;
        }
        ApplyCommands.apply(context, new CustomSound(id, null, false), customName);
    }

    @RequiresPermission(value="audioplayer.apply")
    @Commands(value={@Command(value={"apply"}), @Command(value={"musicdisc"}), @Command(value={"goathorn"})})
    public void apply(CommandContext<class_2168> context, @Name(value="sound_id") UUID sound, @OptionalArgument @Name(value="range") @Min(value="1") Float range, @OptionalArgument @Name(value="custom_name") String customName) throws CommandSyntaxException {
        ApplyCommands.apply(context, new CustomSound(sound, range, false), customName);
    }

    @RequiresPermission(value="audioplayer.apply")
    @Commands(value={@Command(value={"apply"}), @Command(value={"musicdisc"}), @Command(value={"goathorn"})})
    public void apply(CommandContext<class_2168> context, @Name(value="sound_id") UUID sound, @OptionalArgument @Name(value="custom_name") String customName) throws CommandSyntaxException {
        ApplyCommands.apply(context, new CustomSound(sound, null, false), customName);
    }

    @Nullable
    private static UUID getId(CommandContext<class_2168> context, String fileName) {
        try {
            return UUID.fromString(fileName);
        }
        catch (Exception exception) {
            Optional<FileNameManager> optionalFileNameManager = FileNameManager.instance();
            if (optionalFileNameManager.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"An internal error occurred"));
                return null;
            }
            FileNameManager fileNameManager = optionalFileNameManager.get();
            UUID audioId = fileNameManager.getAudioId(fileName);
            if (audioId == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No audio with name '%s' found or more than one found".formatted(fileName)));
                return null;
            }
            return audioId;
        }
    }

    private static void apply(CommandContext<class_2168> context, CustomSound sound, @Nullable String customName) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        if (ApplyCommands.isShulkerBox(itemInHand)) {
            ApplyCommands.applyShulker(context, sound, customName);
            return;
        }
        PlayerType type = PlayerType.fromItemStack(itemInHand);
        if (type == null) {
            ApplyCommands.sendInvalidHandItemMessage(context, itemInHand);
            return;
        }
        ApplyCommands.apply(context, itemInHand, type, sound, customName);
    }

    @RequiresPermission(value="audioplayer.set_static")
    @Command(value={"setstatic"})
    public void setStatic(CommandContext<class_2168> context, @Name(value="enabled") Optional<Boolean> enabled) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ApplyCommands.sendInvalidHandItemMessage(context, itemInHand);
            return;
        }
        CustomSound customSound = CustomSound.of(itemInHand);
        if (customSound == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This item does not have custom audio"));
            return;
        }
        CustomSound newSound = customSound.asStatic(enabled.orElse(true));
        newSound.saveToItemIgnoreLore(itemInHand);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)((enabled.orElse(true) != false ? "Enabled" : "Disabled") + " static audio")), false);
    }

    private static void applyShulker(CommandContext<class_2168> context, CustomSound sound, @Nullable String customName) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        if (ApplyCommands.isShulkerBox(itemInHand)) {
            ApplyCommands.processShulker(context, itemInHand, sound, customName);
            return;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have a shulker box in your main hand"));
    }

    private static void processShulker(CommandContext<class_2168> context, class_1799 shulkerItem, CustomSound sound, @Nullable String customName) throws CommandSyntaxException {
        class_2499 shulkerContents = shulkerItem.method_7911("BlockEntityTag").method_10554("Items", 10);
        for (int i = 0; i < shulkerContents.size(); ++i) {
            class_2487 currentItem = shulkerContents.method_10602(i);
            class_1799 itemStack = class_1799.method_7915((class_2487)currentItem);
            PlayerType playerType = PlayerType.fromItemStack(itemStack);
            if (playerType == null) continue;
            ApplyCommands.apply(context, itemStack, playerType, sound, customName);
            currentItem.method_10566("tag", (class_2520)itemStack.method_7948());
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully updated contents"), false);
    }

    private static void apply(CommandContext<class_2168> context, class_1799 stack, PlayerType type, CustomSound customSound, @Nullable String customName) throws CommandSyntaxException {
        ApplyCommands.checkRange(type.getMaxRange(), customSound.getRange().orElse(null));
        if (!type.isValid(stack)) {
            return;
        }
        customSound.saveToItem(stack, customName);
        class_2487 tag = stack.method_7948();
        if (stack.method_7909() instanceof class_7430) {
            tag.method_10582("instrument", "");
        } else {
            tag.method_10551("instrument");
        }
        if (stack.method_7909() instanceof class_1747) {
            class_2487 blockEntityTag = stack.method_7911("BlockEntityTag");
            customSound.saveToNbt(blockEntityTag);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully updated ").method_10852(stack.method_7964()), false);
    }

    private static void checkRange(ConfigEntry<Float> maxRange, @Nullable Float range) throws CommandSyntaxException {
        if (range == null) {
            return;
        }
        if (range.floatValue() > maxRange.get().floatValue()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.floatTooHigh().create((Object)range, (Object)maxRange.get());
        }
    }

    public static boolean isShulkerBox(class_1799 stack) {
        class_1747 blockitem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1747 && (blockitem = (class_1747)class_17922).method_7711() instanceof class_2480;
    }

    private static void sendInvalidHandItemMessage(CommandContext<class_2168> context, class_1799 invalidItem) {
        if (invalidItem.method_7960()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have an item in your main hand"));
            return;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"The item in your main hand can not have custom audio"));
    }
}

