/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.client.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicPromptScreen;
import com.simibubi.create.content.schematics.packet.InstantSchematicPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.CreatePaths;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import me.pepperbell.simplenetworking.C2SPacket;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class SchematicAndQuillHandler {
    private Object outlineSlot = new Object();
    public class_2338 firstPos;
    public class_2338 secondPos;
    private class_2338 selectedPos;
    private class_2350 selectedFace;
    private int range = 10;

    public boolean mouseScrolled(double delta) {
        if (!this.isActive()) {
            return false;
        }
        if (!AllKeys.ctrlDown()) {
            return false;
        }
        if (this.secondPos == null) {
            this.range = (int)class_3532.method_15350((double)((double)this.range + delta), (double)1.0, (double)100.0);
        }
        if (this.selectedFace == null) {
            return true;
        }
        class_238 bb = new class_238(this.firstPos, this.secondPos);
        class_2382 vec = this.selectedFace.method_10163();
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        if (bb.method_1006(projectedView)) {
            delta *= -1.0;
        }
        int intDelta = (int)(delta > 0.0 ? Math.ceil(delta) : Math.floor(delta));
        int x = vec.method_10263() * intDelta;
        int y = vec.method_10264() * intDelta;
        int z = vec.method_10260() * intDelta;
        class_2350.class_2352 axisDirection = this.selectedFace.method_10171();
        if (axisDirection == class_2350.class_2352.field_11060) {
            bb = bb.method_989((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.field_1320 - (double)(x * axisDirection.method_10181()), bb.field_1323);
        double maxY = Math.max(bb.field_1325 - (double)(y * axisDirection.method_10181()), bb.field_1322);
        double maxZ = Math.max(bb.field_1324 - (double)(z * axisDirection.method_10181()), bb.field_1321);
        bb = new class_238(bb.field_1323, bb.field_1322, bb.field_1321, maxX, maxY, maxZ);
        this.firstPos = class_2338.method_49637((double)bb.field_1323, (double)bb.field_1322, (double)bb.field_1321);
        this.secondPos = class_2338.method_49637((double)bb.field_1320, (double)bb.field_1325, (double)bb.field_1324);
        class_746 player = class_310.method_1551().field_1724;
        CreateLang.translate("schematicAndQuill.dimensions", (int)bb.method_17939() + 1, (int)bb.method_17940() + 1, (int)bb.method_17941() + 1).sendStatus((class_1657)player);
        return true;
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!pressed || button != 1) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player.method_5715()) {
            this.discard();
            return true;
        }
        if (this.secondPos != null) {
            ScreenOpener.open((class_437)new SchematicPromptScreen());
            return true;
        }
        if (this.selectedPos == null) {
            CreateLang.translate("schematicAndQuill.noTarget", new Object[0]).sendStatus((class_1657)player);
            return true;
        }
        if (this.firstPos != null) {
            this.secondPos = this.selectedPos;
            CreateLang.translate("schematicAndQuill.secondPos", new Object[0]).sendStatus((class_1657)player);
            return true;
        }
        this.firstPos = this.selectedPos;
        CreateLang.translate("schematicAndQuill.firstPos", new Object[0]).sendStatus((class_1657)player);
        return true;
    }

    public void discard() {
        class_746 player = class_310.method_1551().field_1724;
        this.firstPos = null;
        this.secondPos = null;
        CreateLang.translate("schematicAndQuill.abort", new Object[0]).sendStatus((class_1657)player);
    }

    public void tick() {
        class_238 currentSelectionBox;
        if (!this.isActive()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (AllKeys.ACTIVATE_TOOL.isPressed()) {
            float pt = AnimationTickHolder.getPartialTicks();
            class_243 targetVec = player.method_5836(pt).method_1019(player.method_5720().method_1021((double)this.range));
            this.selectedPos = class_2338.method_49638((class_2374)targetVec);
        } else {
            class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), (class_1657)player, 75.0);
            if (trace != null && trace.method_17783() == class_239.class_240.field_1332) {
                class_2338 hit = trace.method_17777();
                boolean replaceable = player.method_37908().method_8320(hit).method_26166(new class_1750(new class_1838((class_1657)player, class_1268.field_5808, trace)));
                if (trace.method_17780().method_10166().method_10178() && !replaceable) {
                    hit = hit.method_10093(trace.method_17780());
                }
                this.selectedPos = hit;
            } else {
                this.selectedPos = null;
            }
        }
        this.selectedFace = null;
        if (this.secondPos != null) {
            class_243 projectedView;
            class_238 bb = new class_238(this.firstPos, this.secondPos).method_1012(1.0, 1.0, 1.0).method_1014((double)0.45f);
            boolean inside = bb.method_1006(projectedView = class_310.method_1551().field_1773.method_19418().method_19326());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((class_1657)player, 70.0, pos -> inside ^ bb.method_1006(VecHelper.getCenterOf((class_2382)pos)));
            class_2350 class_23502 = result.missed() ? null : (this.selectedFace = inside ? result.getFacing().method_10153() : result.getFacing());
        }
        if ((currentSelectionBox = this.getCurrentSelectionBox()) != null) {
            this.outliner().chaseAABB(this.outlineSlot, currentSelectionBox).colored(6850245).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).highlightFace(this.selectedFace);
        }
    }

    private class_238 getCurrentSelectionBox() {
        if (this.secondPos == null) {
            if (this.firstPos == null) {
                return this.selectedPos == null ? null : new class_238(this.selectedPos);
            }
            return this.selectedPos == null ? new class_238(this.firstPos) : new class_238(this.firstPos, this.selectedPos).method_1012(1.0, 1.0, 1.0);
        }
        return new class_238(this.firstPos, this.secondPos).method_1012(1.0, 1.0, 1.0);
    }

    private boolean isActive() {
        return this.isPresent() && AllItems.SCHEMATIC_AND_QUILL.isIn(class_310.method_1551().field_1724.method_6047());
    }

    private boolean isPresent() {
        return class_310.method_1551() != null && class_310.method_1551().field_1687 != null && class_310.method_1551().field_1755 == null;
    }

    public void saveSchematic(String string, boolean convertImmediately) {
        SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(CreatePaths.SCHEMATICS_DIR, string, false, (class_1937)class_310.method_1551().field_1687, this.firstPos, this.secondPos);
        class_746 player = class_310.method_1551().field_1724;
        if (result == null) {
            CreateLang.translate("schematicAndQuill.failed", new Object[0]).style(class_124.field_1061).sendStatus((class_1657)player);
            return;
        }
        Path file = result.file();
        CreateLang.translate("schematicAndQuill.saved", file.getFileName()).sendStatus((class_1657)player);
        this.firstPos = null;
        this.secondPos = null;
        if (!convertImmediately) {
            return;
        }
        try {
            if (!ClientSchematicLoader.validateSizeLimitation(Files.size(file))) {
                return;
            }
            AllPackets.getChannel().sendToServer((C2SPacket)new InstantSchematicPacket(result.fileName(), result.origin(), result.bounds()));
        }
        catch (IOException e) {
            Create.LOGGER.error("Error instantly uploading Schematic file: " + String.valueOf(file), (Throwable)e);
        }
    }

    private Outliner outliner() {
        return Outliner.getInstance();
    }
}

