/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalPackagePort;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class DeliverPackagesInstruction
extends ScheduleInstruction {
    @Override
    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)this.getSecondLineIcon(), (Object)CreateLang.translateDirect("schedule.instruction.package_delivery", new Object[0]));
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return AllBlocks.PACKAGE_POSTBOXES.get(class_1767.field_7952).asStack();
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translate("schedule.instruction.package_delivery.summary", new Object[0]).style(class_124.field_1065).component(), (Object)CreateLang.translateDirect("schedule.instruction.package_delivery.summary_1", new Object[0]).method_27692(class_124.field_1080), (Object)CreateLang.translateDirect("schedule.instruction.package_delivery.summary_2", new Object[0]).method_27692(class_124.field_1080));
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("package_delivery");
    }

    @Override
    public boolean supportsConditions() {
        return true;
    }

    @Override
    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, class_1937 level) {
        boolean anyMatch = false;
        String firstPackage = null;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = runtime.train;
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            runtime.startCooldown();
            return null;
        }
        for (Carriage carriage : train.carriages) {
            CombinedSlottedStorage<ItemVariant, ? extends SlottedStorage<ItemVariant>> carriageInventory = carriage.storage.getAllItems();
            if (carriageInventory == null) continue;
            for (StorageView view : carriageInventory.nonEmptyViews()) {
                ItemVariant resource = (ItemVariant)view.getResource();
                if (!PackageItem.isPackage(resource)) continue;
                if (firstPackage == null) {
                    firstPackage = PackageItem.getAddress(resource);
                }
                block2: for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
                    for (Map.Entry<class_2338, GlobalPackagePort> port : globalStation.connectedPorts.entrySet()) {
                        if (!PackageItem.matchAddress(resource, port.getValue().address)) continue;
                        anyMatch = true;
                        validStations.add(globalStation);
                        continue block2;
                    }
                }
            }
        }
        if (validStations.isEmpty()) {
            if (firstPackage != null) {
                train.status.failedPackageNoTarget(firstPackage);
                runtime.startCooldown();
            } else {
                runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ++runtime.currentEntry;
            }
            return null;
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            }
            runtime.startCooldown();
            return null;
        }
        return best;
    }
}

