/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.pneumono.gravestones.api.GravestoneDataType;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.StackWithSlot;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class PlayerInventoryDataType
extends GravestoneDataType {
    private static final String KEY = "inventory";

    @Override
    public void writeData(class_2487 nbt, DynamicOps<class_2520> ops, class_1657 player) {
        class_2499 list = new class_2499();
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            class_2960 slotIdentifier = class_2960.method_43902((String)"minecraft", (String)Integer.toString(i));
            GravestonesApi.onInsertItem(player, itemStack, slotIdentifier);
            if (GravestonesApi.shouldSkipItem(player, itemStack, slotIdentifier) || itemStack.method_7960()) continue;
            DataResult result = StackWithSlot.CODEC.encodeStart(ops, (Object)new StackWithSlot(i, inventory.method_5441(i)));
            list.add((Object)((class_2520)result.result().orElseThrow()));
        }
        nbt.method_10566(KEY, (class_2520)list);
    }

    @Override
    public void onBreak(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, int decay) {
        class_2499 list = VersionUtil.getCompoundListOrEmpty(nbt, KEY);
        for (class_2520 element : list) {
            class_1799 stack = ((StackWithSlot)((Pair)StackWithSlot.CODEC.decode(ops, (Object)element).result().orElseThrow()).getFirst()).stack();
            this.dropStack(world, pos, stack);
        }
    }

    @Override
    public void onCollect(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, class_1657 player, int decay) {
        class_1661 inventory = player.method_31548();
        class_2499 list = VersionUtil.getCompoundListOrEmpty(nbt, KEY);
        ArrayList<StackWithSlot> stacks = new ArrayList<StackWithSlot>();
        for (class_2520 element : list) {
            stacks.add((StackWithSlot)((Pair)StackWithSlot.CODEC.decode(ops, (Object)element).result().orElseThrow()).getFirst());
        }
        ArrayList<class_1799> remainingStacks = new ArrayList<class_1799>();
        for (StackWithSlot stackWithSlot : stacks) {
            int slot = stackWithSlot.slot();
            if (stackWithSlot.isValidSlot(inventory.method_5439())) {
                class_1799 stack = stackWithSlot.stack();
                if (stack.method_7960()) continue;
                if (inventory.method_5438(slot).method_7960()) {
                    inventory.method_5447(slot, stack);
                    continue;
                }
            }
            remainingStacks.add(stackWithSlot.stack());
        }
        this.dropStacks(player, remainingStacks);
    }
}

