/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.config.BooleanSettingEntry;
import dev.lambdaurora.lambdynlights.config.SettingEntry;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.CommentedConfig;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.ParsingException;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.ParsingMode;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.toml.TomlParser;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.toml.TomlWriter;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLightsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|Config");
    private static final DynamicLightsMode DEFAULT_DYNAMIC_LIGHTS_MODE = DynamicLightsMode.FANCY;
    private static final boolean DEFAULT_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_SELF_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_WATER_SENSITIVE_CHECK = true;
    private static final ExplosiveLightingMode DEFAULT_CREEPER_LIGHTING_MODE = ExplosiveLightingMode.SIMPLE;
    private static final ExplosiveLightingMode DEFAULT_TNT_LIGHTING_MODE = ExplosiveLightingMode.OFF;
    private static final int DEFAULT_DEBUG_CELL_DISPLAY_RADIUS = 0;
    private static final int DEFAULT_DEBUG_LIGHT_LEVEL_RADIUS = 0;
    private static final Executor SAVE_EXECUTOR = Executors.newSingleThreadExecutor();
    public static final Path CONFIG_FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("lambdynlights.toml").normalize();
    private final CommentedConfig config;
    private final LambDynLights mod;
    private DynamicLightsMode dynamicLightsMode;
    private final List<SettingEntry<?>> settingEntries;
    private final BooleanSettingEntry entitiesLightSource;
    private final BooleanSettingEntry selfLightSource;
    private final BooleanSettingEntry waterSensitiveCheck;
    private final BooleanSettingEntry beamLighting;
    private final BooleanSettingEntry guardianLaser;
    private final BooleanSettingEntry sonicBoomLighting;
    private final BooleanSettingEntry glowingEffectLighting;
    private final BooleanSettingEntry debugActiveDynamicLightingCells;
    private final BooleanSettingEntry debugDisplayDynamicLightingChunkRebuild;
    private final BooleanSettingEntry debugDisplayHandlerBoundingBox;
    private ExplosiveLightingMode creeperLightingMode;
    private ExplosiveLightingMode tntLightingMode;
    private int debugCellDisplayRadius;
    private int debugLightLevelRadius;
    private int lastHash;
    public final SpruceOption dynamicLightsModeOption = new SpruceCyclingOption("lambdynlights.option.mode", amount -> this.setDynamicLightsMode(this.dynamicLightsMode.next()), option -> option.getDisplayText(this.dynamicLightsMode.getTranslatedText()), (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.mode.1").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.mode.2", (Object[])new Object[]{DynamicLightsMode.FASTEST.getTranslatedText(), DynamicLightsMode.FAST.getTranslatedText()})).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.mode.3", (Object[])new Object[]{DynamicLightsMode.FANCY.getTranslatedText()})));

    public DynamicLightsConfig(@NotNull LambDynLights mod) {
        this.mod = mod;
        this.config = CommentedConfig.inMemory();
        this.entitiesLightSource = new BooleanSettingEntry("light_sources.entities", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.entities"));
        this.selfLightSource = new BooleanSettingEntry("light_sources.self", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.self_light_source")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeLightSources(source -> {
                    class_746 player;
                    return source instanceof class_746 && (player = (class_746)source) == class_310.method_1551().field_1724;
                });
            }
        });
        this.waterSensitiveCheck = new BooleanSettingEntry("light_sources.water_sensitive_check", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.water_sensitive"));
        this.beamLighting = new BooleanSettingEntry("light_sources.beam", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.light_sources.beam.tooltip"));
        this.guardianLaser = new BooleanSettingEntry("light_sources.guardian_laser", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.light_sources.guardian_laser.tooltip"));
        this.sonicBoomLighting = new BooleanSettingEntry("light_sources.sonic_boom", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.light_sources.sonic_boom.tooltip"));
        this.glowingEffectLighting = new BooleanSettingEntry("light_sources.glowing_effect", true, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.light_sources.glowing_effect.tooltip"));
        this.debugActiveDynamicLightingCells = new BooleanSettingEntry("debug.active_dynamic_lighting_cells", false, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.debug.active_dynamic_lighting_cells.tooltip"));
        this.debugDisplayDynamicLightingChunkRebuild = new BooleanSettingEntry("debug.display_dynamic_lighting_chunk_rebuild", false, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.debug.display_dynamic_lighting_chunk_rebuild.tooltip"));
        this.debugDisplayHandlerBoundingBox = new BooleanSettingEntry("debug.display_behavior_bounding_box", false, this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.option.debug.display_behavior_bounding_box.tooltip"));
        this.settingEntries = List.of(this.entitiesLightSource, this.selfLightSource, this.waterSensitiveCheck, this.beamLighting, this.guardianLaser, this.sonicBoomLighting, this.debugActiveDynamicLightingCells, this.debugDisplayDynamicLightingChunkRebuild, this.debugDisplayHandlerBoundingBox);
    }

    public void load() {
        try {
            this.loadFromFile(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String dynamicLightsModeValue = this.config.getOrElse("mode", DEFAULT_DYNAMIC_LIGHTS_MODE.getName());
        this.dynamicLightsMode = DynamicLightsMode.byId(dynamicLightsModeValue).orElse(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.settingEntries.forEach(entry -> entry.load(this.config));
        this.creeperLightingMode = ExplosiveLightingMode.byId(this.config.getOrElse("light_sources.creeper", DEFAULT_CREEPER_LIGHTING_MODE.getName())).orElse(DEFAULT_CREEPER_LIGHTING_MODE);
        this.tntLightingMode = ExplosiveLightingMode.byId(this.config.getOrElse("light_sources.tnt", DEFAULT_TNT_LIGHTING_MODE.getName())).orElse(DEFAULT_TNT_LIGHTING_MODE);
        this.debugCellDisplayRadius = this.config.getOrElse("debug.cell_display_radius", Integer.valueOf(0));
        this.debugLightLevelRadius = this.config.getOrElse("debug.light_level_radius", Integer.valueOf(0));
        this.lastHash = this.serialize().hashCode();
        LambDynLights.log(LOGGER, "Configuration loaded.");
    }

    private void loadFromFile(boolean firstAttempt) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE_PATH);){
            new TomlParser().parse(reader, (Config)this.config, ParsingMode.REPLACE);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            if (!firstAttempt) {
                throw e;
            }
            this.copyDefaultFile();
            this.loadFromFile(false);
        }
        catch (ParsingException e) {
            if (!firstAttempt) {
                throw e;
            }
            Path backupPath = CONFIG_FILE_PATH.resolveSibling("lambdynlights.toml.old").toAbsolutePath().normalize();
            LambDynLights.error(LOGGER, "Failed to parse configuration file, THIS IS BAD.", e);
            LambDynLights.error(LOGGER, "Copying the corrupt file to \"{}\".", backupPath);
            Files.copy(CONFIG_FILE_PATH, backupPath, StandardCopyOption.REPLACE_EXISTING);
            this.copyDefaultFile();
            this.loadFromFile(false);
        }
    }

    private void copyDefaultFile() throws IOException {
        Files.createDirectories(CONFIG_FILE_PATH.getParent(), new FileAttribute[0]);
        try (InputStream defaultStream = DynamicLightsConfig.class.getResourceAsStream("/lambdynlights.toml");){
            Files.copy(Objects.requireNonNull(defaultStream, "This distribution of LambDynamicLights is broken: cannot find the default configuration file inside of the mod's JAR."), CONFIG_FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
            LambDynLights.log(LOGGER, "Copied default configuration file.");
        }
    }

    public void load(SettingEntry<?> settingEntry) {
        settingEntry.load(this.config);
    }

    public void save() {
        this.maybeSerialize().ifPresent(data -> SAVE_EXECUTOR.execute(() -> this.doSave((String)data)));
    }

    @NotNull
    private String serialize() {
        return new TomlWriter().writeToString(this.config);
    }

    @NotNull
    private Optional<String> maybeSerialize() {
        String data = this.serialize();
        int hash = data.hashCode();
        if (this.lastHash != hash) {
            this.lastHash = hash;
            return Optional.of(data);
        }
        return Optional.empty();
    }

    private void doSave(String data) {
        try {
            Files.createDirectories(CONFIG_FILE_PATH.getParent(), new FileAttribute[0]);
            Path tmpPath = CONFIG_FILE_PATH.resolveSibling(CONFIG_FILE_PATH.getFileName().toString() + ".tmp");
            Files.writeString(tmpPath, (CharSequence)data, new OpenOption[0]);
            Files.move(tmpPath, CONFIG_FILE_PATH, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LambDynLights.error(LOGGER, "Failed to save configuration file.", e);
            return;
        }
        LambDynLights.log(LOGGER, "Configuration saved.");
    }

    public void reset() {
        this.setDynamicLightsMode(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.settingEntries.forEach(SettingEntry::reset);
        this.setCreeperLightingMode(DEFAULT_CREEPER_LIGHTING_MODE);
        this.setTntLightingMode(DEFAULT_TNT_LIGHTING_MODE);
        this.setDebugCellDisplayRadius(0);
        this.setDebugLightLevelRadius(0);
    }

    public DynamicLightsMode getDynamicLightsMode() {
        return this.dynamicLightsMode;
    }

    public void setDynamicLightsMode(@NotNull DynamicLightsMode mode) {
        if (this.dynamicLightsMode.isEnabled() != mode.isEnabled()) {
            this.mod.shouldForceRefresh = true;
        }
        this.dynamicLightsMode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public BooleanSettingEntry getEntitiesLightSource() {
        return this.entitiesLightSource;
    }

    public BooleanSettingEntry getSelfLightSource() {
        return this.selfLightSource;
    }

    public BooleanSettingEntry getWaterSensitiveCheck() {
        return this.waterSensitiveCheck;
    }

    public ExplosiveLightingMode getCreeperLightingMode() {
        return this.creeperLightingMode;
    }

    public void setCreeperLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.creeperLightingMode = lightingMode;
        this.config.set("light_sources.creeper", (Object)lightingMode.getName());
    }

    public ExplosiveLightingMode getTntLightingMode() {
        return this.tntLightingMode;
    }

    public void setTntLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.tntLightingMode = lightingMode;
        this.config.set("light_sources.tnt", (Object)lightingMode.getName());
    }

    public BooleanSettingEntry getBeamLighting() {
        return this.beamLighting;
    }

    public BooleanSettingEntry getGuardianLaser() {
        return this.guardianLaser;
    }

    public BooleanSettingEntry getSonicBoomLighting() {
        return this.sonicBoomLighting;
    }

    public BooleanSettingEntry getGlowingEffectLighting() {
        return this.glowingEffectLighting;
    }

    public BooleanSettingEntry getDebugActiveDynamicLightingCells() {
        return this.debugActiveDynamicLightingCells;
    }

    public int getDebugCellDisplayRadius() {
        return this.debugCellDisplayRadius;
    }

    public void setDebugCellDisplayRadius(int debugCellDisplayRadius) {
        this.debugCellDisplayRadius = debugCellDisplayRadius;
        this.config.set("debug.cell_display_radius", (Object)debugCellDisplayRadius);
    }

    public BooleanSettingEntry getDebugDisplayDynamicLightingChunkRebuilds() {
        return this.debugDisplayDynamicLightingChunkRebuild;
    }

    public BooleanSettingEntry getDebugDisplayHandlerBoundingBox() {
        return this.debugDisplayHandlerBoundingBox;
    }

    public int getDebugLightLevelRadius() {
        return this.debugLightLevelRadius;
    }

    public void setDebugLightLevelRadius(int debugLightLevelRadius) {
        this.debugLightLevelRadius = debugLightLevelRadius;
        this.config.set("debug.light_level_radius", (Object)this.debugCellDisplayRadius);
    }
}

