/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.menu.ServerInputState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComputerMenu
extends class_1703
implements ComputerMenu {
    public static final int SIDEBAR_WIDTH = 17;
    private final int uploadMaxSize;
    private final Predicate<class_1657> canUse;
    private final ComputerFamily family;
    private final class_3913 data;
    private final @Nullable ServerComputer computer;
    private final @Nullable ServerInputState input;
    private final @Nullable NetworkedTerminal terminal;
    private final class_1799 displayStack;

    public AbstractComputerMenu(class_3917<? extends AbstractComputerMenu> type, int id, Predicate<class_1657> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData containerData) {
        super(type, id);
        this.canUse = canUse;
        this.family = family;
        this.data = computer == null ? new class_3919(1) : () -> computer.isOn() ? 1 : 0;
        this.method_17360(this.data);
        this.computer = computer;
        this.input = computer == null ? null : new ServerInputState(this, computer);
        this.terminal = containerData == null ? null : containerData.terminal().create();
        this.displayStack = containerData == null ? class_1799.field_8037 : containerData.displayStack();
        this.uploadMaxSize = containerData == null ? Config.uploadMaxSize : containerData.uploadMaxSize();
    }

    public boolean method_7597(class_1657 player) {
        return (this.computer == null || this.computer.checkUsable(player)) && this.canUse.test(player);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public boolean isOn() {
        return this.data.method_17390(0) != 0;
    }

    public int getUploadMaxSize() {
        return this.uploadMaxSize;
    }

    @Override
    public ServerComputer getComputer() {
        if (this.computer == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.computer;
    }

    @Override
    public ServerInputHandler getInput() {
        if (this.input == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.input;
    }

    @Override
    public void updateTerminal(TerminalState state) {
        if (this.terminal == null) {
            throw new UnsupportedOperationException("Cannot update terminal on the server");
        }
        state.apply(this.terminal);
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Cannot update terminal on the server");
        }
        return this.terminal;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.input != null) {
            this.input.close();
        }
    }

    public class_1799 getDisplayStack() {
        return this.displayStack;
    }
}

