/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class MountingHelper {
    protected final ComponentSink sink;
    protected final List<Component> lateChildren;
    protected final Size childSpace;

    protected MountingHelper(ComponentSink sink, List<Component> children, Size childSpace) {
        this.sink = sink;
        this.lateChildren = children;
        this.childSpace = childSpace;
    }

    public static MountingHelper mountEarly(ComponentSink sink, List<Component> children, Size childSpace, Consumer<Component> layoutFunc) {
        ArrayList<Component> lateChildren = new ArrayList<Component>();
        for (Component child : children) {
            if (!((Positioning)child.positioning().get()).isRelative()) {
                sink.accept(child, childSpace, layoutFunc);
                continue;
            }
            lateChildren.add(child);
        }
        return new MountingHelper(sink, lateChildren, childSpace);
    }

    public void mountLate() {
        for (Component child : this.lateChildren) {
            this.sink.accept(child, this.childSpace, component -> {
                throw new IllegalStateException("A layout-positioned child was mounted late");
            });
        }
        this.lateChildren.clear();
    }

    public static interface ComponentSink {
        public void accept(@Nullable Component var1, Size var2, Consumer<Component> var3);
    }
}

