/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.betterx.bclib.blockentities.BaseChestBlockEntity;
import org.betterx.bclib.client.models.BaseChestBlockModel;

@Environment(value=EnvType.CLIENT)
public class BaseChestBlockEntityRenderer
implements class_827<BaseChestBlockEntity> {
    private static final HashMap<class_2248, class_1921[]> LAYERS = Maps.newHashMap();
    private static final class_1921[] RENDER_TYPES = new class_1921[]{class_1921.method_23576((class_2960)new class_2960("textures/entity/chest/normal.png")), class_1921.method_23576((class_2960)new class_2960("textures/entity/chest/normal_left.png")), class_1921.method_23576((class_2960)new class_2960("textures/entity/chest/normal_right.png"))};
    private static final int ID_NORMAL = 0;
    private static final int ID_LEFT = 1;
    private static final int ID_RIGHT = 2;
    private final BaseChestBlockModel chestModel = new BaseChestBlockModel(BaseChestBlockModel.getTexturedModelData().method_32109());

    public BaseChestBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public void render(BaseChestBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        boolean worldExists = world != null;
        class_2680 blockState = worldExists ? entity.method_11010() : (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2745 chestType = blockState.method_28498((class_2769)class_2281.field_10770) ? (class_2745)blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        class_2248 block = blockState.method_26204();
        if (block instanceof class_4739) {
            class_4739 abstractChestBlock = (class_4739)block;
            boolean isDouble = chestType != class_2745.field_12569;
            float f = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-f));
            matrices.method_22904(-0.5, -0.5, -0.5);
            class_4732.class_4734 propertySource = worldExists ? abstractChestBlock.method_24167(blockState, world, entity.method_11016(), true) : class_4732.class_3923::method_24174;
            float pitch = ((Float2FloatFunction)propertySource.apply(class_2281.method_24166((class_2618)entity))).get(tickDelta);
            pitch = 1.0f - pitch;
            pitch = 1.0f - pitch * pitch * pitch;
            int blockLight = ((Int2IntFunction)propertySource.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            class_4588 vertexConsumer = BaseChestBlockEntityRenderer.getConsumer(vertexConsumers, block, chestType);
            if (isDouble) {
                if (chestType == class_2745.field_12574) {
                    this.renderParts(matrices, vertexConsumer, this.chestModel.partLeftA, this.chestModel.partLeftB, this.chestModel.partLeftC, pitch, blockLight, overlay);
                } else {
                    this.renderParts(matrices, vertexConsumer, this.chestModel.partRightA, this.chestModel.partRightB, this.chestModel.partRightC, pitch, blockLight, overlay);
                }
            } else {
                this.renderParts(matrices, vertexConsumer, this.chestModel.partA, this.chestModel.partB, this.chestModel.partC, pitch, blockLight, overlay);
            }
            matrices.method_22909();
        }
    }

    private void renderParts(class_4587 matrices, class_4588 vertices, class_630 modelPart, class_630 modelPart2, class_630 modelPart3, float pitch, int light, int overlay) {
        modelPart2.field_3654 = modelPart.field_3654 = -(pitch * 1.5707964f);
        modelPart.method_22698(matrices, vertices, light, overlay);
        modelPart2.method_22698(matrices, vertices, light, overlay);
        modelPart3.method_22698(matrices, vertices, light, overlay);
    }

    private static class_1921 getChestTexture(class_2745 type, class_1921[] layers) {
        return switch (type) {
            case class_2745.field_12574 -> layers[1];
            case class_2745.field_12571 -> layers[2];
            default -> layers[0];
        };
    }

    public static class_4588 getConsumer(class_4597 provider, class_2248 block, class_2745 chestType) {
        class_1921[] layers = LAYERS.getOrDefault(block, RENDER_TYPES);
        return provider.getBuffer(BaseChestBlockEntityRenderer.getChestTexture(chestType, layers));
    }

    public static void registerRenderLayer(class_2248 block) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        String modId = blockId.method_12836();
        String path = blockId.method_12832();
        LAYERS.put(block, new class_1921[]{class_1921.method_23576((class_2960)new class_2960(modId, "textures/entity/chest/" + path + ".png")), class_1921.method_23576((class_2960)new class_2960(modId, "textures/entity/chest/" + path + "_left.png")), class_1921.method_23576((class_2960)new class_2960(modId, "textures/entity/chest/" + path + "_right.png"))});
    }
}

