/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies;

import immersive_melodies.Common;
import immersive_melodies.MidiListener;
import immersive_melodies.client.sound.CancelableSoundInstance;
import immersive_melodies.client.sound.SoundManagerImpl;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.ClientNetworkManager;
import immersive_melodies.network.Network;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.NoteBroadcastRequest;
import immersive_melodies.resources.Note;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class Client {
    private static final Map<Integer, CancelableSoundInstance> playingSounds = new ConcurrentHashMap<Integer, CancelableSoundInstance>();

    public static void postLoad() {
        class_310 client = class_310.method_1551();
        Common.networkManager = new ClientNetworkManager();
        Common.soundManager = new SoundManagerImpl(client);
        MidiListener.launch();
    }

    public static void playNote(int tone, int velocity) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && !client.method_1493() && Client.playNote((class_1297)client.field_1724, tone, velocity)) {
            Network.sendToServer(new NoteBroadcastRequest(tone, velocity));
        }
    }

    public static boolean playNote(class_1297 entity, int tone, int velocity) {
        for (class_1799 stack : entity.method_5743()) {
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof InstrumentItem)) continue;
            InstrumentItem instrument = (InstrumentItem)class_17922;
            if (entity instanceof class_746 && instrument.isPlaying(stack)) {
                Network.sendToServer(ItemActionMessage.fromState(ItemActionMessage.State.PAUSE));
            }
            if (velocity > 0) {
                if (playingSounds.containsKey(tone)) break;
                Note note = new Note(tone, velocity, 0, 10000, 200);
                CancelableSoundInstance soundInstance = instrument.playNote(entity, note, 0L);
                playingSounds.put(tone, soundInstance);
                return true;
            }
            CancelableSoundInstance soundInstance = playingSounds.get(tone);
            if (soundInstance == null) break;
            soundInstance.cancel();
            playingSounds.remove(tone);
            return true;
        }
        return false;
    }
}

