/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.item;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.Sounds;
import immersive_melodies.client.MelodyProgress;
import immersive_melodies.client.MelodyProgressManager;
import immersive_melodies.client.sound.CancelableSoundInstance;
import immersive_melodies.network.Network;
import immersive_melodies.network.s2c.MelodyListMessage;
import immersive_melodies.network.s2c.OpenGuiRequest;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.ServerMelodyManager;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class InstrumentItem
extends class_1792 {
    public static final String TAG_PLAYING = "playing";
    public static final String TAG_MELODY = "melody";
    public static final String TAG_START_TIME = "start_time";
    public static final String TAG_TRACKS = "enabled_tracks";
    private final Sounds.Instrument sound;
    private final long sustain;
    private final Vector3f offset;

    public InstrumentItem(class_1792.class_1793 settings, Sounds.Instrument sound, long sustain, Vector3f offset) {
        super(settings);
        this.sound = sound;
        this.sustain = sustain;
        this.offset = offset;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            Network.sendToPlayer(new MelodyListMessage(user), (class_3222)user);
            Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.SELECTOR), (class_3222)user);
        }
        return super.method_7836(world, user, hand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.isPlaying(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"immersive_melodies.playing").method_27692(class_124.field_1060));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public boolean isPlaying(class_1799 stack) {
        return stack.method_7948().method_10577(TAG_PLAYING);
    }

    public void inventoryClientTick(class_1799 stack, class_1937 world, class_1297 entity) {
        boolean isPrimary = false;
        for (class_1799 handItem : entity.method_5877()) {
            if (handItem == stack) {
                isPrimary = true;
                break;
            }
            if (!(handItem.method_7909() instanceof InstrumentItem)) continue;
            break;
        }
        if (this.isPlaying(stack) && isPrimary && world.field_9236 && Common.soundManager.audible(entity)) {
            MelodyProgress progress = MelodyProgressManager.INSTANCE.getProgress(entity);
            progress.tick(stack);
            MelodyProgressManager.INSTANCE.sync(world.method_8510());
            Melody melody = progress.getMelody();
            Set<Integer> enabledTracks = this.getEnabledTracks(stack);
            block1: for (int track = 0; track < melody.getTracks().size(); ++track) {
                int lastIndex = MelodyProgressManager.INSTANCE.getProgress(entity).getLastIndex(track);
                List<Note> notes = melody.getTracks().get(track).getNotes();
                for (int i = lastIndex; i < notes.size(); ++i) {
                    Note note = notes.get(i);
                    if (progress.getTime() >= (long)note.getTime()) {
                        if (enabledTracks.isEmpty() || enabledTracks.contains(track)) {
                            this.playNote(entity, note, progress.getTime());
                        }
                        if (i != notes.size() - 1) continue;
                        MelodyProgressManager.INSTANCE.setLastIndex(entity, track, i + 1);
                        continue;
                    }
                    MelodyProgressManager.INSTANCE.setLastIndex(entity, track, i);
                    continue block1;
                }
            }
            if (progress.getTime() > (long)melody.getLength()) {
                this.rewind(stack, world);
            }
        }
    }

    public CancelableSoundInstance playNote(class_1297 entity, Note note, long time) {
        int octave;
        float volume = (float)note.getVelocity() / 255.0f * 2.0f * Config.getInstance().instrumentVolumeFactor;
        float pitch = (float)Math.pow(2.0, (double)(note.getNote() - 24) / 12.0);
        for (octave = 1; octave < 8 && (double)pitch > 1.3333333333333333; ++octave) {
            pitch /= 2.0f;
        }
        long length = note.getLength();
        long sustain = Math.min(this.sustain, (long)note.getSustain());
        float factor = Config.getInstance().perceivedLoudnessAdjustmentFactor;
        float adjustedVolume = (float)((double)volume / Math.sqrt((double)pitch * Math.pow(2.0, octave - 4)));
        volume = volume * (1.0f - factor) + adjustedVolume * factor;
        CancelableSoundInstance soundInstance = Common.soundManager.playSound(entity.method_23317(), entity.method_23318(), entity.method_23321(), this.sound.get(octave), class_3419.field_15254, volume, pitch, length, sustain, (long)note.getTime() - time, entity);
        if (entity instanceof class_1657 && Config.getInstance().stopGameMusicForPlayers) {
            Common.soundManager.pauseGameMusic();
        } else if (Config.getInstance().stopGameMusicForMobs) {
            Common.soundManager.pauseGameMusic();
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!Common.soundManager.isFirstPerson(entity)) {
                double x = Math.sin((double)(-livingEntity.field_6283) / 180.0 * Math.PI);
                double z = Math.cos((double)(-livingEntity.field_6283) / 180.0 * Math.PI);
                entity.method_37908().method_8406((class_2394)class_2398.field_11224, entity.method_23317() + x * (double)this.offset.z + z * (double)this.offset.x, entity.method_23318() + (double)entity.method_17682() / 2.0 + (double)this.offset.y, entity.method_23321() + z * (double)this.offset.z - x * (double)this.offset.x, x * 5.0, 0.0, z * 5.0);
            }
        }
        MelodyProgressManager.INSTANCE.setLastNote(entity, volume, pitch, length);
        return soundInstance;
    }

    public void inventoryServerTick(class_1799 stack, class_3218 world, class_1297 entity) {
        if (!(entity instanceof class_1657) && !this.isPlaying(stack)) {
            class_2960 randomMelody = ServerMelodyManager.getRandomMelody();
            this.play(stack, randomMelody, (class_1937)world, entity);
        }
    }

    public void play(class_1799 stack, class_2960 melody, class_1937 world, class_1297 entity) {
        stack.method_7948().method_10582(TAG_MELODY, melody.toString());
        stack.method_7948().method_10556(TAG_PLAYING, true);
        stack.method_7948().method_10544(TAG_START_TIME, world.method_8510());
        this.refreshTracks(stack, entity);
    }

    public class_2960 getMelody(class_1799 stack) {
        return new class_2960(stack.method_7948().method_10558(TAG_MELODY));
    }

    public void refreshTracks(class_1799 stack, class_1297 entity) {
        String identifier = ServerMelodyManager.getIdentifier(entity, class_7923.field_41178.method_10221((Object)this));
        Set<Integer> enabledTracks = ServerMelodyManager.getSettings().getEnabledTracks(this.getMelody(stack), identifier);
        stack.method_7948().method_10539(TAG_TRACKS, enabledTracks.stream().mapToInt(i -> i).toArray());
    }

    public void rewind(class_1799 stack, class_1937 world) {
        stack.method_7948().method_10544(TAG_START_TIME, world.method_8510());
    }

    public void play(class_1799 stack) {
        stack.method_7948().method_10556(TAG_PLAYING, true);
    }

    public void pause(class_1799 stack) {
        stack.method_7948().method_10556(TAG_PLAYING, false);
    }

    public Set<Integer> getEnabledTracks(class_1799 stack) {
        if (!stack.method_7948().method_10545(TAG_TRACKS)) {
            return Set.of();
        }
        int[] array = stack.method_7948().method_10561(TAG_TRACKS);
        return Arrays.stream(array).boxed().collect(Collectors.toSet());
    }
}

