/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.Common;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.MelodyLoader;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class ServerMelodyManager {
    static final Random RANDOM = new Random();
    public static MinecraftServer server;
    private static Map<class_2960, MelodyLoader.LazyMelody> datapackMelodies;
    private static File directory;

    public static void instantiate(class_3218 world, class_32.class_5143 session) {
        directory = session.method_27424(world.method_27983()).resolve("data/melodies").toFile();
    }

    private static File getFile(String id) {
        File file = new File(directory, id.replace(":", "/") + ".bin");
        file.getParentFile().mkdirs();
        return file;
    }

    public static CustomServerMelodiesIndex getIndex() {
        return (CustomServerMelodiesIndex)server.method_30002().method_17983().method_17924(CustomServerMelodiesIndex::fromNbt, CustomServerMelodiesIndex::new, "immersive_melodies");
    }

    public static MelodyTrackSettings getSettings() {
        return (MelodyTrackSettings)server.method_30002().method_17983().method_17924(MelodyTrackSettings::fromNbt, MelodyTrackSettings::new, "immersive_melodies_settings");
    }

    public static Map<class_2960, MelodyLoader.LazyMelody> getDatapackMelodies() {
        return datapackMelodies;
    }

    public static void setDatapackMelodies(Map<class_2960, MelodyLoader.LazyMelody> datapackMelodies) {
        ServerMelodyManager.datapackMelodies = datapackMelodies;
    }

    public static class_2960 getRandomMelody() {
        Object[] custom;
        Object[] datapack = ServerMelodyManager.getDatapackMelodies().keySet().toArray();
        if (datapack.length + (custom = ServerMelodyManager.getIndex().melodies.keySet().toArray()).length == 0) {
            return Common.locate("missing");
        }
        int i = RANDOM.nextInt(datapack.length + custom.length);
        if (i < datapack.length) {
            return (class_2960)datapack[i];
        }
        return (class_2960)custom[i - datapack.length];
    }

    public static void registerMelody(class_2960 identifier, Melody melody) {
        ServerMelodyManager.getIndex().getMelodies().put(identifier, melody);
        ServerMelodyManager.getIndex().method_78(true);
        try {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            melody.encode(buffer);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ServerMelodyManager.getFile(identifier.toString())));
            bos.write(buffer.array());
            bos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteMelody(class_2960 identifier) {
        ServerMelodyManager.getIndex().getMelodies().remove(identifier);
        ServerMelodyManager.getIndex().method_78(true);
        try {
            Files.delete(ServerMelodyManager.getFile(identifier.toString()).toPath());
        }
        catch (IOException e) {
            Common.LOGGER.error("Couldn't delete melody {} ({})", (Object)identifier, (Object)e);
        }
    }

    public static Melody getMelody(class_2960 identifier) {
        if (datapackMelodies.containsKey(identifier)) {
            return datapackMelodies.get(identifier).get();
        }
        Melody melody = Melody.DEFAULT;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(ServerMelodyManager.getFile(identifier.toString())));
            melody = new Melody(new class_2540(Unpooled.wrappedBuffer((byte[])bis.readAllBytes())));
        }
        catch (Exception e) {
            Common.LOGGER.error("Couldn't load melody {} ({})", (Object)identifier, (Object)e);
            ServerMelodyManager.deleteMelody(identifier);
        }
        return melody;
    }

    public static String getIdentifier(class_1297 entity, class_1792 item) {
        return ServerMelodyManager.getIdentifier(entity, class_7923.field_41178.method_10221((Object)item));
    }

    public static String getIdentifier(class_1297 entity, class_2960 instrument) {
        return instrument.toString();
    }

    static {
        datapackMelodies = new HashMap<class_2960, MelodyLoader.LazyMelody>();
        directory = new File("data/melodies");
    }

    public static class CustomServerMelodiesIndex
    extends class_18 {
        final Map<class_2960, MelodyDescriptor> melodies = new HashMap<class_2960, MelodyDescriptor>();

        public static CustomServerMelodiesIndex fromNbt(class_2487 nbt) {
            CustomServerMelodiesIndex c = new CustomServerMelodiesIndex();
            for (String key : nbt.method_10541()) {
                class_2540 buffer = new class_2540(Unpooled.wrappedBuffer((byte[])nbt.method_10547(key)));
                c.melodies.put(new class_2960(key), new MelodyDescriptor(buffer));
            }
            return c;
        }

        public class_2487 method_75(class_2487 nbt) {
            class_2487 c = new class_2487();
            for (Map.Entry<class_2960, MelodyDescriptor> entry : this.melodies.entrySet()) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                entry.getValue().encodeLite(buffer);
                c.method_10570(entry.getKey().toString(), buffer.array());
            }
            return c;
        }

        public Map<class_2960, MelodyDescriptor> getMelodies() {
            return this.melodies;
        }
    }

    public static class MelodyTrackSettings
    extends class_18 {
        final Map<class_2960, Map<String, Set<Integer>>> enabledTracks = new HashMap<class_2960, Map<String, Set<Integer>>>();

        public static MelodyTrackSettings fromNbt(class_2487 nbt) {
            MelodyTrackSettings c = new MelodyTrackSettings();
            for (String key : nbt.method_10541()) {
                class_2487 map = nbt.method_10562(key);
                HashMap m = new HashMap();
                for (String k : map.method_10541()) {
                    class_2487 set = map.method_10562(k);
                    HashSet<Integer> s = new HashSet<Integer>();
                    for (String i : set.method_10541()) {
                        s.add(set.method_10550(i));
                    }
                    m.put(k, s);
                }
                c.enabledTracks.put(new class_2960(key), m);
            }
            return c;
        }

        public class_2487 method_75(class_2487 nbt) {
            class_2487 c = new class_2487();
            for (Map.Entry<class_2960, Map<String, Set<Integer>>> entry : this.enabledTracks.entrySet()) {
                class_2487 map = new class_2487();
                for (Map.Entry<String, Set<Integer>> e : entry.getValue().entrySet()) {
                    class_2487 set = new class_2487();
                    for (int i : e.getValue()) {
                        set.method_10569(e.getKey(), i);
                    }
                    map.method_10566(e.getKey(), (class_2520)set);
                }
                c.method_10566(entry.getKey().toString(), (class_2520)map);
            }
            return c;
        }

        public void enableTrack(class_2960 melody, String identifier, int track) {
            this.enabledTracks.computeIfAbsent(melody, k -> new HashMap()).computeIfAbsent(identifier, k -> new HashSet()).add(track);
            this.method_78(true);
        }

        public void disableTrack(class_2960 melody, String identifier, int track) {
            Map uuidSetMap = this.enabledTracks.computeIfAbsent(melody, k -> new HashMap());
            uuidSetMap.computeIfAbsent(identifier, k -> new HashSet()).remove(track);
            this.method_78(true);
        }

        public Set<Integer> getEnabledTracks(class_2960 name, String identifier) {
            Map playerSettings = this.enabledTracks.getOrDefault(name, Collections.emptyMap());
            return playerSettings.getOrDefault(identifier, playerSettings.values().stream().findFirst().orElse(Set.of()));
        }
    }
}

