/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.capability.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import fuzs.puzzleslib.api.capability.v2.CapabilityController;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.PlayerCapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.PlayerRespawnCopyStrategy;
import fuzs.puzzleslib.api.capability.v2.data.SyncStrategy;
import fuzs.puzzleslib.api.capability.v2.initializer.BlockComponentInitializerImpl;
import fuzs.puzzleslib.api.capability.v2.initializer.ChunkComponentInitializerImpl;
import fuzs.puzzleslib.api.capability.v2.initializer.EntityComponentInitializerImpl;
import fuzs.puzzleslib.api.capability.v2.initializer.WorldComponentInitializerImpl;
import fuzs.puzzleslib.impl.capability.v2.ComponentFactoryRegistry;
import fuzs.puzzleslib.impl.capability.v2.data.ComponentHolder;
import fuzs.puzzleslib.impl.capability.v2.data.FabricCapabilityKey;
import fuzs.puzzleslib.impl.capability.v2.data.FabricPlayerCapabilityKey;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;

public final class FabricCapabilityController
implements CapabilityController {
    private final String namespace;
    private final Multimap<Class<?>, Consumer<Object>> capabilityTypes = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), Lists::newArrayList);

    public FabricCapabilityController(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public <T extends class_1297, C extends CapabilityComponent> CapabilityKey<C> registerEntityCapability(String capabilityKey, Class<C> capabilityType, Function<T, C> capabilityFactory, Class<T> entityType) {
        return this.registerCapability(class_1297.class, capabilityKey, capabilityType, capabilityFactory, EntityComponentInitializerImpl.getEntityFactory(entityType));
    }

    @Override
    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String capabilityKey, Class<C> capabilityType, Function<class_1657, C> capabilityFactory, PlayerRespawnCopyStrategy respawnStrategy) {
        return this.registerCapability(class_1297.class, capabilityKey, capabilityType, capabilityFactory, EntityComponentInitializerImpl.getPlayerFactory(respawnStrategy), FabricPlayerCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String capabilityKey, Class<C> capabilityType, Function<class_1657, C> capabilityFactory, PlayerRespawnCopyStrategy respawnStrategy, SyncStrategy syncStrategy) {
        return ((FabricPlayerCapabilityKey)this.registerPlayerCapability(capabilityKey, capabilityType, capabilityFactory, respawnStrategy)).setSyncStrategy(syncStrategy);
    }

    @Override
    public <T extends class_2586, C extends CapabilityComponent> CapabilityKey<C> registerBlockEntityCapability(String capabilityKey, Class<C> capabilityType, Function<T, C> capabilityFactory, Class<T> blockEntityType) {
        return this.registerCapability(class_2586.class, capabilityKey, capabilityType, capabilityFactory, BlockComponentInitializerImpl.getBlockEntityFactory(blockEntityType));
    }

    @Override
    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelChunkCapability(String capabilityKey, Class<C> capabilityType, Function<class_2791, C> capabilityFactory) {
        return this.registerCapability(class_2818.class, capabilityKey, capabilityType, capabilityFactory, ChunkComponentInitializerImpl.getLevelChunkFactory());
    }

    @Override
    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelCapability(String capabilityKey, Class<C> capabilityType, Function<class_1937, C> capabilityFactory) {
        return this.registerCapability(class_1937.class, capabilityKey, capabilityType, capabilityFactory, WorldComponentInitializerImpl.getLevelFactory());
    }

    private <T, C extends CapabilityComponent> CapabilityKey<C> registerCapability(Class<?> objectType, String capabilityKey, Class<C> capabilityType, Function<T, C> capabilityFactory, ComponentFactoryRegistry<T> capabilityRegistry) {
        return this.registerCapability(objectType, capabilityKey, capabilityType, capabilityFactory, capabilityRegistry, FabricCapabilityKey::new);
    }

    private <T, C1 extends CapabilityComponent, C2 extends CapabilityKey<C1>> C2 registerCapability(Class<?> objectType, String capabilityKey, Class<C1> capabilityType, Function<T, C1> capabilityFactory, ComponentFactoryRegistry<T> capabilityRegistry, FabricCapabilityKey.FabricCapabilityKeyFactory<C1, C2> capabilityKeyFactory) {
        if (!VALID_CAPABILITY_TYPES.contains(objectType)) {
            throw new IllegalArgumentException(String.valueOf(objectType) + " is an invalid type");
        }
        ComponentKey componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(new class_2960(this.namespace, capabilityKey), ComponentHolder.class);
        this.capabilityTypes.put(objectType, o -> capabilityRegistry.accept(o, (ComponentKey<ComponentHolder>)componentKey, o1 -> new ComponentHolder((CapabilityComponent)capabilityFactory.apply(o1))));
        return capabilityKeyFactory.apply((ComponentKey<ComponentHolder>)componentKey, capabilityType);
    }

    public static <T> void registerComponentFactories(Class<?> baseType, T registry) {
        List<FabricCapabilityController> controllers = ModContext.getCapabilityControllers().map(FabricCapabilityController.class::cast).toList();
        for (FabricCapabilityController controller : controllers) {
            for (Consumer factoryRegistration : controller.capabilityTypes.get(baseType)) {
                factoryRegistration.accept(registry);
            }
            controller.capabilityTypes.get(baseType).clear();
        }
    }
}

