/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.client.ClientPlatformUtils;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.dimension.AdAstraPlanetRenderers;
import earth.terrarium.adastra.client.models.armor.SpaceSuitModel;
import earth.terrarium.adastra.client.models.entities.mobs.CorruptedLunarianModel;
import earth.terrarium.adastra.client.models.entities.mobs.GlacianRamModel;
import earth.terrarium.adastra.client.models.entities.mobs.LunarianModel;
import earth.terrarium.adastra.client.models.entities.mobs.MartianRaptorModel;
import earth.terrarium.adastra.client.models.entities.mobs.MoglerModel;
import earth.terrarium.adastra.client.models.entities.mobs.PygroBruteModel;
import earth.terrarium.adastra.client.models.entities.mobs.PygroModel;
import earth.terrarium.adastra.client.models.entities.mobs.StarCrawlerModel;
import earth.terrarium.adastra.client.models.entities.mobs.SulfurCreeperModel;
import earth.terrarium.adastra.client.models.entities.mobs.ZombifiedPygroModel;
import earth.terrarium.adastra.client.models.entities.vehicles.LanderModel;
import earth.terrarium.adastra.client.models.entities.vehicles.RocketModel;
import earth.terrarium.adastra.client.models.entities.vehicles.RoverModel;
import earth.terrarium.adastra.client.particle.LargeFlameParticle;
import earth.terrarium.adastra.client.particle.OxygenBubbleParticle;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.client.renderers.blocks.EnergizerBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.FlagBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.GlobeBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.GravityNormalizerBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.OxygenDistributorBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.SlidingDoorBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.CorruptedLunarianRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.GlacianRamRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.LunarianRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.LunarianWanderingTraderRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.MartianRaptorRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.MoglerRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.PygroBruteRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.PygroRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.StarCrawlerRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.SulfurCreeperRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.ZombifiedMoglerRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.ZombifiedPygroRenderer;
import earth.terrarium.adastra.client.renderers.entities.vehicles.LanderRenderer;
import earth.terrarium.adastra.client.renderers.entities.vehicles.RocketRenderer;
import earth.terrarium.adastra.client.renderers.entities.vehicles.RoverRenderer;
import earth.terrarium.adastra.client.renderers.world.OverlayRenderer;
import earth.terrarium.adastra.client.screens.PlanetsScreen;
import earth.terrarium.adastra.client.screens.machines.CoalGeneratorScreen;
import earth.terrarium.adastra.client.screens.machines.CompressorScreen;
import earth.terrarium.adastra.client.screens.machines.CryoFreezerScreen;
import earth.terrarium.adastra.client.screens.machines.EtrionicBlastFurnaceScreen;
import earth.terrarium.adastra.client.screens.machines.FuelRefineryScreen;
import earth.terrarium.adastra.client.screens.machines.GravityNormalizerScreen;
import earth.terrarium.adastra.client.screens.machines.NasaWorkbenchScreen;
import earth.terrarium.adastra.client.screens.machines.OxygenDistributorScreen;
import earth.terrarium.adastra.client.screens.machines.OxygenLoaderScreen;
import earth.terrarium.adastra.client.screens.machines.SolarPanelScreen;
import earth.terrarium.adastra.client.screens.machines.WaterPumpScreen;
import earth.terrarium.adastra.client.screens.player.OverlayScreen;
import earth.terrarium.adastra.client.screens.vehicles.LanderScreen;
import earth.terrarium.adastra.client.screens.vehicles.RocketScreen;
import earth.terrarium.adastra.client.screens.vehicles.RoverScreen;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.items.EtrionicCapacitorItem;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundSyncKeybindPacket;
import earth.terrarium.adastra.common.registry.ModBlockEntityTypes;
import earth.terrarium.adastra.common.registry.ModBlocks;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.registry.ModMenus;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.tags.ModItemTags;
import earth.terrarium.adastra.common.utils.KeybindManager;
import earth.terrarium.adastra.common.utils.radio.RadioHolder;
import earth.terrarium.botarium.client.ClientHooks;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_326;
import net.minecraft.class_3302;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_4057;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_6344;
import net.minecraft.class_719;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.minecraft.class_953;

public class AdAstraClient {
    public static final OverlayRenderer OXYGEN_OVERLAY_RENDERER = new OverlayRenderer(1083821311, () -> AdAstraConfigClient.showOxygenDistributorArea, (Supplier<class_2248>)ModBlocks.OXYGEN_DISTRIBUTOR);
    public static final OverlayRenderer GRAVITY_OVERLAY_RENDERER = new OverlayRenderer(1088302868, () -> AdAstraConfigClient.showGravityNormalizerArea, (Supplier<class_2248>)ModBlocks.GRAVITY_NORMALIZER);
    public static final class_304 KEY_TOGGLE_SUIT_FLIGHT = new class_304(ConstantComponents.TOGGLE_SUIT_FLIGHT_KEY.getString(), 86, ConstantComponents.AD_ASTRA_CATEGORY.getString());
    public static final class_304 KEY_OPEN_RADIO = new class_304(ConstantComponents.OPEN_RADIO_KEY.getString(), 82, ConstantComponents.AD_ASTRA_CATEGORY.getString());

    public static void init() {
        AdAstra.CONFIGURATOR.registerConfig(AdAstraConfigClient.class);
        AdAstraClient.registerScreens();
        AdAstraClient.registerBlockEntityRenderers();
        AdAstraClient.registerEntityRenderers();
        AdAstraClient.registerItemProperties();
        AdAstraClient.registerRenderLayers();
        AdAstraClient.registerArmor();
    }

    private static void registerScreens() {
        class_3929.method_17542((class_3917)((class_3917)ModMenus.COAL_GENERATOR.get()), CoalGeneratorScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.COMPRESSOR.get()), CompressorScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.ETRIONIC_BLAST_FURNACE.get()), EtrionicBlastFurnaceScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.OXYGEN_LOADER.get()), OxygenLoaderScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.FUEL_REFINERY.get()), FuelRefineryScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.WATER_PUMP.get()), WaterPumpScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.SOLAR_PANEL.get()), SolarPanelScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.OXYGEN_DISTRIBUTOR.get()), OxygenDistributorScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.GRAVITY_NORMALIZER.get()), GravityNormalizerScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.CRYO_FREEZER.get()), CryoFreezerScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.NASA_WORKBENCH.get()), NasaWorkbenchScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.ROCKET.get()), RocketScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.ROVER.get()), RoverScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.LANDER.get()), LanderScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModMenus.PLANETS.get()), PlanetsScreen::new);
    }

    private static void registerBlockEntityRenderers() {
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.ENERGIZER.get()), c -> new EnergizerBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.GLOBE.get()), c -> new GlobeBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.OXYGEN_DISTRIBUTOR.get()), c -> new OxygenDistributorBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.GRAVITY_NORMALIZER.get()), c -> new GravityNormalizerBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.FLAG.get()), c -> new FlagBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.SLIDING_DOOR.get()), c -> new SlidingDoorBlockEntityRenderer());
    }

    private static void registerEntityRenderers() {
        ClientHooks.registerEntityRenderer(ModEntityTypes.AIR_VORTEX, class_6344::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ROVER, RoverRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_1_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_1_LAYER, RocketRenderer.TIER_1_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_2_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_2_LAYER, RocketRenderer.TIER_2_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_3_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_3_LAYER, RocketRenderer.TIER_3_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_4_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_4_LAYER, RocketRenderer.TIER_4_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.LANDER, c -> new LanderRenderer(c, LanderModel.LAYER));
        ClientHooks.registerEntityRenderer(ModEntityTypes.LUNARIAN, LunarianRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.CORRUPTED_LUNARIAN, CorruptedLunarianRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.STAR_CRAWLER, StarCrawlerRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.MARTIAN_RAPTOR, MartianRaptorRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.PYGRO, PygroRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ZOMBIFIED_PYGRO, ZombifiedPygroRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.PYGRO_BRUTE, PygroBruteRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.MOGLER, MoglerRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ZOMBIFIED_MOGLER, ZombifiedMoglerRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.SULFUR_CREEPER, SulfurCreeperRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.LUNARIAN_WANDERING_TRADER, LunarianWanderingTraderRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.GLACIAN_RAM, GlacianRamRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ICE_SPIT, class_953::new);
    }

    public static void registerArmor() {
        ClientPlatformUtils.registerArmor(SpaceSuitModel.SPACE_SUIT_TEXTURE, SpaceSuitModel.SPACE_SUIT_LAYER, SpaceSuitModel::new, (class_1792)ModItems.SPACE_HELMET.get(), (class_1792)ModItems.SPACE_SUIT.get(), (class_1792)ModItems.SPACE_PANTS.get(), (class_1792)ModItems.SPACE_BOOTS.get());
        ClientPlatformUtils.registerArmor(SpaceSuitModel.NETHERITE_SPACE_SUIT_TEXTURE, SpaceSuitModel.NETHERITE_SPACE_SUIT_LAYER, SpaceSuitModel::new, (class_1792)ModItems.NETHERITE_SPACE_HELMET.get(), (class_1792)ModItems.NETHERITE_SPACE_SUIT.get(), (class_1792)ModItems.NETHERITE_SPACE_PANTS.get(), (class_1792)ModItems.NETHERITE_SPACE_BOOTS.get());
        ClientPlatformUtils.registerArmor(SpaceSuitModel.JET_SUIT_TEXTURE, SpaceSuitModel.JET_SUIT_LAYER, SpaceSuitModel::new, (class_1792)ModItems.JET_SUIT_HELMET.get(), (class_1792)ModItems.JET_SUIT.get(), (class_1792)ModItems.JET_SUIT_PANTS.get(), (class_1792)ModItems.JET_SUIT_BOOTS.get());
    }

    public static void onRegisterEntityLayers(ClientPlatformUtils.LayerDefinitionRegistry consumer) {
        consumer.register(RoverModel.LAYER, RoverModel::createBodyLayer);
        RocketModel.register(consumer);
        consumer.register(LanderModel.LAYER, LanderModel::createBodyLayer);
        SpaceSuitModel.register(consumer);
        consumer.register(LunarianModel.LAYER_LOCATION, LunarianModel::createBodyLayer);
        consumer.register(CorruptedLunarianModel.LAYER_LOCATION, CorruptedLunarianModel::createBodyLayer);
        consumer.register(StarCrawlerModel.LAYER_LOCATION, StarCrawlerModel::createBodyLayer);
        consumer.register(MartianRaptorModel.LAYER_LOCATION, MartianRaptorModel::createBodyLayer);
        consumer.register(PygroModel.LAYER_LOCATION, PygroModel::createBodyLayer);
        consumer.register(PygroBruteModel.LAYER_LOCATION, PygroBruteModel::createBodyLayer);
        consumer.register(ZombifiedPygroModel.LAYER_LOCATION, ZombifiedPygroModel::createBodyLayer);
        consumer.register(MoglerModel.LAYER_LOCATION, MoglerModel::createBodyLayer);
        consumer.register(SulfurCreeperModel.LAYER_LOCATION, SulfurCreeperModel::createBodyLayer);
        consumer.register(GlacianRamModel.LAYER_LOCATION, GlacianRamModel::createBodyLayer);
    }

    private static void registerItemProperties() {
        ClientHooks.registerItemProperty((class_1792)((class_1792)ModItems.ETRIONIC_CAPACITOR.get()), (class_2960)new class_2960("ad_astra", "toggled"), (stack, level, entity, i) -> EtrionicCapacitorItem.active(stack) ? 0.0f : 1.0f);
    }

    public static void registerRenderLayers() {
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.VENT.get()), (class_1921)class_1921.method_23581());
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.STEEL_DOOR.get()), (class_1921)class_1921.method_23581());
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.STEEL_TRAPDOOR.get()), (class_1921)class_1921.method_23581());
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.AERONOS_LADDER.get()), (class_1921)class_1921.method_23581());
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.STROPHAR_LADDER.get()), (class_1921)class_1921.method_23581());
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.GLACIAN_TRAPDOOR.get()), (class_1921)class_1921.method_23581());
    }

    public static void onRegisterParticles(BiConsumer<class_2396<class_2400>, ClientPlatformUtils.SpriteParticleRegistration<class_2400>> consumer) {
        consumer.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.ACID_RAIN.get()), class_719.class_720::new);
        consumer.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.LARGE_FLAME.get()), LargeFlameParticle.Provider::new);
        consumer.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.LARGE_SMOKE.get()), LargeFlameParticle.Provider::new);
        consumer.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.OXYGEN_BUBBLE.get()), OxygenBubbleParticle.Provider::new);
    }

    public static void onRegisterModels(Consumer<class_2960> consumer) {
        ModBlocks.GLOBES.stream().forEach(b -> consumer.accept(new class_2960("ad_astra", "block/%s_cube".formatted(b.getId().method_12832()))));
        consumer.accept(new class_2960("ad_astra", "block/%s_flipped".formatted(ModBlocks.AIRLOCK.getId().method_12832())));
        consumer.accept(new class_2960("ad_astra", "block/%s_flipped".formatted(ModBlocks.REINFORCED_DOOR.getId().method_12832())));
        consumer.accept(OxygenDistributorBlockEntityRenderer.TOP);
        consumer.accept(GravityNormalizerBlockEntityRenderer.TOP);
        consumer.accept(GravityNormalizerBlockEntityRenderer.TOE);
    }

    public static void onRegisterItemRenderers(BiConsumer<class_1792, class_756> consumer) {
        ModItems.GLOBES.stream().forEach(item -> consumer.accept((class_1792)item.get(), new GlobeBlockEntityRenderer.ItemRenderer()));
        consumer.accept((class_1792)ModItems.OXYGEN_DISTRIBUTOR.get(), new OxygenDistributorBlockEntityRenderer.ItemRenderer());
        consumer.accept((class_1792)ModItems.GRAVITY_NORMALIZER.get(), new GravityNormalizerBlockEntityRenderer.ItemRenderer());
        consumer.accept((class_1792)ModItems.ROVER.get(), new RoverRenderer.ItemRenderer());
        consumer.accept((class_1792)ModItems.TIER_1_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_1_LAYER, RocketRenderer.TIER_1_TEXTURE));
        consumer.accept((class_1792)ModItems.TIER_2_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_2_LAYER, RocketRenderer.TIER_2_TEXTURE));
        consumer.accept((class_1792)ModItems.TIER_3_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_3_LAYER, RocketRenderer.TIER_3_TEXTURE));
        consumer.accept((class_1792)ModItems.TIER_4_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_4_LAYER, RocketRenderer.TIER_4_TEXTURE));
    }

    public static void onRegisterHud(Consumer<ClientPlatformUtils.RenderHud> consumer) {
        consumer.accept(OverlayScreen::render);
    }

    public static void onAddItemColors(BiConsumer<class_326, class_1935[]> consumer) {
        consumer.accept((stack, i) -> i > 0 ? -1 : ((class_4057)stack.method_7909()).method_7800(stack), new class_1935[]{(class_1935)ModItems.SPACE_HELMET.get(), (class_1935)ModItems.SPACE_SUIT.get(), (class_1935)ModItems.SPACE_PANTS.get(), (class_1935)ModItems.SPACE_BOOTS.get()});
        consumer.accept((stack, i) -> i > 0 ? -1 : ((class_4057)stack.method_7909()).method_7800(stack), new class_1935[]{(class_1935)ModItems.NETHERITE_SPACE_HELMET.get(), (class_1935)ModItems.NETHERITE_SPACE_SUIT.get(), (class_1935)ModItems.NETHERITE_SPACE_PANTS.get(), (class_1935)ModItems.NETHERITE_SPACE_BOOTS.get()});
        consumer.accept((stack, i) -> i > 0 ? -1 : ((class_4057)stack.method_7909()).method_7800(stack), new class_1935[]{(class_1935)ModItems.JET_SUIT_HELMET.get(), (class_1935)ModItems.JET_SUIT.get(), (class_1935)ModItems.JET_SUIT_PANTS.get(), (class_1935)ModItems.JET_SUIT_BOOTS.get()});
    }

    public static void renderOverlays(class_4587 stack, class_4184 camera) {
        OXYGEN_OVERLAY_RENDERER.render(stack, camera);
        GRAVITY_OVERLAY_RENDERER.render(stack, camera);
    }

    public static void onAddReloadListener(BiConsumer<class_2960, class_3302> consumer) {
        consumer.accept(new class_2960("ad_astra", "planet_renderers"), (class_3302)new AdAstraPlanetRenderers());
    }

    public static void clientTick(class_310 minecraft) {
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (KEY_OPEN_RADIO.method_1436() && player.method_5854() instanceof RadioHolder) {
            RadioHandler.open(null);
        }
        if (player.method_6118(class_1304.field_6174).method_31573(ModItemTags.JET_SUITS)) {
            class_315 options = minecraft.field_1690;
            if (KEY_TOGGLE_SUIT_FLIGHT.method_1436()) {
                AdAstraConfigClient.jetSuitEnabled = !AdAstraConfigClient.jetSuitEnabled;
                class_310.method_1551().method_18858(() -> AdAstra.CONFIGURATOR.saveConfig(AdAstraConfigClient.class));
                player.method_7353(AdAstraConfigClient.jetSuitEnabled ? ConstantComponents.SUIT_FLIGHT_ENABLED : ConstantComponents.SUIT_FLIGHT_DISABLED, true);
            }
            KeybindManager.set((class_1657)player, options.field_1903.method_1434(), options.field_1867.method_1434(), AdAstraConfigClient.jetSuitEnabled);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundSyncKeybindPacket(options.field_1903.method_1434(), options.field_1867.method_1434(), AdAstraConfigClient.jetSuitEnabled));
        }
    }
}

