/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks;

import earth.terrarium.adastra.client.screens.blocks.FlagUrlScreen;
import earth.terrarium.adastra.common.blockentities.flag.FlagBlockEntity;
import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.properties.EightDirectionProperty;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagBlock
extends BasicEntityBlock
implements class_3737 {
    public static final EightDirectionProperty FACING = EightDirectionProperty.FACING;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE_BOTTOM = class_259.method_1072((class_265)class_2248.method_9541((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (class_265)class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (class_247)class_247.field_1366);
    private static final class_265 SHAPE_TOP = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)24.0, (double)9.0);

    public FlagBlock(class_4970.class_2251 properties) {
        super(properties, false);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)((Object)EightDirectionProperty.Direction.NORTH))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, HALF});
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.FLAG_INFO);
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.method_8608() && (AdAstraConfig.allowFlagImages || player.method_7338())) {
            if (state.method_11654(HALF) == class_2756.field_12607) {
                return this.action(level, pos.method_10084(), player);
            }
            return this.action(level, pos, player);
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private class_1269 action(class_1937 level, class_2338 pos, class_1657 player) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof FlagBlockEntity) {
            FlagBlockEntity entity = (FlagBlockEntity)class_25862;
            if (entity.getOwner() != null && player.method_5667().equals(entity.getOwner().getId())) {
                FlagUrlScreen.open(pos);
            } else {
                player.method_7353(ConstantComponents.NOT_THE_OWNER, true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return class_2248.method_16361((class_1922)level, (class_2338)pos.method_10074()) && level.method_8320(pos.method_10084()).method_26215();
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.method_8608() && player.method_7337()) {
            FlagBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.method_9576(level, pos, state, player);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return state.method_11654(HALF) == class_2756.field_12607 ? SHAPE_BOTTOM : SHAPE_TOP;
    }

    @Override
    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (direction.method_10166() == class_2350.class_2351.field_11052 && half == class_2756.field_12607 == (direction == class_2350.field_11036)) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) != half ? (class_2680)state.method_11657((class_2769)FACING, (Comparable)((Object)((EightDirectionProperty.Direction)((Object)neighborState.method_11654((class_2769)FACING))))) : class_2246.field_10124.method_9564();
        }
        return half == class_2756.field_12607 && direction == class_2350.field_11033 && !state.method_26184((class_4538)level, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        if (pos.method_10264() < level.method_31600() - 1 && level.method_8320(pos.method_10084()).method_26166(context)) {
            EightDirectionProperty.Direction direction = EightDirectionProperty.Direction.VALUES[class_3532.method_15357((double)((double)(context.method_8044() * 8.0f / 360.0f) + 0.5)) & 7];
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)((Object)direction));
        }
        return null;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, @NotNull class_1799 stack) {
        level.method_8501(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609));
        if (placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            class_2586 class_25862 = level.method_8321(pos.method_10084());
            if (class_25862 instanceof FlagBlockEntity) {
                FlagBlockEntity flagEntity = (FlagBlockEntity)class_25862;
                flagEntity.setOwner(player.method_7334());
            }
        }
    }

    public long method_9535(class_2680 state, class_2338 pos) {
        return class_3532.method_15371((int)pos.method_10263(), (int)pos.method_10087(state.method_11654(HALF) == class_2756.field_12607 ? 0 : 1).method_10264(), (int)pos.method_10260());
    }
}

