/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.compat.jei.drawables;

import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import java.util.Objects;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class EnergyBarDrawable
implements IDrawable {
    private final int mouseX;
    private final int mouseY;
    private final long perTick;
    private final long capacity;
    private final long maxIn;
    private final long maxOut;

    public EnergyBarDrawable(double mouseX, double mouseY, long perTick, long capacity, long maxIn, long maxOut) {
        this.mouseX = (int)mouseX;
        this.mouseY = (int)mouseY;
        this.perTick = perTick;
        this.capacity = capacity;
        this.maxIn = maxIn;
        this.maxOut = maxOut;
    }

    public int getWidth() {
        return 13;
    }

    public int getHeight() {
        return 46;
    }

    public void draw(@NotNull class_332 graphics, int xOffset, int yOffset) {
        boolean generate = this.perTick > 0L;
        long time = Objects.requireNonNull(class_310.method_1551().field_1687).method_8510();
        long amount = time % (this.capacity / this.perTick) * -this.perTick;
        long energy = generate ? amount : this.capacity - amount;
        GuiUtils.drawEnergyBar(graphics, this.mouseX, this.mouseY, xOffset, yOffset, energy, this.capacity, generate ? TooltipUtils.getEnergyGenerationPerTickComponent(this.perTick) : TooltipUtils.getEnergyUsePerTickComponent(this.perTick), TooltipUtils.getMaxEnergyInComponent(this.maxIn), TooltipUtils.getMaxEnergyOutComponent(this.maxOut));
    }
}

