/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.armor;

import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.KeybindManager;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedItemEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_5712;
import net.minecraft.class_572;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetSuitItem
extends SpaceSuitItem
implements BotariumEnergyItem<WrappedItemEnergyContainer> {
    private final long energyCapacity;

    public JetSuitItem(class_1741 material, class_1738.class_8051 type, int tankSize, int energy, class_1792.class_1793 properties) {
        super(material, type, tankSize, properties);
        this.energyCapacity = energy;
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidConstants.fromMillibuckets((long)this.tankSize), (class_3611)ModFluids.OXYGEN.get()));
        WrappedItemEnergyContainer energy = this.getEnergyStorage(stack);
        tooltipComponents.add(TooltipUtils.getEnergyComponent(energy.getStoredEnergy(), this.energyCapacity));
        tooltipComponents.add(TooltipUtils.getMaxEnergyInComponent(energy.maxInsert()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.JET_SUIT_INFO);
    }

    public WrappedItemEnergyContainer getEnergyStorage(class_1799 holder) {
        return new WrappedItemEnergyContainer(holder, (EnergyContainer)new SimpleEnergyContainer(this.energyCapacity){

            public long maxInsert() {
                return 1000L;
            }
        });
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        super.method_7888(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (player.method_6118(class_1304.field_6174) != stack) {
            return;
        }
        if (player.method_31549().field_7479) {
            return;
        }
        if (player.method_7357().method_7904(stack.method_7909())) {
            return;
        }
        if (!JetSuitItem.hasFullJetSuitSet((class_1309)player)) {
            return;
        }
        if (!KeybindManager.suitFlightEnabled(player)) {
            return;
        }
        if (!KeybindManager.jumpDown(player)) {
            return;
        }
        if (!this.canFly(player, stack)) {
            return;
        }
        if (KeybindManager.sprintDown(player)) {
            this.fullFlight(player);
            this.consume(player, stack, 100, slotId);
        } else {
            this.upwardsFlight(player);
            this.consume(player, stack, 50, slotId);
        }
    }

    protected void upwardsFlight(class_1657 player) {
        double acceleration = JetSuitItem.sigmoidAcceleration(player.field_6012, 5.0, 1.0, 2.0);
        player.method_45319(new class_243(0.0, Math.max(0.0025, acceleration /= 25.0), 0.0));
        player.field_6017 = Math.max(player.field_6017 / 1.5f, 0.0f);
    }

    protected void fullFlight(class_1657 player) {
        class_243 movement = player.method_5720().method_1029().method_1021(0.075);
        if (player.method_18798().method_1033() > 2.0) {
            return;
        }
        player.method_45319(movement);
        player.field_6017 = Math.max(player.field_6017 / 1.5f, 0.0f);
        if (!player.method_6128()) {
            player.method_23669();
        }
    }

    private boolean canFly(class_1657 player, class_1799 stack) {
        return player.method_7337() || this.getEnergyStorage(stack).getStoredEnergy() > 0L;
    }

    private void consume(class_1657 player, class_1799 stack, int amount, int slotId) {
        if (player.method_7337() || player.method_7325() || player.method_37908().method_8608()) {
            return;
        }
        ItemStackHolder stackHolder = new ItemStackHolder(stack);
        EnergyContainer container = EnergyContainer.of((ItemStackHolder)stackHolder);
        if (container == null) {
            return;
        }
        container.internalExtract((long)amount, false);
        player.method_31548().field_7548.set(slotId, (Object)stackHolder.getStack());
    }

    protected boolean isFullFlightEnabled(class_1657 player) {
        return KeybindManager.suitFlightEnabled(player) && KeybindManager.jumpDown(player) && KeybindManager.sprintDown(player);
    }

    public static double sigmoidAcceleration(double t, double peakTime, double peakAcceleration, double initialAcceleration) {
        return 2.0 * peakAcceleration / (1.0 + Math.exp(-t / peakTime)) - peakAcceleration + initialAcceleration;
    }

    public void spawnParticles(class_1937 level, class_1309 entity, class_572<?> model, class_1799 stack) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (!this.canFly(player, stack)) {
            return;
        }
        if (!JetSuitItem.hasFullJetSuitSet((class_1309)player)) {
            return;
        }
        if (!KeybindManager.suitFlightEnabled(player)) {
            return;
        }
        if (!KeybindManager.jumpDown(player) || !KeybindManager.jumpDown(player) && !KeybindManager.sprintDown(player)) {
            return;
        }
        this.spawnParticles(level, entity, (double)model.field_3401.field_3654 + 0.05, entity.method_6128() ? 0.0 : 0.8, -0.45);
        this.spawnParticles(level, entity, (double)model.field_27433.field_3654 + 0.05, entity.method_6128() ? 0.0 : 0.8, 0.45);
        this.spawnParticles(level, entity, (double)model.field_3392.field_3654 + 0.05, entity.method_6128() ? 0.1 : 0.0, -0.1);
        this.spawnParticles(level, entity, (double)model.field_3397.field_3654 + 0.05, entity.method_6128() ? 0.1 : 0.0, 0.1);
    }

    private void spawnParticles(class_1937 level, class_1309 entity, double pitch, double yOffset, double zOffset) {
        double yRot = entity.field_6283;
        double forwardOffsetX = Math.cos(yRot * Math.PI / 180.0) * zOffset;
        double forwardOffsetZ = Math.sin(yRot * Math.PI / 180.0) * zOffset;
        double sideOffsetX = Math.cos((yRot - 90.0) * Math.PI / 180.0) * pitch;
        double sideOffsetZ = Math.sin((yRot - 90.0) * Math.PI / 180.0) * pitch;
        level.method_8466((class_2394)class_2398.field_11240, true, entity.method_23317() + forwardOffsetX + sideOffsetX, entity.method_23318() + yOffset, entity.method_23321() + sideOffsetZ + forwardOffsetZ, 0.0, 0.0, 0.0);
    }

    public boolean elytraFlightTick(class_1799 stack, class_1309 entity, int flightTicks) {
        if (entity.method_37908().method_8608()) {
            return true;
        }
        if (this.field_41933 != class_1738.class_8051.field_41935) {
            return true;
        }
        int nextFlightTick = flightTicks + 1;
        if (nextFlightTick % 10 != 0) {
            return true;
        }
        if (nextFlightTick % 20 == 0) {
            stack.method_7956(1, entity, e -> e.method_20235(class_1304.field_6174));
        }
        entity.method_32876(class_5712.field_28158);
        return true;
    }

    public boolean canElytraFly(class_1799 stack, class_1309 entity) {
        class_1657 player;
        return entity instanceof class_1657 && this.canFly(player = (class_1657)entity, stack) && this.isFullFlightEnabled(player);
    }
}

