/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import io.github.fabricators_of_create.porting_lib.event.client.ClientWorldEvents;
import io.github.fabricators_of_create.porting_lib.event.client.FogEvents;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_746;
import net.minecraft.class_758;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.init.TFBiomes;

@Environment(value=EnvType.CLIENT)
public class FogHandler {
    private static final float[] spoopColors = new float[3];
    private static float spoopColor = 0.0f;
    private static boolean SKY_CHUNK_LOADED = false;
    private static float SKY_FAR = 0.0f;
    private static float SKY_NEAR = 0.0f;
    private static boolean TERRAIN_CHUNK_LOADED = false;
    private static float TERRAIN_FAR = 0.0f;
    private static float TERRAIN_NEAR = 0.0f;

    public static void fogColors(FogEvents.ColorData data, float partialTicks) {
        boolean flag = FogHandler.isSpooky(class_310.method_1551().field_1687, class_310.method_1551().field_1724);
        if (flag || spoopColor > 0.0f) {
            float[] realColors = new float[]{data.getRed(), data.getGreen(), data.getBlue()};
            float[] lerpColors = new float[]{0.50980395f, 0.4509804f, 0.5686275f};
            for (int i = 0; i < 3; ++i) {
                boolean inverse;
                float real = realColors[i];
                float spoop = lerpColors[i];
                boolean bl = inverse = real > spoop;
                FogHandler.spoopColors[i] = real == spoop ? spoop : class_3532.method_37166((float)(inverse ? spoop : real), (float)(inverse ? real : spoop), (float)spoopColor);
            }
            float shift = 0.01f * partialTicks;
            spoopColor = flag ? (spoopColor += shift) : (spoopColor -= shift);
            spoopColor = class_3532.method_15363((float)spoopColor, (float)0.0f, (float)1.0f);
            data.setRed(spoopColors[0]);
            data.setGreen(spoopColors[1]);
            data.setBlue(spoopColors[2]);
        }
    }

    public static boolean renderFog(class_758.class_4596 mode, class_5636 type, class_4184 camera, float partialTick, float renderDistance, float nearDistance, float farDistance, class_6854 shape, FogEvents.FogData fogData) {
        class_638 clientLevel;
        class_746 player;
        class_1297 class_12972;
        if (type.equals((Object)class_5636.field_27888) && (class_12972 = class_310.method_1551().field_1719) instanceof class_746 && (class_12972 = (player = (class_746)class_12972).method_37908()) instanceof class_638 && (clientLevel = (class_638)class_12972).method_28103() instanceof TwilightForestRenderInfo) {
            if (mode.equals((Object)class_758.class_4596.field_20945)) {
                if (SKY_CHUNK_LOADED) {
                    boolean spooky = FogHandler.isSpooky(clientLevel, player);
                    float far = spooky ? fogData.getFarPlaneDistance() * 0.5f : fogData.getFarPlaneDistance();
                    float near = spooky ? 0.0f : fogData.getNearPlaneDistance();
                    SKY_FAR = class_3532.method_16439((float)0.003f, (float)SKY_FAR, (float)far);
                    SKY_NEAR = class_3532.method_16439((float)(0.003f * (SKY_NEAR < near ? 0.5f : 2.0f)), (float)SKY_NEAR, (float)near);
                    fogData.setFarPlaneDistance(SKY_FAR);
                    fogData.setNearPlaneDistance(SKY_NEAR);
                    return true;
                }
                if (clientLevel.method_8477(player.method_24515())) {
                    SKY_CHUNK_LOADED = true;
                    SKY_FAR = FogHandler.isSpooky(clientLevel, player) ? fogData.getFarPlaneDistance() * 0.5f : fogData.getFarPlaneDistance();
                    SKY_NEAR = FogHandler.isSpooky(clientLevel, player) ? 0.0f : fogData.getNearPlaneDistance();
                }
            } else {
                if (TERRAIN_CHUNK_LOADED) {
                    boolean spooky = FogHandler.isSpooky(clientLevel, player);
                    float far = spooky ? fogData.getFarPlaneDistance() * 0.5f : fogData.getFarPlaneDistance();
                    float near = spooky ? far * 0.75f : fogData.getNearPlaneDistance();
                    TERRAIN_FAR = class_3532.method_16439((float)0.003f, (float)TERRAIN_FAR, (float)far);
                    TERRAIN_NEAR = class_3532.method_16439((float)(0.003f * (TERRAIN_NEAR < near ? 0.5f : 2.0f)), (float)TERRAIN_NEAR, (float)near);
                    fogData.setFarPlaneDistance(TERRAIN_FAR);
                    fogData.setNearPlaneDistance(TERRAIN_NEAR);
                    return true;
                }
                if (SKY_CHUNK_LOADED || clientLevel.method_8477(player.method_24515())) {
                    TERRAIN_CHUNK_LOADED = true;
                    TERRAIN_FAR = FogHandler.isSpooky(clientLevel, player) ? fogData.getFarPlaneDistance() * 0.5f : fogData.getFarPlaneDistance();
                    TERRAIN_NEAR = FogHandler.isSpooky(clientLevel, player) ? TERRAIN_FAR * 0.75f : fogData.getNearPlaneDistance();
                }
            }
        }
        return false;
    }

    public static void onUnload(class_310 mc, class_638 level) {
        SKY_CHUNK_LOADED = false;
        TERRAIN_CHUNK_LOADED = false;
    }

    private static boolean isSpooky(@Nullable class_638 level, @Nullable class_746 player) {
        return level != null && player != null && level.method_23753(player.method_24515()).method_40225(TFBiomes.SPOOKY_FOREST);
    }

    public static void init() {
        FogEvents.SET_COLOR.register(FogHandler::fogColors);
        FogEvents.RENDER_FOG.register(FogHandler::renderFog);
        ClientWorldEvents.UNLOAD.register(FogHandler::onUnload);
    }
}

