/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;
import twilightforest.entity.TwilightBoat;

public class TwilightBoatRenderer
extends class_897<TwilightBoat> {
    private final Map<TwilightBoat.Type, Pair<class_2960, class_554>> boatResources;

    public TwilightBoatRenderer(class_5617.class_5618 context, boolean chest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(TwilightBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new class_2960("twilightforest", TwilightBoatRenderer.getTextureLocation(type, chest)), (Object)this.createBoatModel(context, (TwilightBoat.Type)((Object)type), chest))));
    }

    private class_554 createBoatModel(class_5617.class_5618 context, TwilightBoat.Type type, boolean chest) {
        class_5601 modellayerlocation = chest ? TwilightBoatRenderer.createChestBoatModelName(type) : TwilightBoatRenderer.createBoatModelName(type);
        class_630 modelpart = context.method_32167(modellayerlocation);
        return chest ? new class_7752(modelpart) : new class_554(modelpart);
    }

    private static class_5601 createLocation(String path) {
        return new class_5601(new class_2960("twilightforest", path), "main");
    }

    public static class_5601 createBoatModelName(TwilightBoat.Type type) {
        return TwilightBoatRenderer.createLocation("boat/" + type.getName());
    }

    public static class_5601 createChestBoatModelName(TwilightBoat.Type type) {
        return TwilightBoatRenderer.createLocation("chest_boat/" + type.getName());
    }

    private static String getTextureLocation(TwilightBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(TwilightBoat boat, float boatYaw, float partialTicks, class_4587 stack, class_4597 buffer, int light) {
        float f2;
        stack.method_22903();
        stack.method_46416(0.0f, 0.375f, 0.0f);
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - boatYaw));
        float f = (float)boat.method_7533() - partialTicks;
        float f1 = boat.method_7554() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * f1 / 10.0f * (float)boat.method_7543()));
        }
        if (!class_3532.method_15347((float)(f2 = boat.method_7547(partialTicks)), (float)0.0f)) {
            stack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_554> pair = this.getModelWithLocation(boat);
        class_2960 resourcelocation = (class_2960)pair.getFirst();
        class_554 model = (class_554)pair.getSecond();
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        model.method_22952((class_1690)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexconsumer = buffer.getBuffer(model.method_23500(resourcelocation));
        model.method_2828(stack, vertexconsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 vertexconsumer1 = buffer.getBuffer(class_1921.method_23589());
            model.method_22954().method_22698(stack, vertexconsumer1, light, class_4608.field_21444);
        }
        stack.method_22909();
        super.method_3936((class_1297)boat, boatYaw, partialTicks, stack, buffer, light);
    }

    public class_2960 getTextureLocation(TwilightBoat boat) {
        return (class_2960)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<class_2960, class_554> getModelWithLocation(TwilightBoat boat) {
        return this.boatResources.get((Object)boat.getTwilightBoatType());
    }
}

