/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_7225;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.BlockstateGenerator;
import twilightforest.data.CraftingGenerator;
import twilightforest.data.ItemModelGenerator;
import twilightforest.data.LangGenerator;
import twilightforest.data.LootGenerator;
import twilightforest.data.LootModifierGenerator;
import twilightforest.data.RegistryDataGenerator;
import twilightforest.data.SoundGenerator;
import twilightforest.data.TFAdvancementGenerator;
import twilightforest.data.custom.CrumbleHornGenerator;
import twilightforest.data.custom.TransformationPowderGenerator;
import twilightforest.data.custom.stalactites.StalactiteGenerator;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.data.tags.DamageTypeTagGenerator;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.data.tags.StructureTagGenerator;

public class DataGenerators
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        FabricDataGenerator.Pack pack = gen.createPack();
        ExistingFileHelper efh = ExistingFileHelper.withResourcesFromArg();
        ProviderProvider generator = new ProviderProvider(pack, efh);
        generator.addProvider(TFAdvancementGenerator::new);
        generator.addProvider(BlockstateGenerator::new);
        generator.addProvider(ItemModelGenerator::new);
        generator.addProvider(SoundGenerator::new);
        generator.addProvider(CustomTagGenerator.BannerPatternTagGenerator::new);
        BlockTagGenerator blocktags = (BlockTagGenerator)((Object)generator.addProvider(BlockTagGenerator::new));
        generator.addProvider(CustomTagGenerator.BlockEntityTagGenerator::new);
        generator.addProvider(FluidTagGenerator::new);
        generator.addProvider((output, provider, helper) -> new ItemTagGenerator(output, provider, blocktags));
        generator.addProvider(EntityTagGenerator::new);
        generator.addProvider(CustomTagGenerator.EnchantmentTagGenerator::new);
        generator.addProvider(LootGenerator::new);
        generator.addProvider(CraftingGenerator::new);
        generator.addProvider(LootModifierGenerator::new);
        RegistryDataGenerator datapackProvider = (RegistryDataGenerator)((Object)generator.addProvider(RegistryDataGenerator::new));
        CompletableFuture<class_7225.class_7874> lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider((output, provider, helper) -> new CustomTagGenerator.WoodPaletteTagGenerator(output, lookupProvider, helper));
        generator.addProvider((output, provider, helper) -> new BiomeTagGenerator(output, lookupProvider, helper));
        generator.addProvider((output, provider, helper) -> new DamageTypeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(output -> new StructureTagGenerator(output, lookupProvider));
        generator.addProvider(CrumbleHornGenerator::new);
        generator.addProvider(TransformationPowderGenerator::new);
        generator.addProvider(StalactiteGenerator::new);
        generator.addProvider(AtlasGenerator::new);
        generator.addProvider(LangGenerator::new);
    }

    private record ProviderProvider(FabricDataGenerator.Pack pack, ExistingFileHelper helper) {
        public <T extends class_2405> T addProvider(FabricDataGenerator.Pack.Factory<T> factory) {
            return (T)this.pack.addProvider(factory);
        }

        public <T extends class_2405> T addProvider(FabricDataGenerator.Pack.RegistryDependentFactory<T> factory) {
            return (T)this.pack.addProvider(factory);
        }

        public <T extends class_2405> T addProvider(EFHDependentFactory<T> factory) {
            return (T)this.pack.addProvider(output -> factory.create(output, this.helper));
        }

        public <T extends class_2405> T addProvider(EFHRegistryDependentFactory<T> factory) {
            return (T)this.pack.addProvider((output, registries) -> factory.create(output, registries, this.helper));
        }
    }

    @FunctionalInterface
    public static interface EFHDependentFactory<T extends class_2405> {
        public T create(FabricDataOutput var1, ExistingFileHelper var2);
    }

    @FunctionalInterface
    public static interface EFHRegistryDependentFactory<T extends class_2405> {
        public T create(FabricDataOutput var1, CompletableFuture<class_7225.class_7874> var2, ExistingFileHelper var3);
    }
}

