/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.TFPart;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraMortar;
import twilightforest.entity.boss.HydraNeck;
import twilightforest.entity.boss.HydraPart;
import twilightforest.entity.boss.HydraSmallPart;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.WorldUtil;

public class Hydra
extends class_1308
implements class_1569,
EnforcedHomePoint,
MultiPartEntity {
    private static final int TICKS_BEFORE_HEALING = 1000;
    private static final int HEAD_RESPAWN_TICKS = 100;
    private static final int HEAD_MAX_DAMAGE = 120;
    private static final float ARMOR_MULTIPLIER = 8.0f;
    private static final int MAX_HEALTH = 360;
    private static float HEADS_ACTIVITY_FACTOR = 0.3f;
    private static final int SECONDARY_FLAME_CHANCE = 10;
    private static final int SECONDARY_MORTAR_CHANCE = 16;
    private static final class_2940<Optional<class_4208>> HOME_POINT = class_2945.method_12791(Hydra.class, (class_2941)class_2943.field_38825);
    private final HydraPart[] partArray;
    public final int numHeads = 7;
    public final HydraHeadContainer[] hc = new HydraHeadContainer[7];
    public final HydraSmallPart body;
    private final HydraSmallPart leftLeg;
    private final HydraSmallPart rightLeg;
    private final HydraSmallPart tail;
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795);
    private float randomYawVelocity = 0.0f;
    private int ticksSinceDamaged = 0;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();
    public boolean renderFakeHeads = true;
    private int numTicksToChaseTarget;

    public Hydra(class_1299<? extends Hydra> type, class_1937 world) {
        super(type, world);
        ArrayList<HydraPart> parts = new ArrayList<HydraPart>();
        this.body = new HydraSmallPart(this, 6.0f, 6.0f);
        this.leftLeg = new HydraSmallPart(this, 2.0f, 3.0f);
        this.rightLeg = new HydraSmallPart(this, 2.0f, 3.0f);
        this.tail = new HydraSmallPart(this, 6.0f, 2.0f);
        parts.add(this.body);
        parts.add(this.leftLeg);
        parts.add(this.rightLeg);
        parts.add(this.tail);
        for (int i = 0; i < this.numHeads; ++i) {
            this.hc[i] = new HydraHeadContainer(this, i, i < 3);
            parts.add(this.hc[i].headEntity);
            Collections.addAll(parts, this.hc[i].getNeckArray());
        }
        this.partArray = parts.toArray(new HydraPart[0]);
        this.field_5985 = true;
        this.field_6194 = 511;
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(HOME_POINT, Optional.empty());
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 360.0).method_26868(class_5134.field_23719, 0.28);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_37908().method_8501(this.method_24515().method_10069(0, 1, 0), ((class_2248)TFBlocks.HYDRA_BOSS_SPAWNER.get()).method_9564());
            this.method_31472();
            for (HydraHeadContainer container : this.hc) {
                if (container.headEntity == null) continue;
                container.headEntity.method_31472();
            }
        } else {
            super.method_5982();
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    protected float method_6031(float p_110146_1_, float p_110146_2_) {
        boolean flag;
        float f = class_3532.method_15393((float)(p_110146_1_ - this.field_6283));
        this.field_6283 += f * 0.3f;
        float f1 = class_3532.method_15393((float)(this.method_36454() - this.field_6283));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_6283 = this.method_36454() - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_6283 += f1 * 0.2f;
        }
        if (flag) {
            p_110146_2_ *= -1.0f;
        }
        return p_110146_2_;
    }

    public void method_6007() {
        int i;
        if (this.renderFakeHeads) {
            this.renderFakeHeads = false;
        }
        this.method_5646();
        this.body.method_5773();
        this.leftLeg.method_5773();
        this.rightLeg.method_5773();
        for (i = 0; i < this.numHeads; ++i) {
            this.hc[i].tick();
        }
        if (this.field_6235 > 0) {
            for (i = 0; i < this.numHeads; ++i) {
                this.hc[i].setHurtTime(this.field_6235);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.method_37908().method_8608() && this.ticksSinceDamaged > 1000 && this.ticksSinceDamaged % 5 == 0) {
            this.method_6025(1.0f);
        }
        this.setDifficultyVariables();
        super.method_6007();
        float angle = (this.field_6283 + 180.0f) * (float)Math.PI / 180.0f;
        double dx = this.method_23317() - (double)class_3532.method_15374((float)angle) * 3.0;
        double dy = this.method_23318() + 0.1;
        double dz = this.method_23321() + (double)class_3532.method_15362((float)angle) * 3.0;
        this.body.method_5814(dx, dy, dz);
        dx = this.method_23317() - (double)class_3532.method_15374((float)angle) * 10.5;
        dy = this.method_23318() + 0.1;
        dz = this.method_23321() + (double)class_3532.method_15362((float)angle) * 10.5;
        this.tail.method_5814(dx, dy, dz);
        if (this.field_6235 == 0) {
            this.collideWithEntities(this.method_37908().method_8335((class_1297)this, this.body.method_5829()), (class_1297)this.body);
            this.collideWithEntities(this.method_37908().method_8335((class_1297)this, this.tail.method_5829()), (class_1297)this.tail);
        }
        if (!this.method_37908().method_8608()) {
            this.destroyBlocksInAABB(this.body.method_5829());
            this.destroyBlocksInAABB(this.tail.method_5829());
            for (int i2 = 0; i2 < this.numHeads; ++i2) {
                if (this.hc[i2].headEntity == null || !this.hc[i2].isActive()) continue;
                this.destroyBlocksInAABB(this.hc[i2].headEntity.method_5829());
            }
            if (this.field_6012 % 20 == 0 && this.isUnsteadySurfaceBeneath()) {
                this.destroyBlocksInAABB(this.method_5829().method_989(0.0, -1.0, 0.0));
            }
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        }
    }

    public void method_5652(class_2487 compound) {
        this.saveHomePointToNbt(compound);
        compound.method_10567("NumHeads", (byte)this.countActiveHeads());
        super.method_5652(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadHomePointFromNbt(compound);
        this.activateNumberOfHeads(compound.method_10571("NumHeads"));
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    protected void method_5958() {
        int i;
        this.field_6212 = 0.0f;
        this.field_6250 = 0.0f;
        float f = 48.0f;
        for (i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].isActive() || this.hc[i].getDamageTaken() <= 120) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.DYING);
            this.hc[i].endCurrentAction();
            this.hc[i].setRespawnCounter(100);
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setRespawnCounter(100);
        }
        if (this.method_6051().method_43057() < 0.7f) {
            class_1657 entityplayer1 = this.method_37908().method_18460((class_1297)this, (double)f);
            if (entityplayer1 != null && !entityplayer1.method_7337()) {
                this.method_5980((class_1309)entityplayer1);
                this.numTicksToChaseTarget = 100 + this.method_6051().method_43048(20);
            } else {
                this.randomYawVelocity = (this.method_6051().method_43057() - 0.5f) * 20.0f;
            }
        }
        if (this.method_5968() != null) {
            this.method_5951((class_1297)this.method_5968(), 10.0f, this.method_5978());
            for (i = 0; i < this.numHeads; ++i) {
                if (this.hc[i].isAttacking() || this.hc[i].isSecondaryAttacking) continue;
                this.hc[i].setTargetEntity((class_1297)this.method_5968());
            }
            if (this.method_5968().method_5805()) {
                float distance = this.method_5968().method_5739((class_1297)this);
                if (this.method_5985().method_6369((class_1297)this.method_5968())) {
                    this.attackEntity((class_1297)this.method_5968(), distance);
                }
            }
            if (this.numTicksToChaseTarget-- <= 0 || !this.method_5968().method_5805() || this.method_5968().method_5858((class_1297)this) > (double)(f * f)) {
                this.method_5980(null);
            }
        } else {
            if (this.method_6051().method_43057() < 0.05f) {
                this.randomYawVelocity = (this.method_6051().method_43057() - 0.5f) * 20.0f;
            }
            this.method_36456(this.method_36454() + this.randomYawVelocity);
            this.method_36457(0.0f);
            for (i = 0; i < this.numHeads; ++i) {
                if (!this.hc[i].isIdle()) continue;
                this.hc[i].setTargetEntity(null);
            }
        }
        this.secondaryAttacks();
    }

    private void setDifficultyVariables() {
        HEADS_ACTIVITY_FACTOR = this.method_37908().method_8407() != class_1267.field_5807 ? 0.3f : 0.5f;
    }

    private int getRandomDeadHead() {
        ArrayList<Integer> headIDs = new ArrayList<Integer>();
        for (int i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].canRespawn()) continue;
            headIDs.add(i);
        }
        return headIDs.isEmpty() ? -1 : (Integer)headIDs.get(this.field_5974.method_43048(headIDs.size()));
    }

    private void activateNumberOfHeads(int howMany) {
        int moreHeads = howMany - this.countActiveHeads();
        for (int i = 0; i < moreHeads; ++i) {
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setNextState(HydraHeadContainer.State.IDLE);
            this.hc[otherHead].endCurrentAction();
        }
    }

    private void attackEntity(class_1297 target, float distance) {
        int i;
        int BITE_CHANCE = 10;
        int FLAME_CHANCE = 100;
        int MORTAR_CHANCE = 160;
        boolean targetAbove = target.method_5829().field_1322 > this.method_5829().field_1325;
        for (i = 0; i < 3; ++i) {
            if (!this.hc[i].isIdle() || this.areTooManyHeadsAttacking(i)) continue;
            if (distance > 4.0f && distance < 10.0f && this.method_6051().method_43048(BITE_CHANCE) == 0 && this.countActiveHeads() > 2 && !this.areOtherHeadsBiting(i)) {
                this.hc[i].setNextState(HydraHeadContainer.State.BITE_BEGINNING);
                continue;
            }
            if (distance > 0.0f && distance < 20.0f && this.method_6051().method_43048(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.method_6051().method_43048(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
        }
        for (i = 3; i < 7; ++i) {
            if (!this.hc[i].isIdle() || this.areTooManyHeadsAttacking(i)) continue;
            if (distance > 0.0f && distance < 20.0f && this.method_6051().method_43048(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.method_6051().method_43048(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
        }
    }

    private boolean areTooManyHeadsAttacking(int testHead) {
        int otherAttacks = 0;
        for (int i = 0; i < this.numHeads; ++i) {
            if (i == testHead || !this.hc[i].isAttacking()) continue;
            ++otherAttacks;
            if (!this.hc[i].isBiting()) continue;
            otherAttacks += 2;
        }
        return (float)otherAttacks >= 1.0f + (float)this.countActiveHeads() * HEADS_ACTIVITY_FACTOR;
    }

    private int countActiveHeads() {
        int count = 0;
        for (int i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].isActive()) continue;
            ++count;
        }
        return count;
    }

    private boolean areOtherHeadsBiting(int testHead) {
        for (int i = 0; i < this.numHeads; ++i) {
            if (i == testHead || !this.hc[i].isBiting()) continue;
            return true;
        }
        return false;
    }

    private void secondaryAttacks() {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].headEntity != null) continue;
            return;
        }
        class_1309 secondaryTarget = this.findSecondaryTarget(20.0);
        if (secondaryTarget != null) {
            float distance = secondaryTarget.method_5739((class_1297)this);
            for (int i = 1; i < this.numHeads; ++i) {
                if (!this.hc[i].isActive() || !this.hc[i].isIdle() || !this.isTargetOnThisSide(i, (class_1297)secondaryTarget)) continue;
                if (distance > 0.0f && distance < 20.0f && this.method_6051().method_43048(10) == 0) {
                    this.hc[i].setTargetEntity((class_1297)secondaryTarget);
                    this.hc[i].isSecondaryAttacking = true;
                    this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                    continue;
                }
                if (!(distance > 8.0f) || !(distance < 32.0f) || this.method_6051().method_43048(16) != 0) continue;
                this.hc[i].setTargetEntity((class_1297)secondaryTarget);
                this.hc[i].isSecondaryAttacking = true;
                this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
            }
        }
    }

    private boolean isTargetOnThisSide(int headNum, class_1297 target) {
        double middleDist;
        double headDist = this.distanceSqXZ((class_1297)this.hc[headNum].headEntity, target);
        return headDist < (middleDist = this.distanceSqXZ((class_1297)this, target));
    }

    private double distanceSqXZ(class_1297 headEntity, class_1297 target) {
        double distX = headEntity.method_23317() - target.method_23317();
        double distZ = headEntity.method_23321() - target.method_23321();
        return distX * distX + distZ * distZ;
    }

    @Nullable
    private class_1309 findSecondaryTarget(double range) {
        return this.method_37908().method_18467(class_1309.class, new class_238(this.method_23317(), this.method_23318(), this.method_23321(), this.method_23317() + 1.0, this.method_23318() + 1.0, this.method_23321() + 1.0).method_1009(range, range, range)).stream().filter(e -> !(e instanceof Hydra)).filter(e -> e != this.method_5968() && !this.isAnyHeadTargeting((class_1297)e) && this.method_5985().method_6369((class_1297)e) && class_1301.field_6156.test(e)).min(Comparator.comparingDouble(arg_0 -> ((Hydra)this).method_5858(arg_0))).orElse(null);
    }

    private boolean isAnyHeadTargeting(class_1297 targetEntity) {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].targetEntity == null || !this.hc[i].targetEntity.equals((Object)targetEntity)) continue;
            return true;
        }
        return false;
    }

    private void collideWithEntities(List<class_1297> entities, class_1297 part) {
        double d0 = (part.method_5829().field_1323 + part.method_5829().field_1320) / 2.0;
        double d1 = (part.method_5829().field_1321 + part.method_5829().field_1324) / 2.0;
        for (class_1297 entity : entities) {
            class_1657 player;
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337() || !(entity instanceof class_1309)) continue;
            double d2 = entity.method_23317() - d0;
            double d3 = entity.method_23321() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.method_5762(d2 / d4 * 8.0, 0.2, d3 / d4 * 8.0);
        }
    }

    private boolean isUnsteadySurfaceBeneath() {
        int minX = class_3532.method_15357((double)this.method_5829().field_1323);
        int minZ = class_3532.method_15357((double)this.method_5829().field_1321);
        int maxX = class_3532.method_15357((double)this.method_5829().field_1320);
        int maxZ = class_3532.method_15357((double)this.method_5829().field_1324);
        int minY = class_3532.method_15357((double)this.method_5829().field_1322);
        int solid = 0;
        int total = 0;
        int dy = minY - 1;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                ++total;
                if (!this.method_37908().method_8320(new class_2338(dx, dy, dz)).method_51367()) continue;
                ++solid;
            }
        }
        return (float)solid / (float)total < 0.6f;
    }

    private void destroyBlocksInAABB(class_238 box) {
        if (this.field_6213 <= 0 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            for (class_2338 pos : WorldUtil.getAllInBB(box)) {
                if (!EntityUtil.canDestroyBlock(this.method_37908(), pos, (class_1297)this)) continue;
                this.method_37908().method_22352(pos, false);
            }
        }
    }

    public int method_5978() {
        return 500;
    }

    public boolean attackEntityFromPart(HydraPart part, class_1282 source, float damage) {
        boolean tookDamage;
        if (!this.method_37908().method_8608() && source.method_49708(class_8111.field_42340)) {
            this.destroyBlocksInAABB(part.method_5829());
        }
        if (source.method_5529() == this || source.method_5526() == this) {
            return false;
        }
        if (this.getParts() != null) {
            for (PartEntity<?> partEntity : this.getParts()) {
                if (partEntity != source.method_5529() && partEntity != source.method_5526()) continue;
                return false;
            }
        }
        HydraHeadContainer headCon = null;
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].headEntity == part) {
                headCon = this.hc[i];
                continue;
            }
            if (!(part instanceof HydraNeck)) continue;
            HydraNeck neck = (HydraNeck)part;
            if (this.hc[i].headEntity != neck.head || this.hc[i].isActive()) continue;
            return false;
        }
        double range = this.calculateRange(source);
        int n = source.method_5526() instanceof HydraMortar ? 200 : 0;
        if (range > (double)(400 + n)) {
            return false;
        }
        if (headCon != null && !headCon.isActive()) {
            return false;
        }
        if (headCon != null && (double)headCon.getCurrentMouthOpen() > 0.5) {
            tookDamage = super.method_5643(source, damage);
            headCon.addDamage(damage);
        } else {
            int armoredDamage = Math.round(damage / 8.0f);
            tookDamage = super.method_5643(source, (float)armoredDamage);
            if (headCon != null) {
                headCon.addDamage(armoredDamage);
            }
        }
        if (tookDamage) {
            this.ticksSinceDamaged = 0;
        }
        return tookDamage;
    }

    private double calculateRange(class_1282 damagesource) {
        return damagesource.method_5529() != null ? this.method_5858(damagesource.method_5529()) : -1.0;
    }

    public boolean method_5643(class_1282 src, float damage) {
        class_3222 player;
        class_1297 class_12972 = src.method_5529();
        if (class_12972 instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        return src.method_48789(class_8103.field_42242) && super.method_5643(src, damage);
    }

    public boolean method_5679(class_1282 source) {
        return !source.method_49708(TFDamageTypes.HYDRA_MORTAR) && super.method_5679(source);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.partArray;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        TFPart.assignPartIDs((class_1297)this);
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    public void method_6005(double strength, double xRatio, double zRatio) {
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.HYDRA_GROWL.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.HYDRA_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.HYDRA_DEATH.get();
    }

    protected float method_6107() {
        return 2.0f;
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.method_37908().method_8608()) {
            this.bossInfo.method_5408(0.0f);
            LandmarkUtil.markStructureConquered(this.method_37908(), this, TFStructures.HYDRA_LAIR, true);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            TFLootTables.entityDropsIntoContainer((class_1309)this, cause, ((TFChestBlock)((Object)TFBlocks.MANGROVE_CHEST.get())).method_9564(), EntityUtil.bossChestLocation(this));
        }
    }

    protected boolean method_27071() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public boolean method_5809() {
        return false;
    }

    protected void method_6108() {
        int headToDie;
        int i;
        ++this.field_6213;
        if (this.field_6213 == 1) {
            for (i = 0; i < this.numHeads; ++i) {
                this.hc[i].setRespawnCounter(-1);
                if (!this.hc[i].isActive()) continue;
                this.hc[i].setNextState(HydraHeadContainer.State.IDLE);
                this.hc[i].endCurrentAction();
                this.hc[i].setHurtTime(200);
            }
        }
        if (this.field_6213 <= 140 && this.field_6213 % 20 == 0 && this.hc[headToDie = this.field_6213 / 20 - 1].isActive()) {
            this.hc[headToDie].setNextState(HydraHeadContainer.State.DYING);
            this.hc[headToDie].endCurrentAction();
        }
        if (this.field_6213 == 200) {
            if (this.method_37908() instanceof class_3218 && !this.method_41330() && (this.method_6071() || this.field_6238 > 0 && this.method_6054() && this.method_37908().method_8450().method_8355(class_1928.field_19391))) {
                int reward = this.method_6110();
                class_1303.method_31493((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (int)reward);
            }
            this.method_31472();
        }
        for (i = 0; i < 10; ++i) {
            double vx = this.method_6051().method_43059() * 0.02;
            double vy = this.method_6051().method_43059() * 0.02;
            double vz = this.method_6051().method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)(this.method_6051().method_43048(2) == 0 ? class_2398.field_11236 : class_2398.field_11203), this.method_23317() + (double)(this.method_6051().method_43057() * this.body.method_17681() * 2.0f) - (double)this.body.method_17681(), this.method_23318() + (double)(this.method_6051().method_43057() * this.body.method_17682()), this.method_23321() + (double)(this.method_6051().method_43057() * this.body.method_17681() * 2.0f) - (double)this.body.method_17681(), vx, vy, vz);
        }
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    @Override
    @Nullable
    public class_4208 getRestrictionPoint() {
        return ((Optional)this.method_5841().method_12789(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable class_4208 pos) {
        this.method_5841().method_12778(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 20;
    }
}

