/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.FeatureLogic;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.components.feature.trees.treeplacers.BranchesConfig;

public class BranchingTrunkPlacer
extends class_5141 {
    public static final Codec<BranchingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BranchingTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.intRange((int)0, (int)24).fieldOf("branch_start_offset_down").forGetter(o -> o.branchDownwardOffset), (App)BranchesConfig.CODEC.fieldOf("branch_config").forGetter(o -> o.branchesConfig), (App)Codec.BOOL.fieldOf("perpendicular_branches").forGetter(o -> o.perpendicularBranches))).apply((Applicative)instance, BranchingTrunkPlacer::new));
    private final int branchDownwardOffset;
    private final BranchesConfig branchesConfig;
    private final boolean perpendicularBranches;

    public BranchingTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, int branchDownwardOffset, BranchesConfig branchesConfig, boolean perpendicularBranches) {
        super(baseHeight, randomHeightA, randomHeightB);
        this.branchDownwardOffset = branchDownwardOffset;
        this.branchesConfig = branchesConfig;
        this.perpendicularBranches = perpendicularBranches;
    }

    protected class_5142<BranchingTrunkPlacer> method_28903() {
        return (class_5142)TFFeatureModifiers.TRUNK_BRANCHING.get();
    }

    public List<class_4647.class_5208> method_26991(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, class_5819 random, int height, class_2338 startPos, class_4643 treeConfig) {
        ArrayList leafAttachments = Lists.newArrayList();
        for (int y = 0; y <= height; ++y) {
            if (this.method_35375(worldReader, worldPlacer, random, startPos.method_10086(y), treeConfig)) continue;
            height = y;
            break;
        }
        leafAttachments.add(new class_4647.class_5208(startPos.method_10086(height), 0, false));
        int numBranches = this.branchesConfig.branchCount() + random.method_43048(this.branchesConfig.randomAddBranches() + 1);
        float offset = random.method_43057();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(worldReader, worldPlacer, startPos, leafAttachments, height - this.branchDownwardOffset + b, this.branchesConfig.length(), this.branchesConfig.spacingYaw() * (double)b + (double)offset, this.branchesConfig.downwardsPitch(), random, treeConfig, this.perpendicularBranches);
        }
        return leafAttachments;
    }

    private void buildBranch(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, class_2338 pos, List<class_4647.class_5208> leafBlocks, int height, double length, double angle, double tilt, class_5819 treeRNG, class_4643 treeConfig, boolean perpendicularBranches) {
        class_2338 src = pos.method_10086(height);
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        if (perpendicularBranches) {
            this.drawBresenhamBranch(worldReader, worldPlacer, treeRNG, src, new class_2338(dest.method_10263(), src.method_10264(), dest.method_10260()), treeConfig);
            int max = Math.max(src.method_10264(), dest.method_10264());
            for (int i = Math.min(src.method_10264(), dest.method_10264()); i < max + 1; ++i) {
                this.method_35375(worldReader, worldPlacer, treeRNG, new class_2338(dest.method_10263(), i, dest.method_10260()), treeConfig);
            }
        } else {
            this.drawBresenhamBranch(worldReader, worldPlacer, treeRNG, src, dest, treeConfig);
        }
        this.method_35375(worldReader, worldPlacer, treeRNG, dest.method_10078(), treeConfig);
        this.method_35375(worldReader, worldPlacer, treeRNG, dest.method_10067(), treeConfig);
        this.method_35375(worldReader, worldPlacer, treeRNG, dest.method_10072(), treeConfig);
        this.method_35375(worldReader, worldPlacer, treeRNG, dest.method_10095(), treeConfig);
        leafBlocks.add(new class_4647.class_5208(dest, 0, false));
    }

    private void drawBresenhamBranch(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, class_5819 random, class_2338 from, class_2338 to, class_4643 config) {
        for (class_2338 pixel : new VoxelBresenhamIterator(from, to)) {
            this.method_35375(worldReader, worldPlacer, random, pixel, config);
        }
    }
}

