/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergySnapshot;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.ApiStatus;
import team.reborn.energy.api.EnergyStorage;

@ApiStatus.Internal
public record PlatformEnergyManager(EnergyStorage energy) implements EnergyContainer
{
    public PlatformEnergyManager(class_2586 entity, class_2350 direction) {
        this((EnergyStorage)EnergyStorage.SIDED.find(entity.method_10997(), entity.method_11016(), (Object)direction));
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long insert = this.energy.insert(maxAmount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
            }
            long l = insert;
            return l;
        }
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long extract = this.energy.extract(maxAmount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
            }
            long l = extract;
            return l;
        }
    }

    @Override
    public void setEnergy(long energy) {
        if (energy > this.energy.getAmount()) {
            this.insertEnergy(energy - this.energy.getAmount(), false);
        } else if (energy < this.energy.getAmount()) {
            this.extractEnergy(this.energy.getAmount() - energy, false);
        }
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getAmount();
    }

    @Override
    public long getMaxCapacity() {
        return this.energy.getCapacity();
    }

    @Override
    public long maxInsert() {
        return this.energy.getCapacity();
    }

    @Override
    public long maxExtract() {
        return this.energy.getCapacity();
    }

    @Override
    public boolean allowsInsertion() {
        return this.energy.supportsInsertion();
    }

    @Override
    public boolean allowsExtraction() {
        return this.energy.supportsExtraction();
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        return nbt;
    }

    public void method_5448() {
        this.setEnergy(0L);
    }
}

