/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public class EntityAnimDataSyncPacket<D>
extends AbstractPacket {
    private final int entityId;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public EntityAnimDataSyncPacket(int entityId, SerializableDataTicket<D> dataTicket, D data) {
        this.entityId = entityId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.entityId);
        buf.method_10814(this.dataTicket.id());
        this.dataTicket.encode(this.data, buf);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.ENTITY_ANIM_DATA_SYNC_PACKET_ID;
    }

    public static <D> void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.method_10816();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buf.method_19772());
        Object data = dataTicket.decode(buf);
        client.execute(() -> EntityAnimDataSyncPacket.runOnThread(entityId, dataTicket, data));
    }

    private static <D> void runOnThread(int entityId, SerializableDataTicket<D> dataTicket, D data) {
        class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
        if (entity instanceof GeoEntity) {
            GeoEntity geoEntity = (GeoEntity)entity;
            geoEntity.setAnimData(dataTicket, data);
        }
    }
}

