/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.gui;

import com.tom.trading.Content;
import com.tom.trading.gui.AbstractFilteredScreen;
import com.tom.trading.gui.GuiButton;
import com.tom.trading.gui.PhantomSlot;
import com.tom.trading.gui.PlatformButton;
import com.tom.trading.gui.PlatformEditBox;
import com.tom.trading.gui.VendingMachineConfigMenu;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.ComponentJoiner;
import com.tom.trading.util.PopupMenuManager;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class VendingMachineConfigScreen
extends AbstractFilteredScreen<VendingMachineConfigMenu> {
    private static final class_2960 gui = new class_2960("toms_trading_network", "textures/gui/vending_machine_config.png");
    private PlatformEditBox nameBox;
    private class_2561 title;
    private EnumMap<BlockFaceDirection, GuiButton> sideCfgButtons = new EnumMap(BlockFaceDirection.class);
    private PopupMenuManager popup = new PopupMenuManager((class_437)this);
    private GuiButton creativeBtn;

    public VendingMachineConfigScreen(VendingMachineConfigMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.title = pTitle;
        pMenu.updateGui = this::updateGui;
    }

    protected void method_2389(class_332 gr, float pPartialTick, int pMouseX, int pMouseY) {
        gr.method_25302(gui, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (int i = 0; i < 8; ++i) {
            class_1735 s = ((VendingMachineConfigMenu)this.field_2797).method_7611(i);
            if (s.method_7677().method_7960() || (((VendingMachineConfigMenu)this.field_2797).matchNBT & 1 << i) != 0 && s.method_7677().method_7909() != Content.TAG_FILTER.get()) continue;
            gr.method_25302(gui, this.field_2776 + s.field_7873 - 1, this.field_2800 + s.field_7872 - 1, 176, 16, 18, 18);
        }
        gr.method_25298(this.field_2776 + 134, this.field_2800 + 46, 0, 16, 16, this.field_22787.method_1554().method_24153(class_1059.field_5275).method_4608(new class_2960("toms_trading_network", "block/vending_machine_front")));
    }

    protected void method_25426() {
        this.field_2792 = 176;
        this.field_2779 = 211;
        this.field_25270 = this.field_2779 - 92;
        this.sideCfgButtons.clear();
        super.method_25426();
        this.nameBox = new PlatformEditBox(this.field_22793, this.field_2776 + 7, this.field_2800 + 7, 110, 16, (class_2561)class_2561.method_43471((String)"narrator.toms_trading_network.vending_machine_name"));
        this.method_37063((class_364)this.nameBox);
        this.nameBox.method_1852(this.title.getString());
        this.nameBox.method_1863(this::onNameChanged);
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            GuiButton btn = new GuiButton(this.field_2776 + 118 + d.getX() * 16, this.field_2800 + 30 + d.getY() * 16, 0, b -> {
                int ns = this.getFacingState(d);
                if (VendingMachineConfigScreen.method_25442()) {
                    ((VendingMachineConfigMenu)this.field_2797).setSides(d, ns, !this.isAuto(d));
                } else {
                    ((VendingMachineConfigMenu)this.field_2797).setSides(d, (ns + 1) % 4, this.isAuto(d));
                }
            });
            btn.texture = gui;
            btn.texX = 176;
            this.sideCfgButtons.put(d, btn);
            this.method_37063((class_364)btn);
            btn.tooltipFactory = s -> class_7919.method_47407((class_2561)Stream.of(class_2561.method_43471((String)("tooltip.toms_trading_network.side." + d.name().toLowerCase())), class_2561.method_43471((String)("tooltip.toms_trading_network.side_config" + s)), class_2561.method_43471((String)("tooltip.toms_trading_network.side_config.auto" + (btn.texY == 34 ? 1 : 0)))).collect(ComponentJoiner.joining((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43470((String)"\n"))));
        }
        this.method_37063((class_364)new PlatformButton(this.field_2776 + 120, this.field_2800 + 7, 50, 20, (class_2561)class_2561.method_43471((String)"button.toms_trading_network.vending_machine.open_trading"), b -> this.sendButtonClick(64)));
        this.creativeBtn = new GuiButton(this.field_2776 + this.field_2792 - 18, this.field_2800 - 18, 0, b -> this.sendButtonClick(0x20 | (this.creativeBtn.getState() + 1) % 2));
        this.creativeBtn.texture = gui;
        this.creativeBtn.texX = 176;
        this.creativeBtn.texY = 50;
        this.creativeBtn.tooltipFactory = s -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("tooltip.toms_trading_network.creative_mode" + s)));
        if (this.field_22787.field_1724.method_31549().field_7477) {
            this.method_37063((class_364)this.creativeBtn);
        }
        this.updateGui();
    }

    private void onNameChanged(String name) {
        ((VendingMachineConfigMenu)this.field_2797).setName(name);
        this.title = class_2561.method_43470((String)name);
    }

    private void sendMatchNBT(int slot, boolean config) {
        this.sendButtonClick(0x60 | (config ? 16 : 0) | slot & 0xF);
    }

    private void sendButtonClick(int pPageData) {
        this.field_22787.field_1761.method_2900(((VendingMachineConfigMenu)this.field_2797).field_7763, pPageData);
    }

    public void method_25394(class_332 gr, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(gr, pMouseX, pMouseY, pPartialTick);
        super.method_25394(gr, pMouseX, pMouseY, pPartialTick);
        if (this.popup.render(gr, this.field_22793, pMouseX, pMouseY)) {
            this.method_2380(gr, pMouseX, pMouseY);
        }
    }

    protected void method_2388(class_332 gr, int pMouseX, int pMouseY) {
        gr.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.cost"), this.field_25269, 26, 0x404040, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.result"), 76, 26, 0x404040, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.input"), this.field_25269, 72, 0x404040, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.output"), 98, 72, 0x404040, false);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.popup.mouseClick(pMouseX, pMouseY, pButton)) {
            return true;
        }
        class_1735 clicked = this.getSlotUnderMouse();
        if (pButton == 1 && clicked instanceof PhantomSlot && !clicked.method_7677().method_7960()) {
            int popupSlot = clicked.method_34266();
            boolean tagFilter = clicked.method_7677().method_7909() == Content.TAG_FILTER.get();
            List<String> tags = clicked.method_7677().method_40133().map(t -> t.comp_327().toString()).toList();
            this.nameBox.setFocus(false);
            this.popup.open(pMouseX, pMouseY, new PopupMenuManager.TextFieldElement(() -> class_2561.method_43471((String)"tooltip.toms_trading_network.item_count"), s -> {
                try {
                    int c = Integer.parseInt(s);
                    ((VendingMachineConfigMenu)this.field_2797).setConfigCount(clicked, c);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }, this.field_22793, Integer.toString(clicked.method_7677().method_7947())), new PopupMenuManager.ButtonElement(() -> tagFilter ? class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{class_5244.field_24337}).method_27692(class_124.field_1063)) : class_2561.method_43469((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{(((VendingMachineConfigMenu)this.field_2797).matchNBT & 1 << popupSlot) != 0 ? class_5244.field_24336 : class_5244.field_24337}), () -> {
                ((VendingMachineConfigMenu)this.field_2797).matchNBT ^= 1 << popupSlot;
                this.sendMatchNBT(popupSlot, (((VendingMachineConfigMenu)this.field_2797).matchNBT & 1 << popupSlot) != 0);
            }), new PopupMenuManager.ButtonElement(() -> tagFilter || tags.isEmpty() ? class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)"tooltip.toms_trading_network.to_tag_filter").method_27692(class_124.field_1063)) : class_2561.method_43471((String)"tooltip.toms_trading_network.to_tag_filter"), () -> {
                if (!tags.isEmpty()) {
                    this.popup.replace((PopupMenuManager.PopupElement[])tags.stream().map(s -> new PopupMenuManager.ButtonElement(() -> class_2561.method_43470((String)s), () -> {
                        class_1799 st = new class_1799((class_1935)Content.TAG_FILTER.get(), clicked.method_7677().method_7947());
                        st.method_7948().method_10582("tag", s);
                        ((VendingMachineConfigMenu)this.field_2797).setPhantom(clicked, st);
                        this.popup.close();
                    })).toArray(PopupMenuManager.PopupElement[]::new));
                }
            }));
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.popup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 256) {
            if (this.nameBox.method_25370()) {
                this.nameBox.setFocus(false);
            } else {
                this.field_22787.field_1724.method_7346();
            }
            return true;
        }
        if (pKeyCode == 258) {
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        return !this.nameBox.method_25404(pKeyCode, pScanCode, pModifiers) && !this.nameBox.method_20315() ? super.method_25404(pKeyCode, pScanCode, pModifiers) : true;
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        if (this.popup.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        return super.method_25400(pCodePoint, pModifiers);
    }

    private void updateGui() {
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            GuiButton b = this.sideCfgButtons.get((Object)d);
            b.texY = this.isAuto(d) ? 34 : 0;
            b.setState(this.getFacingState(d));
        }
        this.creativeBtn.setState(((VendingMachineConfigMenu)this.field_2797).creativeMode);
    }

    private int getFacingState(BlockFaceDirection d) {
        return ((((VendingMachineConfigMenu)this.field_2797).inputCfg & 1 << d.ordinal()) != 0 ? 1 : 0) | ((((VendingMachineConfigMenu)this.field_2797).outputCfg & 1 << d.ordinal()) != 0 ? 2 : 0);
    }

    private boolean isAuto(BlockFaceDirection d) {
        return (((VendingMachineConfigMenu)this.field_2797).autoCfg & 1 << d.ordinal()) != 0;
    }
}

